/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "Xsqldefs.h"

static char string[2000];
/* there is no way to predict how large a string can be after vsprintf is applied.
 * For that reason I just take it so large it will almost never overflow.
 * However, there really should be a better way !*/

void SqlError(char *s,...)
{  va_list ap;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);
   fl_show_alert(string,"",sql_error(sock),1);
}

void Message(char *s,...)
{  va_list ap;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);
   fl_show_message("",string,"");
}

void Info(FD_Xsql *fd_Xsql,char *s,...)
{  va_list ap;
   int count;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);

   fl_freeze_form(fd_Xsql->Xsql);
   fl_addto_browser(fd_Xsql->XsqlMessages,string);
   
   /* Clear toplines regularly to avoid heavy memory use */
   if(fl_get_browser_maxline(fd_Xsql->XsqlMessages) > MAXLOGINFO)
   {
      for(count=1;count< (MAXLOGINFO / 2);count++)
	fl_delete_browser_line(fd_Xsql->XsqlMessages,count);
   }
   fl_unfreeze_form(fd_Xsql->Xsql);
/*
    fprintf(stderr,"%s\n",string);
*/
}

