/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

void XsqlSQLQuery(FL_OBJECT *ob, long parent)
{
   FD_Xsql    *Xsql = (FD_Xsql *)parent;
   Info_t     *I,*L;
   FD_Shower  *fd_Shw;
   SQL_FIELD  *field;
   SQL_ROW    row;
   int        x,numrows;
   char       *ptr;
   FILE       *input;
   static char query[MAXQUERY] = "SELECT ";

   switch(fl_show_choices("Choose how to enter your query :",3,
			 "Manual","Read file","Cancel",1))
   {
    case 1:
      ptr=(char *)fl_show_input("Enter SQL Select statement :",query);
      if(ptr == NULL && strlen(ptr) < 1)
	return;
      strncpy(query,ptr,MAXQUERY);
      break;
    case 2:
      ptr = (char *)fl_show_fselector("Set Inputfile","","*.sql","");
      if (ptr == NULL)
	return;
      
      if((input = fopen(ptr,"r")) == NULL)
      {
	 Message("Can't open input file");
	 return;
      }
      x=fread(query,1,MAXQUERY-1,input);
      if(query[x-1] == '\n')
	query[x-1]='\0';
      else
	query[x]='\0'; /* append terminating zero */
      fclose(input);
      break;
    case 3:
      return;
   }
   
   I = (Info_t *) malloc(sizeof(Info_t));

   I->Xsql = Xsql;
   if (ExecuteQuery(I,query))
     return;
   if((I->Res = sql_store_result(sock)) == NULL)
     return; /* This can happen with i.e. a DROP query ! */
   
   I->Allflds = I->Numflds = sql_num_fields(I->Res);

   /* Must malloc table as FreeResult will try to free it
    * when closing Browser !
    */
   I->Table = (char *)malloc(1);
   *I->Table = '\0'; /* don't need a tablename as selection is not allowed */
   
   I->Fields = (SQL_FIELD *)malloc(I->Numflds * sizeof(SQL_FIELD));

   for(x=0;x<I->Numflds;x++)
   {
      field = sql_fetch_field(I->Res);
      memcpy(&I->Fields[x],field,sizeof(SQL_FIELD));
/* JJG 8-DEC-98 override mSQL internal field lengths irrelevant in Xsqlmenu */
#ifndef USE_MYSQL
      if ( field->type != CHAR_TYPE && field->type != TEXT_TYPE) 
      I->Fields[x].length = JJGWIDTH;
#endif
      
      if((ptr = (char *)malloc(strlen(I->Fields[x].name) + 1)) == NULL)
      {
	 SqlError("Not enough memory to store fieldnames !");
	 exit(1);
      }
      strcpy(ptr,I->Fields[x].name);
      I->Fields[x].name = ptr;
      I->Fields[x].table = I->Table; /* useless to copy */
   }
   
   Message("Selection of records is disabled as it can have \n"
	   "unpredictable side effects with free queries !");
   fd_Shw = BuildShowerForm(I,"Show Free Query",PASSIVE);
   
   L = (Info_t *) fd_Shw->vdata;
   L->Res = I->Res;
   
   numrows = sql_num_rows(I->Res);/* get number of records in selection */
   
   fl_freeze_form(fd_Shw->Shower);
   
   for(x=0;x < numrows;x++)
   {
      if((row = sql_fetch_row(I->Res)) == NULL)
      {
	 SqlError("Error reading record !");
	 return;
      }
      WriteToBrowser(I,fd_Shw->Browser,row);
   }
   fl_unfreeze_form(fd_Shw->Shower);
}

