/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.archiver;

import java.io.File;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;

public class PrefixedFileSet
implements FileSet {
    private final String rootPrefix;
    private final FileSet fileSet;
    private final FileSelector[] selectors;

    public PrefixedFileSet(FileSet fileSet, String rootPrefix, FileSelector[] selectors) {
        this.fileSet = fileSet;
        this.selectors = selectors;
        this.rootPrefix = rootPrefix.length() > 0 && !rootPrefix.endsWith("/") ? rootPrefix + "/" : rootPrefix;
    }

    public String[] getExcludes() {
        return this.fileSet.getExcludes();
    }

    public FileSelector[] getFileSelectors() {
        FileSelector[] sel = this.fileSet.getFileSelectors();
        if (sel != null && this.selectors != null) {
            FileSelector[] temp = new FileSelector[sel.length + this.selectors.length];
            System.arraycopy(sel, 0, temp, 0, sel.length);
            System.arraycopy(this.selectors, 0, temp, sel.length, this.selectors.length);
            sel = temp;
        } else if (sel == null && this.selectors != null) {
            sel = this.selectors;
        }
        return sel;
    }

    public String[] getIncludes() {
        return this.fileSet.getIncludes();
    }

    public String getPrefix() {
        String prefix = this.fileSet.getPrefix();
        if (prefix == null) {
            return this.rootPrefix;
        }
        if (prefix.startsWith("/")) {
            prefix = prefix.length() > 1 ? prefix.substring(1) : "";
        }
        return this.rootPrefix + prefix;
    }

    public boolean isCaseSensitive() {
        return this.fileSet.isCaseSensitive();
    }

    public boolean isIncludingEmptyDirectories() {
        return this.fileSet.isIncludingEmptyDirectories();
    }

    public boolean isUsingDefaultExcludes() {
        return this.fileSet.isUsingDefaultExcludes();
    }

    public File getDirectory() {
        return this.fileSet.getDirectory();
    }
}

