require "eet"
require "test/unit"
require "common"

class ListTestData
	def initialize
		@strings = {}
		@strings2 = []

		5.times do |i|
			@strings[i] = WrappedString.new("rubyrocks%i" % i)
		end

		#(6..10).each do |i|
		5.times do |i|
			@strings2 << WrappedString.new("rubyrocks%i" % i)
		end
	end

	private
	def to_eet_name
		"ListTest"
	end

	def to_eet_properties
		{"stringlist_a" => [@strings],
		 "stringlist_h" => [@strings2]}
	end
end

class ListTest < Test::Unit::TestCase
	def test_list
		data = ListTestData.new.to_eet
		assert_not_nil(data)

		stream = nil

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(data)
		end

		assert_equal(1, stream.length)
		assert_equal("ListTest", stream.first.tag)

		assert_nothing_raised do
			stream = Eet::Stream.deserialize(stream.first.data)
		end

		assert_equal(10, stream.length)

		["stringlist_a", "stringlist_h"].each do |tag|
			stringlist = stream.find_all { |c| c.tag == tag }
			assert_equal(5, stringlist.length)

			(0..4).each do |i|
				str_stream = nil

				assert_nothing_raised do
					d = stringlist.shift.data
					str_stream = Eet::Stream.deserialize(d)
				end

				assert_equal(1, str_stream.length)
				assert_equal("String", str_stream.first.tag)

				foo = nil

				assert_nothing_raised do
					foo = Eet::Stream.deserialize(str_stream.first.data)
				end

				assert_equal(1, foo.length)
				assert_equal("buf", foo.first.tag)
				assert_equal("rubyrocks%i\0" % i, foo.first.data)
			end

			assert_equal([], stringlist)
		end
	end
end
