/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class FamAssoc
extends Form {
    public static String name = "Family Based Association (TDT)";
    JRadioButton tdtButton;
    JRadioButton pooButton;
    JCheckBox mpermButton;
    JCheckBox ciButton;
    JCheckBox permButton;
    JCheckBox matButton;
    JCheckBox patButton;
    JCheckBox parent1Button;
    JCheckBox parent2Button;
    JTextField mpermText;
    JTextField ciText;
    static Double CI_DEFAULT = new Double(0.95);
    static Integer MPERM_DEFAULT = new Integer(1000);

    public FamAssoc(GPLINK mf) {
        super(mf, name);
        this.validBody = true;
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        this.setStuff();
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        body.add((Component)this.tdtButton, c);
        c.gridy = 1;
        body.add((Component)this.pooButton, c);
        c.gridy = 2;
        body.add((Component)new JSeparator(0), c);
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        body.add((Component)this.ciButton, c);
        c.weightx = 1.0;
        c.gridx = 1;
        body.add((Component)this.ciText, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        body.add((Component)new JSeparator(0), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridy = 5;
        body.add((Component)this.mpermButton, c);
        c.weightx = 1.0;
        c.gridx = 1;
        body.add((Component)this.mpermText, c);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 6;
        body.add((Component)this.permButton, c);
        c.gridy = 7;
        body.add((Component)new JSeparator(0), c);
        c.gridy = 8;
        body.add((Component)this.parent1Button, c);
        c.gridy = 9;
        body.add((Component)this.parent2Button, c);
        c.gridy = 10;
        body.add((Component)this.matButton, c);
        c.gridy = 11;
        body.add((Component)this.patButton, c);
        return body;
    }

    protected String processBody() {
        String ans = "";
        if (this.tdtButton.isSelected()) {
            ans = String.valueOf(ans) + " --tdt";
        }
        if (this.parent1Button.isSelected()) {
            ans = String.valueOf(ans) + " --parentdt1";
        }
        if (this.parent2Button.isSelected()) {
            ans = String.valueOf(ans) + " --parentdt2";
        }
        if (this.permButton.isSelected()) {
            ans = String.valueOf(ans) + " --perm";
        }
        if (this.mpermButton.isSelected()) {
            ans = String.valueOf(ans) + " --mperm " + this.mpermText.getText();
        }
        if (this.pooButton.isSelected()) {
            ans = String.valueOf(ans) + " --tdt --poo";
        }
        if (this.matButton.isSelected()) {
            ans = String.valueOf(ans) + " --mat";
        }
        if (this.patButton.isSelected()) {
            ans = String.valueOf(ans) + " --pat";
        }
        if (this.ciButton.isSelected()) {
            ans = String.valueOf(ans) + " --ci " + this.ciText.getText();
        }
        ans = ans.replaceFirst(" ", "");
        return ans;
    }

    protected void isBodyValid() {
    }

    protected void setStuff() {
        this.mpermText = new JTextField(MPERM_DEFAULT.toString(), 4);
        this.ciText = new JTextField(CI_DEFAULT.toString(), 4);
        this.tdtButton = new JRadioButton("Basic TDT (--tdt)");
        this.pooButton = new JRadioButton("Parent-of-origin (--tdt --poo)");
        ButtonGroup bases = new ButtonGroup();
        bases.add(this.tdtButton);
        this.tdtButton.setSelected(true);
        bases.add(this.pooButton);
        this.permButton = new JCheckBox("Adaptive permutations (--perm)");
        this.mpermButton = new JCheckBox("max(T) permutations (--mperm)");
        FamAssoc.bundel((JToggleButton)this.mpermButton, this.mpermText);
        this.ciButton = new JCheckBox("Confidence interval on OR (--ci)");
        FamAssoc.bundel((JToggleButton)this.ciButton, this.ciText);
        this.matButton = new JCheckBox("Permutation for POO maternal transmissions (--mat)");
        this.patButton = new JCheckBox("Permutation for POO paternal transmissions (--pat)");
        this.parent1Button = new JCheckBox("Permutation for parental discordance test (--parentdt1)");
        this.parent2Button = new JCheckBox("Permutation for combined parenTDT (--parentdt2)");
        ActionListener changepm = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(FamAssoc.this.mpermButton)) {
                    FamAssoc.this.permButton.setSelected(false);
                }
                if (e.getSource().equals(FamAssoc.this.permButton)) {
                    FamAssoc.this.mpermButton.setSelected(false);
                }
            }
        };
        this.permButton.addActionListener(changepm);
        this.mpermButton.addActionListener(changepm);
        ActionListener changeC = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(FamAssoc.this.matButton)) {
                    FamAssoc.this.patButton.setSelected(false);
                    FamAssoc.this.parent1Button.setSelected(false);
                    FamAssoc.this.parent2Button.setSelected(false);
                }
                if (e.getSource().equals(FamAssoc.this.patButton)) {
                    FamAssoc.this.matButton.setSelected(false);
                    FamAssoc.this.parent1Button.setSelected(false);
                    FamAssoc.this.parent2Button.setSelected(false);
                }
                if (e.getSource().equals(FamAssoc.this.parent1Button)) {
                    FamAssoc.this.patButton.setSelected(false);
                    FamAssoc.this.matButton.setSelected(false);
                    FamAssoc.this.parent2Button.setSelected(false);
                }
                if (e.getSource().equals(FamAssoc.this.parent2Button)) {
                    FamAssoc.this.patButton.setSelected(false);
                    FamAssoc.this.parent1Button.setSelected(false);
                    FamAssoc.this.matButton.setSelected(false);
                }
            }
        };
        this.matButton.addActionListener(changeC);
        this.patButton.addActionListener(changeC);
        this.parent1Button.addActionListener(changeC);
        this.parent2Button.addActionListener(changeC);
    }
}

