/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddGenericOp
extends JDialog {
    private Project data;
    private Vector<String> allOps;
    private JTextField opName;
    private JTextField opDisc;
    private JTextField tempIn;
    private JTextField tempOut;
    private JTextField cline;
    private JList infiles;
    private DefaultListModel inlistmodel;
    private JList outfiles;
    private DefaultListModel outlistmodel;
    private BrowseButton addIn;
    private BrowseButton addOut;
    private JButton ok;
    private JButton cancel;
    private DocumentListener processIn = new DocumentListener(){

        public void changedUpdate(DocumentEvent arg0) {
        }

        public void removeUpdate(DocumentEvent arg0) {
        }

        public void insertUpdate(DocumentEvent arg0) {
            AddGenericOp.this.inlistmodel.addElement(AddGenericOp.this.tempIn.getText());
        }
    };
    private DocumentListener processOut = new DocumentListener(){

        public void changedUpdate(DocumentEvent arg0) {
        }

        public void removeUpdate(DocumentEvent arg0) {
        }

        public void insertUpdate(DocumentEvent arg0) {
            AddGenericOp.this.outlistmodel.addElement(AddGenericOp.this.tempOut.getText());
        }
    };
    private DocumentListener validateForm = new DocumentListener(){

        public void changedUpdate(DocumentEvent arg0) {
        }

        public void insertUpdate(DocumentEvent arg0) {
            AddGenericOp.this.ok.setEnabled(AddGenericOp.this.isvalid());
        }

        public void removeUpdate(DocumentEvent arg0) {
            AddGenericOp.this.ok.setEnabled(AddGenericOp.this.isvalid());
        }
    };
    private ActionListener closeForm = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            AddGenericOp.this.dispose();
        }
    };
    private ActionListener addOp = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Vector<String[]> inputfiles = new Vector<String[]>();
            AddGenericOp.this.inlistmodel.trimToSize();
            int numInput = AddGenericOp.this.inlistmodel.getSize();
            int i = 0;
            while (i < numInput) {
                inputfiles.add(new String[]{AddGenericOp.this.inlistmodel.get(i).toString(), ""});
                ++i;
            }
            Vector<String[]> outputfiles = new Vector<String[]>();
            AddGenericOp.this.outlistmodel.trimToSize();
            int numOutput = AddGenericOp.this.outlistmodel.getSize();
            int i2 = 0;
            while (i2 < numOutput) {
                outputfiles.add(new String[]{AddGenericOp.this.outlistmodel.get(i2).toString(), ""});
                ++i2;
            }
            AddGenericOp.this.data.addOperation(AddGenericOp.this.opName.getText(), AddGenericOp.this.opDisc.getText(), AddGenericOp.this.cline.getText(), null, inputfiles, outputfiles);
            try {
                File gplinkfile = new File(AddGenericOp.this.data.getLocalFolder(), String.valueOf(AddGenericOp.this.opName.getText()) + Project.GPLINK_EXT);
                if (gplinkfile.createNewFile()) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(gplinkfile));
                    out.write("0");
                    out.close();
                    if (AddGenericOp.this.data.isRemote()) {
                        StartFrame startFrame = ((AddGenericOp)AddGenericOp.this).data.frame;
                        startFrame.getClass();
                        startFrame.new StartFrame.Upload(AddGenericOp.this.data, false, AddGenericOp.this.data.getRemoteFolder(), new File[]{gplinkfile});
                    }
                }
            }
            catch (IOException e2) {
                ((AddGenericOp)AddGenericOp.this).data.frame.messanger.createError("Error trying to create the .gplink file for imported operation.", "process:ImportOpDialog()");
            }
            AddGenericOp.this.dispose();
        }
    };

    private boolean isvalid() {
        String newOp = this.opName.getText();
        for (String opName : this.allOps) {
            if (!opName.equals(newOp)) continue;
            return false;
        }
        return newOp.matches("^[\\w\\-]+$");
    }

    private void buildLayout() {
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.ok);
        buttonPane.add(this.cancel);
        JPanel root = (JPanel)this.getContentPane();
        root.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        root.add((Component)new JLabel("Operation name:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        root.add((Component)this.opName, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        root.add((Component)new JLabel("Operation Discription (optional):"), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)this.opDisc, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)new JLabel("Command line (optional):"), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)this.cline, c);
        ++c.gridy;
        c.gridwidth = 1;
        root.add((Component)new JLabel("Input files:"), c);
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)new JScrollPane(this.infiles), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 1;
        root.add((Component)this.addIn, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        root.add((Component)new JLabel("Output files:"), c);
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)new JScrollPane(this.outfiles), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 1;
        root.add((Component)this.addOut, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        root.add((Component)buttonPane, c);
    }

    public AddGenericOp(GPLINK mf) {
        super((Frame)mf, "Import a Non-PLINK operation");
        this.data = mf.data;
        this.allOps = new Vector();
        Vector<OperationInfo> temp = this.data.getAllOp();
        for (OperationInfo tempOp : temp) {
            this.allOps.add(tempOp.getName());
        }
        this.tempIn = new JTextField("");
        this.tempIn.getDocument().addDocumentListener(this.processIn);
        this.tempOut = new JTextField("");
        this.tempOut.getDocument().addDocumentListener(this.processOut);
        this.opName = new JTextField(10);
        this.opName.getDocument().addDocumentListener(this.validateForm);
        this.opDisc = new JTextField(20);
        this.cline = new JTextField(20);
        this.outlistmodel = new DefaultListModel();
        this.inlistmodel = new DefaultListModel();
        this.infiles = new JList(this.inlistmodel);
        this.outfiles = new JList(this.outlistmodel);
        this.addIn = new BrowseButton(this.tempIn);
        this.addOut = new BrowseButton(this.tempOut);
        this.ok = new JButton("OK");
        this.ok.setEnabled(false);
        this.ok.addActionListener(this.addOp);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this.closeForm);
        this.buildLayout();
        this.pack();
        this.setVisible(true);
    }

    protected class BrowseButton
    extends JButton {
        private JTextField target;
        private GCFileChooser pick;

        public BrowseButton(JTextField givenTarget) {
            super("Browse");
            this.target = givenTarget;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseButton.this.pick = new GCFileChooser(AddGenericOp.this, null, !AddGenericOp.this.data.isRemote(), false, AddGenericOp.this.data.getConn(), AddGenericOp.this.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$2(1.access$0(this.this$2)).setText(BrowseButton.access$1((BrowseButton)1.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(1 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        static /* synthetic */ JTextField access$2(BrowseButton browseButton) {
            return browseButton.target;
        }
    }
}

