/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgGlobalRequest
extends SshMessage {
    protected static final int SSH_MSG_GLOBAL_REQUEST = 80;
    private String requestName;
    private byte[] requestData;
    private boolean wantReply;

    public SshMsgGlobalRequest(String requestName, boolean wantReply, byte[] requestData) {
        super(80);
        this.requestName = requestName;
        this.wantReply = wantReply;
        this.requestData = requestData;
    }

    public SshMsgGlobalRequest() {
        super(80);
    }

    public String getMessageName() {
        return "SSH_MSG_GLOBAL_REQUEST";
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public boolean getWantReply() {
        return this.wantReply;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeString(this.requestName);
            baw.write(this.wantReply ? 1 : 0);
            if (this.requestData != null) {
                baw.write(this.requestData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.requestName = bar.readString();
            boolean bl = this.wantReply = bar.read() != 0;
            if (bar.available() > 0) {
                this.requestData = new byte[bar.available()];
                bar.read(this.requestData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

