/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.common.configuration.XmlConfigurationContext;
import com.sshtools.daemon.SshServer;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.configuration.XmlServerConfigurationContext;
import com.sshtools.daemon.forwarding.ForwardingServer;
import com.sshtools.daemon.session.SessionChannelFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDaemon {
    private static Log log = LogFactory.getLog(SshDaemon.class);

    public static void main(String[] args) {
        try {
            XmlServerConfigurationContext context = new XmlServerConfigurationContext();
            context.setServerConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.server", "server.xml"));
            context.setPlatformConfigurationResource(System.getProperty("sshtools.platform", "platform.xml"));
            ConfigurationLoader.initialize(false, context);
            XmlConfigurationContext context2 = new XmlConfigurationContext();
            context2.setFailOnError(false);
            context2.setAPIConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.config", "sshtools.xml"));
            context2.setAutomationConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.automate", "automation.xml"));
            ConfigurationLoader.initialize(false, context2);
            if (args.length > 0) {
                if (args[0].equals("-start")) {
                    SshDaemon.start();
                } else if (args[0].equals("-stop")) {
                    if (args.length > 1) {
                        SshDaemon.stop(args[1]);
                    } else {
                        SshDaemon.stop("The framework daemon is shutting down");
                    }
                } else {
                    System.out.println("Usage: SshDaemon [-start|-stop]");
                }
            } else {
                System.out.println("Usage: SshDaemon [-start|-stop]");
            }
        }
        catch (Exception e) {
            log.error("The server failed to process the " + (args.length > 0 ? args[0] : "") + " command", e);
        }
    }

    public static void start() throws IOException {
        SshServer server = new SshServer(){

            public void configureServices(ConnectionProtocol connection) throws IOException {
                connection.addChannelFactory("session", new SessionChannelFactory());
                if (ConfigurationLoader.isConfigurationAvailable(ServerConfiguration.class) && ((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getAllowTcpForwarding()) {
                    ForwardingServer forwardingServer = new ForwardingServer(connection);
                }
            }

            public void shutdown(String msg) {
            }
        };
        server.startServer();
    }

    public static void stop(String msg) throws IOException {
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), ((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getCommandPort());
            socket.getOutputStream().write(58);
            int len = msg.length() <= 255 ? msg.length() : 255;
            socket.getOutputStream().write(len);
            if (len > 0) {
                socket.getOutputStream().write(msg.substring(0, len).getBytes());
            }
            socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

