/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationRule;
import com.sshtools.common.automate.UnsupportedRuleException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutomationConfiguration {
    private HashMap remoteIdentifications = new HashMap();

    public AutomationConfiguration(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)new AutomationConfigurationSAXHandler());
    }

    public Map getRemoteIdentifications() {
        return this.remoteIdentifications;
    }

    public static void main(String[] args) {
    }

    private class AutomationConfigurationSAXHandler
    extends DefaultHandler {
        private String AUTOMATION_ELEMENT = "Automation";
        private String REMOTEID_ELEMENT = "RemoteIdentification";
        private String AUTHORIZEDKEYSFORMAT_ELEMENT = "AuthorizedKeysFormat";
        private String RULE_ELEMENT = "Rule";
        private String STARTSWITH_ATTRIBUTE = "startsWith";
        private String CONTAINS_ATTRIBUTE = "contains";
        private String DEFAULTNAME_ATTRIBUTE = "defaultName";
        private String NAME_ATTRIBUTE = "name";
        private String IMPLEMENTATION_ATTRIBUTE = "implementationClass";
        private String PRIORITY_ATTRIBUTE = "priority";
        private String DEFAULTPATH_ATTRIBUTE = "defaultPath";
        private String currentElement = null;
        private RemoteIdentification currentRID = null;

        private AutomationConfigurationSAXHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
            if (this.currentElement == null) {
                if (!qname.equals(this.AUTOMATION_ELEMENT)) {
                    throw new SAXException("Unexpected root element <" + qname + ">");
                }
            } else if (this.currentElement.equals(this.AUTOMATION_ELEMENT)) {
                if (!qname.equals(this.REMOTEID_ELEMENT)) throw new SAXException("Unexpected element <" + qname + ">");
                String defaultName = attrs.getValue(this.DEFAULTNAME_ATTRIBUTE);
                if (defaultName == null) {
                    throw new SAXException(String.valueOf(this.DEFAULTNAME_ATTRIBUTE) + " attribute must be specified");
                }
                this.currentRID = new RemoteIdentification(defaultName);
            } else {
                if (!this.currentElement.equals(this.REMOTEID_ELEMENT)) throw new SAXException("Unexpected element <" + qname + ">");
                if (qname.equals(this.RULE_ELEMENT)) {
                    String startsWith = attrs.getValue(this.STARTSWITH_ATTRIBUTE);
                    String contains = attrs.getValue(this.CONTAINS_ATTRIBUTE);
                    String name = attrs.getValue(this.NAME_ATTRIBUTE);
                    String priority = attrs.getValue(this.PRIORITY_ATTRIBUTE);
                    try {
                        RemoteIdentificationRule rule = new RemoteIdentificationRule();
                        if (startsWith != null) {
                            rule.addExpression(this.STARTSWITH_ATTRIBUTE, startsWith);
                        }
                        if (contains != null) {
                            rule.addExpression(this.CONTAINS_ATTRIBUTE, contains);
                        }
                        if (name != null) {
                            rule.setName(name);
                        }
                        try {
                            if (priority != null) {
                                rule.setPriority(Integer.parseInt(priority));
                            }
                        }
                        catch (NumberFormatException ex1) {
                            throw new SAXException("Failed to parse priority value! value=" + priority);
                        }
                        this.currentRID.addRule(rule);
                    }
                    catch (UnsupportedRuleException ure) {
                        throw new SAXException(ure.getMessage());
                    }
                }
                if (!qname.equals(this.AUTHORIZEDKEYSFORMAT_ELEMENT)) throw new SAXException("Unexpected element <" + qname + ">");
                String implementationClass = attrs.getValue(this.IMPLEMENTATION_ATTRIBUTE);
                String defaultPath = attrs.getValue(this.DEFAULTPATH_ATTRIBUTE);
                if (implementationClass == null) {
                    throw new SAXException(String.valueOf(this.IMPLEMENTATION_ATTRIBUTE) + " attribute is required");
                }
                try {
                    this.currentRID.setAuthorizedKeysFormat(Class.forName(implementationClass));
                    this.currentRID.setAuthorizedKeysDefaultPath(defaultPath);
                }
                catch (ClassNotFoundException ex) {
                    throw new SAXException(ex.getMessage());
                }
            }
            this.currentElement = qname;
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (this.currentElement != null) {
                if (!this.currentElement.equals(qname)) {
                    throw new SAXException("Unexpected end element found <" + qname + ">");
                }
                if (this.currentElement.equals(this.REMOTEID_ELEMENT)) {
                    if (this.currentRID.getRules().size() <= 0) {
                        throw new SAXException("<" + this.REMOTEID_ELEMENT + "> " + " requires at least one child <" + this.RULE_ELEMENT + "> element!");
                    }
                    AutomationConfiguration.this.remoteIdentifications.put(this.currentRID.getDefaultName(), this.currentRID);
                    this.currentElement = this.AUTOMATION_ELEMENT;
                } else if (this.currentElement.equals(this.RULE_ELEMENT)) {
                    this.currentElement = this.REMOTEID_ELEMENT;
                } else if (this.currentElement.equals(this.AUTHORIZEDKEYSFORMAT_ELEMENT)) {
                    this.currentElement = this.REMOTEID_ELEMENT;
                } else if (this.currentElement.equals(this.AUTOMATION_ELEMENT)) {
                    this.currentElement = null;
                } else {
                    throw new SAXException("Unexpected end element <" + qname + ">");
                }
            }
        }
    }
}

