/* vmhd.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"


void quicktime_vmhd_init(quicktime_vmhd_t *vmhd)
{
	vmhd->version = 0;
	vmhd->flags = 1;
	vmhd->graphics_mode = 64;
	vmhd->opcolor[0] = 32768;
	vmhd->opcolor[1] = 32768;
	vmhd->opcolor[2] = 32768;
}

void quicktime_vmhd_init_video(quicktime_t *file, 
								quicktime_vmhd_t *vmhd, 
								int frame_w,
								int frame_h, 
								float frame_rate)
{
}

void quicktime_vmhd_delete(quicktime_vmhd_t *vmhd)
{
}

void quicktime_vmhd_dump(quicktime_vmhd_t *vmhd)
{
	printf("    video media header\n");
	printf("     version %d\n", vmhd->version);
	printf("     flags %ld\n", vmhd->flags);
	printf("     graphics_mode %d\n", vmhd->graphics_mode);
	printf("     opcolor %d %d %d\n", vmhd->opcolor[0], vmhd->opcolor[1], vmhd->opcolor[2]);
}

void quicktime_read_vmhd(quicktime_t *file, quicktime_vmhd_t *vmhd)
{
	int i;
	vmhd->version = quicktime_read_char(file);
	vmhd->flags = quicktime_read_int24(file);
	vmhd->graphics_mode = quicktime_read_int16(file);
	for(i = 0; i < 3; i++)
		vmhd->opcolor[i] = quicktime_read_int16(file);
}

void quicktime_write_vmhd(quicktime_t *file, quicktime_vmhd_t *vmhd)
{
	quicktime_atom_t atom;
	int i;
	quicktime_atom_write_header(file, &atom, "vmhd");

	quicktime_write_char(file, vmhd->version);
	quicktime_write_int24(file, vmhd->flags);
	quicktime_write_int16(file, vmhd->graphics_mode);
	
	for(i = 0; i < 3; i++)
		quicktime_write_int16(file, vmhd->opcolor[i]);

	quicktime_atom_write_footer(file, &atom);
}

