/* dinf.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"

void quicktime_dinf_init(quicktime_dinf_t *dinf)
{
	quicktime_dref_init(&(dinf->dref));
}

void quicktime_dinf_delete(quicktime_dinf_t *dinf)
{
	quicktime_dref_delete(&(dinf->dref));
}

void quicktime_dinf_init_all(quicktime_dinf_t *dinf)
{
	quicktime_dref_init_all(&(dinf->dref));
}

void quicktime_dinf_dump(quicktime_dinf_t *dinf)
{
	printf("    data information (dinf)\n");
	quicktime_dref_dump(&(dinf->dref));
}

void quicktime_read_dinf(quicktime_t *file, quicktime_dinf_t *dinf, quicktime_atom_t *dinf_atom)
{
	quicktime_atom_t leaf_atom;

	do
	{
		quicktime_atom_read_header(file, &leaf_atom);
		if(quicktime_atom_is(&leaf_atom, "dref"))
			{ quicktime_read_dref(file, &(dinf->dref)); }
		else
			quicktime_atom_skip(file, &leaf_atom);
	}while(quicktime_position(file) < dinf_atom->end);
}

void quicktime_write_dinf(quicktime_t *file, quicktime_dinf_t *dinf)
{
	quicktime_atom_t atom;
	quicktime_atom_write_header(file, &atom, "dinf");
	quicktime_write_dref(file, &(dinf->dref));
	quicktime_atom_write_footer(file, &atom);
}
