//
// $Id: ZlibStreamTest.m,v 1.8 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if defined(HAVE_ZLIB)

#import "ZlibStreamTest.h"
#import "Random.h"
#import <ObjectiveLib/ZlibOutStream.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/ZlibInStream.h>
#import <ObjectiveLib/DataInStream.h>
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Reaper.h>
#import <ObjectiveLib/Exception.h>
#else
#import <Foundation/NSData.h>
#import <Foundation/NSException.h>
#import <Foundation/NSString.h>
#endif
#include <stdlib.h>
#import <string.h>
#import <limits.h>

@implementation ZlibStreamTest

- (void) testConvenienceAllocators
{
    OLDataOutStream* dout;
    OLZlibOutStream* zout;
    OLZlibInStream* zin;
    int val;

    dout = REAP([OLDataOutStream stream]);
    zout = REAP([OLZlibOutStream streamWithOutStream: dout]);
    [zout writeInt: 75];
    [zout close];
    zin = REAP([OLZlibInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    val = [zin readInt];
    if (val != 75)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 75, but got %i", val];
    }
}

- (void) testInitializers
{
    OLZlibOutStream* zout = nil;
    OLDataOutStream* dout;
    int i = 0;

    dout = REAP([OLDataOutStream stream]);

    TRY

        for (i = 0; i < 10; i++)
        {
            zout = [[OLZlibOutStream alloc] initWithOutStream: dout compressionLevel: i];
            [zout RELEASE];
        }

    CATCH

        [self errInFile: __FILE__ line: __LINE__
            format: "(level %i) %s: %s",
            i, EXCEPTION_NAME, EXCEPTION_MESSAGE];

    END_CATCH

    TRY
    
        zout = [[OLZlibOutStream alloc] initWithOutStream: dout compressionLevel: 10];

    CATCH

        [self logMessage: "Got expected exception:\n  %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];

    END_CATCH

    [zout RELEASE];
}

- (void) testZlibStreams
{
    uint8_t srcBuf[256];
    uint8_t destBuf[256];
    int i;
    OLDataOutStream* dout;
    OLZlibOutStream* zout;
    OLZlibInStream* zin;
    OLDataInStream* din;
    unsigned streamed;
    uint8_t* srcBuf2;
    uint8_t* destBuf2;
    unsigned bigBufSize = 1024 * 1024;

    dout = [[OLDataOutStream alloc] init];
    zout = [[OLZlibOutStream alloc] initWithOutStream: dout compressionLevel: 6 bufferSize: 1];
    for (i = 0; i < 256; i++)
        srcBuf[i] = i;
    streamed = [zout writeBytes: srcBuf count: 256];
    if (streamed != 256)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 256, but got %u", streamed];
    }
    [zout RELEASE];
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    zin = [[OLZlibInStream alloc] initWithInStream: din bufferSize: 1];
    [din RELEASE];
    streamed = [zin readBytes: destBuf count: 256];
    if (streamed != 256)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 256, but got %u", streamed];
    }
    streamed = [zin readBytes: destBuf count: 700];
    if (streamed != UINT_MAX)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected end-of-stream, but got %u", streamed];
    }
    [zin RELEASE];
    if (memcmp(srcBuf, destBuf, 256) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The inflated data are wrong"];
    }
    srcBuf2 = malloc(bigBufSize);
    for (i = 0; i < bigBufSize; i++)
        srcBuf2[i] = OLRandom() % 256;
    dout = [[OLDataOutStream alloc] init];
    zout = [[OLZlibOutStream alloc] initWithOutStream: dout compressionLevel: 9];
    streamed = [zout writeBytes: srcBuf2 count: bigBufSize];
    if (streamed != bigBufSize)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %u, but got %u", bigBufSize, streamed];
    }
    [self logMessage: "Compressed %u bytes to %u bytes",
        bigBufSize, [dout count]];
    [zout RELEASE];
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    zin = [[OLZlibInStream alloc] initWithInStream: din];
    [din RELEASE];
    destBuf2 = malloc(bigBufSize);
    streamed = [zin readBytes: destBuf2 count: bigBufSize];
    if (streamed != bigBufSize)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected %u, but got %u", bigBufSize, streamed];
    }
    streamed = [zin readBytes: destBuf2 count: 700];
    if (streamed != UINT_MAX)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected end-of-stream, but got %u", streamed];
    }
    [zin RELEASE];
    if (memcmp(srcBuf2, destBuf2, bigBufSize) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The inflated data are wrong"];
    }
}

@end

#endif
