//
// $Id: UnitTest.h,v 1.10 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */


#import <stdio.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/Set.h>

@interface UnitTest :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject
#endif
{
@private
    FILE*           outStream;
    FILE*           errStream;
    int             errorCount;
    OLVector*       tests;
@protected
    OLSet*          failedTests;

}

#if defined(OL_NO_OPENSTEP)
+ (id) initialize;
#else
+ (void) initialize;
#endif

- (id) init;
- (id) initWithOut: (FILE*)o err: (FILE*)e;
- (id) initWithUnitTest: (UnitTest*)other;
#if defined(OL_NO_OPENSTEP)
- (id) free;
#else
- (void) dealloc;
#endif

- (int) compare: (id)other;
#if defined(OL_NO_OPENSTEP)
- (id) copy;
#endif
- (void) errInFile: (const char*)file line: (int)line format: (const char* const)format, ...;
- (FILE*) errStream;
- (int) errorCount;
- (BOOL) hasTestWithName: (const char*)test;
- (void) listFailedTestsToStream: (FILE*)stream delimiter: (char)delim;
- (id) lookUpTestWithName: (const char*)name;
- (void) logMessage: (const char* const)format, ...;
- (BOOL) preventAutoLoad;
- (FILE*) outStream;
- (void) runAllTests;
- (void) runTest: (id)test;
- (BOOL) runTestWithName: (const char*)name;
- (void) setStreamOut: (FILE*)o err: (FILE*)e;
- (BOOL) setUp;
- (BOOL) tearDown;
- (int) testCount;
- (OLVector*) testListQualified: (BOOL)flag;

@end

