//
// $Id: ThreadServices.m,v 1.1 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#include "ThreadServices.h"

#if defined(OL_WIN32_THREADS)

#if defined(OL_HAVE_WIN32_ONCE)
static BOOL __initOnceCallback(PINIT_ONCE once, PVOID param, PVOID* ctx)
{
    *(OLInitFunction)param;
    return TRUE;
}
#endif

int OLOnce(OLOnceControl* onceControl, OLInitFunction initFunction)
{
#if defined(OL_HAVE_WIN32_ONCE)
    return InitOnceExecuteOnce(onceControl, __initOnceCallback, initFunction, NULL) ? 0 : 1;
#else
    if (*onceControl == 0)
    {
        initFunction();
        *onceControl = 1;
    }
    return 0;
#endif
}

#endif
