//
// $Id: PriorityQueueTest.m,v 1.18 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "PriorityQueueTest.h"
#import "Random.h"
#import <ObjectiveLib/Queue.h>
#import <ObjectiveLib/Algorithm.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSData.h>
#import <Foundation/NSArchiver.h>
#if defined(HAVE_KEYED_ARCHIVES)
#import <Foundation/NSKeyedArchiver.h>
#endif
#endif
#include <stdlib.h>
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation PriorityQueueTest

#if !defined(OL_NO_OPENSTEP)
- (void) testCoding
{
    NSMutableData* data;
    NSArchiver* archiver;
    NSData* archData;
    OLPriorityQueue* q1;
    OLPriorityQueue* q2;
    OLNumber* num;
    int i;


    q1 = [[OLPriorityQueue alloc] init];
    for (i = 0; i< 5000; i++)
    {
        num = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        [q1 push: num];
        [num RELEASE];
    }
    data = [[NSMutableData alloc] initWithCapacity: 5000];
    archiver = [[NSArchiver alloc] initForWritingWithMutableData: data];
    [archiver encodeRootObject: q1];
    [archiver RELEASE];
    q2 = [NSUnarchiver unarchiveObjectWithData: data];
    [data RELEASE];
    if (![q1 isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The deques should be equal"];
    }
#if defined(HAVE_KEYED_ARCHIVES)
    archData = [NSKeyedArchiver archivedDataWithRootObject: q1];
    q2 = [NSKeyedUnarchiver unarchiveObjectWithData: archData];
    if (![q1 isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The deques should be equal"];
    }
#endif
    [q1 RELEASE];
}
#endif

- (void) testConvenienceAllocators
{
    OLPriorityQueue* q;
    OLPriorityQueue* q2;
    OLNumber* num;
    OLGreater* greater;
    OLVector* v;

    q = REAP([OLPriorityQueue priorityQueue]);
    if (![q IS_MEMBER_OF: [OLPriorityQueue class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLPriorityQueue class])->name, ((Class)[q class])->name];
    }
    if (![q empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queue should be empty"];
    }
    v = [[OLVector alloc] init];
    num = [[OLNumber alloc] initWithInt: 1];
    [v pushBack: num];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [v pushBack: num];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    [v pushBack: num];
    [num RELEASE];
    q = REAP([OLPriorityQueue priorityQueueFrom: REAP([v begin]) to: REAP([v end])]);
    if (![q IS_MEMBER_OF: [OLPriorityQueue class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLPriorityQueue class])->name, ((Class)[q class])->name];
    }
    if ([q size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %u", [q size]];
    }
    if ([[q top] intValue] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [[q top] intValue]];
    }
    [q pop];
    if ([[q top] intValue] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %i", [[q top] intValue]];
    }
    [q pop];
    if ([[q top] intValue] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [[q top] intValue]];
    }
    greater = [[OLGreater alloc] init];
    q = REAP([OLPriorityQueue priorityQueueFrom: REAP([v begin]) to: REAP([v end])
        predicate: greater]);
    [v RELEASE];
    if (![q IS_MEMBER_OF: [OLPriorityQueue class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLPriorityQueue class])->name, ((Class)[q class])->name];
    }
    if ([q size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %u", [q size]];
    }
    if ([[q top] intValue] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [[q top] intValue]];
    }
    [q pop];
    if ([[q top] intValue] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %i", [[q top] intValue]];
    }
    [q pop];
    if ([[q top] intValue] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [[q top] intValue]];
    }
    q2 = REAP([OLPriorityQueue priorityQueueWithPredicate: greater]);
    [greater RELEASE];
    if (![q IS_MEMBER_OF: [OLPriorityQueue class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLPriorityQueue class])->name, ((Class)[q class])->name];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    [q2 push: num];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [q2 push: num];
    [num RELEASE];
    if ([[q2 top] intValue] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [[q2 top] intValue]];
    }
    q2 = REAP([OLPriorityQueue priorityQueueWithPriorityQueue: q]);
    if (![q isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queues should be equal"];
    }
}

- (void) testInitializers
{
    OLPriorityQueue* q;
    OLPriorityQueue* q2;
    OLGreater* greater;
    OLNumber* num;
    OLVector* v;
    int i;

    q = [[OLPriorityQueue alloc] init];
    if ([q size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [q size]];
    }
    [q RELEASE];
    greater = [[OLGreater alloc] init];
    q = [[OLPriorityQueue alloc] initWithPredicate: greater];
    if ([q size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [q size]];
    }
    [q RELEASE];
    v = [[OLVector alloc] initWithCapacity: 10000];
    for (i = 0; i < 10000; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        [v pushBack: num];
        [num RELEASE];
    }
    [OLAlgorithm randomShuffleFrom: REAP([v begin]) to: REAP([v end])];
    q = [[OLPriorityQueue alloc] initFrom: REAP([v begin]) to: REAP([v end])];
    if ([q size] != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %i", [q size]];
    }
    if ([[q top] intValue] != 9999)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 9999, but got %i", [[q top] intValue]];
    }
    [q RELEASE];
    q = [[OLPriorityQueue alloc] initFrom: REAP([v begin]) to: REAP([v end])
        predicate: greater];
    [greater RELEASE];
    [v RELEASE];
    if ([q size] != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %i", [q size]];
    }
    if ([[q top] intValue] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [[q top] intValue]];
    }
    q2 = [[OLPriorityQueue alloc] initWithPriorityQueue: q];
    if ([q2 size] != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %i", [q2 size]];
    }
    if ([[q2 top] intValue] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [[q2 top] intValue]];
    }
    if (![q isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queues are equal"];
    }
    [q RELEASE];
    [q2 RELEASE];
}

- (void) testPop
{
    OLPriorityQueue* q;
    OLNumber* num;
    int i;

    q = [[OLPriorityQueue alloc] init];
    for (i = 0; i < 10000; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        [q push: num];
        [num RELEASE];
    }
    for (i = 9999; i >= 0; i--)
    {
        if ([[q top] intValue] != i)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i", i, [[q top] intValue]];
        }
        [q pop];
    }
    if ([q size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [q size]];
    }
    [q RELEASE];
}

- (void) testProperties
{
    OLPriorityQueue* q;
    OLPriorityQueue* q2;

    q = [[OLPriorityQueue alloc] init];
    if ([q size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [q size]];
    }
    if (![q empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queue is empty"];
    }
    [q push: @"one"];
    q2 = [[OLPriorityQueue alloc] init];
    if ([q isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queues are not equal"];
    }
    [q2 push: @"one"];
    if (![q isEqual: q2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queues are equal"];
    }
    [q RELEASE];
    [q2 RELEASE];
}

- (void) testPush
{
    OLPriorityQueue* q;
    OLNumber* num;
    int i;

    q = [[OLPriorityQueue alloc] init];
    for (i = 0; i < 3; i++)
    {
        num = [[OLNumber alloc] initWithInt: i];
        [q push: num];
        [num RELEASE];
    }
    if ([q size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [q size]];
    }
    if ([[q top] intValue] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %i", [[q top] intValue]];
    }
    [q RELEASE];
}

- (void) testStreaming
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLPriorityQueue* queue;
    OLPriorityQueue* readQueue;
    OLNumber* num;
    int i;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    queue = [[OLPriorityQueue alloc] init];
    for (i = 0; i< 10000; i++)
    {
        num = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        [queue push: num];
        [num RELEASE];
    }
    [oout writeObject: queue];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    readQueue = REAP([oin readObject]);
    if (![readQueue IS_MEMBER_OF: [OLPriorityQueue class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected OLPriorityQueue class, but got %s", ((Class)[readQueue class])->name];
    }
    if (![readQueue isEqual: queue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The queues should be equal"];
    }
    [queue RELEASE];
}

@end
