// $Id: ConstantStringTest.m,v 1.2 2007/03/06 20:42:21 will_mason Exp $
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "ConstantStringTest.h"
#import <ObjectiveLib/Text.h>
#import <string.h>

@implementation ConstantStringTest

- (void) testClassAccessor
{
    OLConstantString* db = @"doggyboy";

    if (strcmp([db name], "OLConstantString") != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"OLConstantString\" but got \"%s\"", [db name]];
    }
    if (![db IS_MEMBER_OF: [OLConstantString class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The constant string is a member of %s",
            [[db class] name]];
    }
}

- (void) testCompare
{
    OLText* text;
    OLTextBuffer* buffer;
    int rc;

    rc = [@"doggyboy" compare: @"doggyboy"];
    if (rc != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should have been equal, got %i", rc];
    }
    if (![@"doggyboy" isEqual: @"doggyboy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should have been equal"];
    }
    rc = [@"doggyboy" compare: @"coggyboy"];
    if (rc <= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should be greater than \"coggyboy\", got %i", rc];
    }
    if ([@"doggyboy" isEqual: @"coggyboy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should not have been equal"];
    }
    rc = [@"doggyboy" compare: @"eoggyboy"];
    if (rc >= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should be less than \"eoggyboy\", got %i", rc];
    }
    if ([@"doggyboy" isEqual: @"eoggyboy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should not have been equal"];
    }
    buffer = [[OLTextBuffer alloc] init];
    rc = [@"doggyboy" compare: buffer];
    if (rc == 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should not be equal to a text buffer, got %i", rc];
    }
    if ([@"doggyboy" isEqual: buffer])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "A constant string cannot be equal to a text buffer"];
    }
    [buffer RELEASE];
    text = [[OLText alloc] initWithCString: "doggyboy"];
    rc = [@"doggyboy" compare: text];
    if (rc != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should have been equal, got %i", rc];
    }
    if (![@"doggyboy" isEqual: text])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should have been equal"];
    }
    [text RELEASE];
    text = [[OLText alloc] initWithCString: "coggyboy"];
    rc = [@"doggyboy" compare: text];
    if (rc <= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should be greater than \"coggyboy\", got %i", rc];
    }
    if ([@"doggyboy" isEqual: text])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should not have been equal"];
    }
    [text RELEASE];
    text = [[OLText alloc] initWithCString: "eoggyboy"];
    rc = [@"doggyboy" compare: text];
    if (rc >= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should be less than \"eoggyboy\", got %i", rc];
    }
    if ([@"doggyboy" isEqual: text])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The strings should not have been equal"];
    }
    [text RELEASE];
    text = [[OLText alloc] initWithCString: "bba"];
    rc = [@"bb" compare: text];
    [text RELEASE];
    if (rc >= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"bb\" should be less than \"bba\""];
    }
    text = [[OLText alloc] initWithCString: "bb"];
    rc = [@"bba" compare: text];
    [text RELEASE];
    if (rc <= 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"bba\" should be greater than \"bb\""];
    }
}

- (void) testCopyFree
{
    OLConstantString* str = @"doggyboy";
    OLConstantString* str2 = [str copy];

    if (str != str2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"bba\" should be greater than \"bb\""];
    }
    [str2 RELEASE];
    if (![str isEqual: @"doggyboy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggyboy\" should still exist"];
    }
}

- (void) testProperties
{
    OLConstantString* strs[] = { @"one", @"two", @"three", @"four", @"five",
                                 @"six", @"seven", @"eight", @"nine", @"ten" };
    unsigned hashes[10];
    int i;
    int j;
    int count;

    if (strcmp("one", [strs[0] cString]) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"one\" is not equal to \"%s\"", [strs[0] cString]];
    }
    if ([strs[0] length] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"%s\" has incorrect length of %u", [strs[0] cString], [strs[0] length]];
    }
    for (i = 0; i < 10; i++)
        hashes[i] = [strs[i] hash];
    for (i = 0; i < 10; i++)
        [self logMessage: "%5s hashes to: %#0.8x", [strs[i] cString], hashes[i]];
    for (i = 0; i < 10; i++)
    {
        count = 0;
        for (j = 0; j < 10; j++)
        {
            if (hashes[i] == hashes[j])
                count++;
        }
        if (count > 1)
            [self logMessage: "Got %i collisions of hash %x", count - 1, hashes[i]];
    }
}

@end
