//
// $Id: BufferingStreamTest.m,v 1.6 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "BufferingStreamTest.h"
#import <ObjectiveLib/BufferingOutStream.h>
#import <ObjectiveLib/BufferingInStream.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Reaper.h>
#endif
#import <string.h>
#import <limits.h>

@implementation BufferingStreamTest

- (void) bufferInImpl: (OLBufferingInStream*)bin
{
    OLDataInStream* din;
    uint8_t readBuf[256];
    unsigned numRead;
    int i;

    din = [[OLDataInStream alloc] initWithBytes: testData count: 256];
    [din RELEASE];
    numRead = [bin readBytes: readBuf count: 31];
    if (numRead != 31)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 31, but got %u", numRead];
    }
    numRead = [bin readBytes: readBuf + 31 count: 9];
    if (numRead != 9)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 9, but got %u", numRead];
    }
    numRead = [bin readBytes: readBuf + 40 count: 60];
    if (numRead != 60)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 60, but got %u", numRead];
    }
    for (i = 0; i < 100; i++)
        readBuf[100 + i] = [bin readByte];
    if (memcmp(readBuf, testData, 200) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The data got corrupted"];
    }
    numRead = [bin readBytes: readBuf + 200 count: 300];
    if (numRead != 56)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 56, but got %u", numRead];
    }
    numRead = [bin readBytes: readBuf count: 75];
    if (numRead != UINT_MAX)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected UINT_MAX, but got %u", numRead];
    }
    if (memcmp(readBuf, testData, 256) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The data got corrupted"];
    }
}

- (void) bufferOutImpl: (OLBufferingOutStream*)bout data: (OLDataOutStream*) dout
{
    unsigned written;
    int i;

    written = [bout writeBytes: testData count: 31];
    if (written != 31)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 31, but got %u", written];
    }
    written = [bout writeBytes: testData + 31 count: 9];
    if (written != 9)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 9, but got %u", written];
    }
    written = [bout writeBytes: testData + 40 count: 60];
    if (written != 60)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 60, but got %u", written];
    }
    for (i = 0; i < 100; i++)
        [bout writeByte: testData[100 + i]];
    [bout flush];
    if ([dout count] != 200)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 200, but got %u", [dout count]];
    }
    written = [bout writeBytes: testData + 200 count: 33];
    if (written != 33)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 33, but got %u", written];
    }
    written = [bout writeBytes: testData + 233 count: 23];
    if (written != 23)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 23, but got %u", written];
    }
    [bout close];
    if ([dout count] != 256)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 256, but got %u", [dout count]];
    }
    if (memcmp([dout bytes], testData, [dout count]) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The data got corrupted"];
    }
}

- (BOOL) setUp
{
    int i;

    for (i = 0; i < 256; i++)
        testData[i] = i;
    return YES;
}

- (void) testBufferingIn
{
    OLDataInStream* din;
    OLBufferingInStream* bin;

    din = [[OLDataInStream alloc] initWithBytes: testData count: 256];
    bin = [[OLBufferingInStream alloc] initWithInStream: din bufferSize: 32];
    [din RELEASE];
    [self bufferInImpl: bin];
    [bin RELEASE];
}

- (void) testBufferingOut
{
    OLBufferingOutStream* bout;
    OLDataOutStream* dout;

    dout = REAP([OLDataOutStream stream]);
    bout = [[OLBufferingOutStream alloc]
        initWithOutStream: dout bufferSize: 32];
    [self bufferOutImpl: bout data: dout];
    [bout RELEASE];
}

- (void) testConvenienceIn
{
    OLDataInStream* din;
    OLBufferingInStream* bin;

    din = [[OLDataInStream alloc] initWithBytes: testData count: 256];
    bin = REAP([OLBufferingInStream streamWithInStream: din]);
    [din RELEASE];
    [self bufferInImpl: bin];
}

- (void) testConvenienceOut
{
    OLBufferingOutStream* bout;
    OLDataOutStream* dout;

    dout = REAP([OLDataOutStream stream]);
    bout = REAP([OLBufferingOutStream streamWithOutStream: dout]);
    [self bufferOutImpl: bout data: dout];
}

@end
