//
// $Id: BasicStreamTest.m,v 1.12 2007/03/28 03:16:52 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "BasicStreamTest.h"
#import "Random.h"
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#if !defined(OL_NO_OPENSTEP)
#import <Foundation/NSData.h>
#endif
#import <stdlib.h>
#import <limits.h>
#import <string.h>

@implementation BasicStreamTest

#if !defined(OL_NO_OPENSTEP)
- (void) testEncodeBytes
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    uint8_t buf[10000];
    unsigned retLength;
    int i;
    uint8_t* retBuf;


    for (i = 0; i < 10000; i++)
        buf[i] = i % 256;
    dout = [[OLDataOutStream alloc] init];
    [dout encodeBytes: buf length: 10000];
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    retBuf = [din decodeBytesWithReturnedLength: &retLength];
    if (retLength != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %u", retLength];
    }
    if (memcmp(buf, retBuf, 10000) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The arrays should be equal"];
    }
    [din RELEASE];
}

- (void) testEncodeDataObject
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    NSMutableData* data;
    NSData* retData;
    int i;
    uint8_t byte;

    data = [[NSMutableData alloc] init];
    for (i = 0; i < 100000; i++)
    {
        byte = OLRandom() % 256;
        [data appendBytes: &byte length: 1];
    }
    dout = [[OLDataOutStream alloc] init];
    [dout encodeDataObject: data];
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    retData = [din decodeDataObject];
    if (![data isEqual: retData])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The objects should be equal"];
    }
    [data RELEASE];
    [din RELEASE];
}

- (void) testEncodeObjCTypes
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    char ch;
    short sh;
    int i;
    long l;
    long long ll;
    float f;
    double d;
    SEL s;
    char* str;
    uint8_t arr[] = { 0, 1, 2, 3 };
    int* pi;
    typedef struct __StructOne
    {
        int one;
        long two;
    } StructOne;
    typedef struct __StructTwo
    {
        struct __StructOne sone;
        float flt;
        double dbl;
    } StructTwo;
    struct __StructTwo s2;
    uint8_t readArr[4];

    dout = [[OLDataOutStream alloc] init];
    ch = 42;
    [self logMessage: "Encoding: %s", @encode(char)];
    [dout encodeValueOfObjCType: @encode(char) at: &ch];
    sh = 30000;
    [self logMessage: "Encoding: %s", @encode(short)];
    [dout encodeValueOfObjCType: @encode(short) at: &sh];
    i = 1000000000;
    [self logMessage: "Encoding: %s", @encode(int)];
    [dout encodeValueOfObjCType: @encode(int) at: &i];
    l = 1000000001L;
    [self logMessage: "Encoding: %s", @encode(long)];
    [dout encodeValueOfObjCType: @encode(long) at: &l];
    ll = 5000000000LL;
    [self logMessage: "Encoding: %s", @encode(long long)];
    [dout encodeValueOfObjCType: @encode(long long) at: &ll];
    f = 2.5;
    [self logMessage: "Encoding: %s", @encode(float)];
    [dout encodeValueOfObjCType: @encode(float) at: &f];
    d = 4.2;
    [self logMessage: "Encoding: %s", @encode(double)];
    [dout encodeValueOfObjCType: @encode(double) at: &d];
    s = @selector(testEncodeObjCTypes);
    [self logMessage: "Encoding: %s", @encode(SEL)];
    [dout encodeValueOfObjCType: @encode(SEL) at: &s];
    str = "My dog has fleas";
    [self logMessage: "Encoding: %s", @encode(char*)];
    [dout encodeValueOfObjCType: @encode(char*) at: &str];
    [self logMessage: "Encoding: %s", @encode(uint8_t[4])];
    [dout encodeValueOfObjCType: @encode(uint8_t[4]) at: &arr];
    pi = &i;
    [self logMessage: "Encoding: %s", @encode(int*)];
    [dout encodeValueOfObjCType: @encode(int*) at: &pi];
    s2.sone.one = 1;
    s2.sone.two = 2;
    s2.flt = 1.5;
    s2.dbl = 2.5;
    [self logMessage: "Encoding: %s", @encode(StructTwo)];
    [dout encodeValueOfObjCType: @encode(StructTwo) at: &s2];
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    ch = 0;
    [din decodeValueOfObjCType: @encode(char) at: &ch];
    if (ch != 42)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 42, but got %i", ch];
    }
    sh = 0;
    [din decodeValueOfObjCType: @encode(short) at: &sh];
    if (sh != 30000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 30000, but got %i", sh];
    }
    i = 0;
    [din decodeValueOfObjCType: @encode(int) at: &i];
    if (i != 1000000000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000000, but got %i", i];
    }
    l = 0;
    [din decodeValueOfObjCType: @encode(long) at: &l];
    if (l != 1000000001)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000001, but got %li", l];
    }
    ll = 0;
    [din decodeValueOfObjCType: @encode(long long) at: &ll];
    if (ll != 5000000000LL)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5000000000, but got %lli", ll];
    }
    f = 0.0;
    [din decodeValueOfObjCType: @encode(float) at: &f];
    if (f != 2.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.5, but got %g", f];
    }
    d = 0.0;
    [din decodeValueOfObjCType: @encode(double) at: &d];
    if (d != 4.2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4.2, but got %g", d];
    }
    s = NULL;
    [din decodeValueOfObjCType: @encode(SEL) at: &s];
#if defined(__NEXT_RUNTIME__)
    if (s != @selector(testEncodeObjCTypes))
#else
    if (!sel_eq(s, @selector(testEncodeObjCTypes)))
#endif
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The selector is not the same"];
    }
    [din decodeValueOfObjCType: @encode(char*) at: &str];
    if (strcmp(str, "My dog has fleas") != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"My dog has fleas\", but got \"%s\"", str];
    }
#if defined(__NEXT_RUNTIME__)
    free(str);
#endif
    [din decodeValueOfObjCType: @encode(uint8_t[4]) at: &readArr];
    if (memcmp(arr, readArr, 4) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The arrays should be equal"];
    }
    pi = NULL;
    [din decodeValueOfObjCType: @encode(int*) at: &pi];
    if (*pi != 1000000000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000000, but got %i", *pi];
    }
#if defined(__NEXT_RUNTIME__)
    free(pi);
#endif
    s2.sone.one = 0;
    s2.sone.two = 0;
    s2.flt = 0.0;
    s2.dbl = 0.0;
    [din decodeValueOfObjCType: @encode(StructTwo) at: &s2];
    if (s2.sone.one != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", s2.sone.one];
    }
    if (s2.sone.two != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %li", s2.sone.two];
    }
    if (s2.flt != 1.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1.2, but got %g", s2.flt];
    }
    if (s2.dbl != 2.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.1, but got %g", s2.dbl];
    }
    [din RELEASE];
}
#endif

- (void) testPrimitiveReadWrite
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    uint8_t bytes[] = { 0, 1, 2, 3 };
    uint8_t bytes2[4];
    uint8_t i8;
    uint16_t i16;
    uint32_t i32;
    uint64_t i64;
    int i;
    double d;
    float f;

    dout = [[OLDataOutStream alloc] init];
    [dout writeBool: YES];
    [dout writeBool: NO];
    [dout writeByte: 42];
    [dout writeBytes: bytes count: 4];
    [dout writeDouble: 2.7];
    [dout writeFloat: 3.5];
    [dout writeInt: 74550];
    [dout writeInt16: 200];
    [dout writeInt32: 100000];
    [dout writeInt64: 5000000000LL];
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    if (![din readBool])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if ([din readBool])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected NO, but got YES"];
    }
    i8 = [din readByte];
    if (i8 != 42)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 42, but got %i", i8];
    }
    i = [din readBytes: bytes2 count: 4];
    if (i != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %i", i];
    }
    for (i = 0; i < 4; i++)
    {
        if (bytes[i] != bytes2[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i", bytes[i], bytes2[i]];
        }
    }
    d = [din readDouble];
    if (d != 2.7)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.7, but got %g", d];
    }
    f = [din readFloat];
    if (f != 3.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3.5, but got %g", f];
    }
    i = [din readInt];
    if (i != 74550)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 74550, but got %i", i];
    }
    i16 = [din readInt16];
    if (i16 != 200)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 200, but got %i", i16];
    }
    i32 = [din readInt32];
    if (i32 != 100000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 100000, but got %i", i32];
    }
    i64 = [din readInt64];
    if (i64 != 5000000000LL)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5000000000, but got %lli", i64];
    }
    [din RELEASE];
}

@end
