//
// $Id: Utility.m,v 1.5 2007/03/25 18:12:15 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Config.h"
#import "EndOfContainer.h"
#import "Iterator.h"
#import "RunTime.h"
#if defined(OL_NO_OPENSTEP)
#import <objc/Object.h>
#import "Exception.h"
#else
#import <Foundation/NSObject.h>
#import <Foundation/NSException.h>
#import <Foundation/NSAutoreleasePool.h>
#endif
#import "Macros.h"
#import <stdlib.h>

@protocol OLUtilityUnknownMethods

- (void) insertFrom: (id)f to: (id)t;
- (unsigned) size;

@end

int compareContainers(id first,
                      id second,
                      SEL getStart,
                      SEL getFinish)
{
    id firstCur;
    id firstFinish;
    id secondCur;
    id secondFinish;
    int result;

#if defined(OL_NO_OPENSTEP)
    if ([second isKindOf: [first class]])
#else
    if ([second isKindOfClass: [first class]])
#endif
    {
        firstCur = OBJ_PERFORM(first, getStart);
        firstFinish = OBJ_PERFORM(first, getFinish);
        secondCur = OBJ_PERFORM(second, getStart);
        secondFinish = OBJ_PERFORM(second, getFinish);
        result = 0;
        while (result == 0 &&
               ![firstCur isEqual: firstFinish] &&
               ![secondCur isEqual: secondFinish])
        {
            result = [[firstCur dereference] compare: [secondCur dereference]];
            [firstCur advance];
            [secondCur advance];
        }
        OBJ_RELEASE(firstCur);
        OBJ_RELEASE(firstFinish);
        OBJ_RELEASE(secondCur);
        OBJ_RELEASE(secondFinish);
        if (result == 0 && [first size] != [second size])
            result = ([first size] > [second size]) ? 1 : -1;
    }
    else
    {
        result = -1;
    }
    return result;
}

void readContainerWithInsertRange(id container, id streamOrCoder, SEL readObject)
{
#if !defined(OL_NO_OPENSTEP)
    NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
#endif
    id* array = objc_malloc(5000 * sizeof(id));
    id cur = OBJ_PERFORM(streamOrCoder, readObject);
    OLPair* itors;
    int count = 0;

    OL_DURING

        while (!IS_KIND_OF(cur, OLEndOfContainer))
        {
            array[count++] = cur;
            if (count == 5000)
            {
                itors = [OLArrayIterator pairWithPointer: array distance: count];
                [container insertFrom: [itors first] to: [itors second]];
#if defined(OL_NO_OPENSTEP)
                do
                {
                    [array[--count] free];
                } while (count > 0);
                [itors free];
#else
                [pool release];
                pool = [[NSAutoreleasePool alloc] init];
                count = 0;
#endif
            }
            cur = OBJ_PERFORM(streamOrCoder, readObject);
        }

    OL_HANDLER

#if defined(OL_NO_OPENSTEP)
        do
        {
            [array[--count] free];
        } while (count > 0);
#else
        [pool release];
#endif
        objc_free(array);
        [localException raise];

    OL_ENDHANDLER

#if defined(OL_NO_OPENSTEP)
    [cur free];
#endif
    if (count > 0)
    {
        itors = [OLArrayIterator pairWithPointer: array distance: count];
        [container insertFrom: [itors first] to: [itors second]];
#if defined(OL_NO_OPENSTEP)
        do
        {
            [array[--count] free];
        } while (count > 0);
        [itors free];
#endif
    }
#if !defined(OL_NO_OPENSTEP)
    [pool release];
#endif
    objc_free(array);
}

void readContainerWithPushBack(id container, id streamOrCoder, SEL readObject)
{
#if !defined(OL_NO_OPENSTEP)
    NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
    unsigned count = 0;
#endif
    id cur = OBJ_PERFORM(streamOrCoder, readObject);

    while (!IS_KIND_OF(cur, OLEndOfContainer))
    {
        [container pushBack: cur];
#if defined(OL_NO_OPENSTEP)
        [cur free];
#else
        if (count++ == 5000)
        {
            [pool release];
            pool = [[NSAutoreleasePool alloc] init];
            count = 0;
        }
#endif

#if defined(OL_NO_OPENSTEP)
        cur = OBJ_PERFORM(streamOrCoder, readObject);
#else
        OL_DURING

            cur = OBJ_PERFORM(streamOrCoder, readObject);

        OL_HANDLER

            [pool release];
            [localException raise];

        OL_ENDHANDLER
#endif
    }
#if defined(OL_NO_OPENSTEP)
    [cur free];
#else
    [pool release];
#endif
}

void writeContainer(id container, SEL getBegin, SEL getEnd, id streamOrCoder, SEL writeObject)
{
    id cur = OBJ_PERFORM(container, getBegin);
    id end = OBJ_PERFORM(container, getEnd);
    OLEndOfContainer* marker = nil;

    OL_DURING

        for ( ; ![cur isEqual: end]; [cur advance])
            OBJ_PERFORM_WITH(streamOrCoder, writeObject, [cur dereference]);
        OBJ_RELEASE(cur);
        cur = nil;
        OBJ_RELEASE(end);
        end = nil;
        marker = [[OLEndOfContainer alloc] init];
        OBJ_PERFORM_WITH(streamOrCoder, writeObject, marker);
        OBJ_RELEASE(marker);
        marker = nil;

    OL_HANDLER

        OBJ_RELEASE(cur);
        OBJ_RELEASE(end);
        OBJ_RELEASE(marker);
        [localException raise];

    OL_ENDHANDLER
}
