//
// $Id: Tree.h,v 1.24 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(TREE_OL_GUARD)
#define TREE_OL_GUARD

#include "Iterator.h"
#include "Functional.h"

@class OLPair;

typedef enum
{
    OLColor_None,
    OLColor_Red,
    OLColor_Black
} OLColor;

@interface OLTreeNode :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject <NSCopying>
#endif
{
@public
    OLTreeNode*     parent;
    OLTreeNode*     left;
    OLTreeNode*     right;
    id              object;
    OLColor         color;
}

+ (OLTreeNode*) decrement: (OLTreeNode*)node;
+ (OLTreeNode*) increment: (OLTreeNode*)node;
+ (void) rebalance: (OLTreeNode*)node parent: (OLTreeNode**)root;
+ (OLTreeNode*) rebalanceForErase: (OLTreeNode*)node parent: (OLTreeNode**)root leftmost: (OLTreeNode**)leftmost rightmost: (OLTreeNode**)rightmost;
+ (void) rotateLeft: (OLTreeNode*)node parent: (OLTreeNode**)root;
+ (void) rotateRight: (OLTreeNode*)node parent: (OLTreeNode**)root;

- (id) init;
- (id) initWithTreeNode: (OLTreeNode*)node;

#if defined(OL_NO_OPENSTEP)
- (id) copy;
#else
- (id) copyWithZone: (NSZone*)zone;
#endif
- (OLTreeNode*) maximum;
- (OLTreeNode*) minimum;

@end

@interface OLTree :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject <NSCopying>
#endif
{
@protected
    OLTreeNode*                             header;
    OLStreamableFunctor<OLBoolBinaryFunction>* keyCompare;
    unsigned                                nodeCount;
}

- (id) init;
- (id) initWithCompare: (OLStreamableFunctor<OLBoolBinaryFunction>*)comp;
- (id) initWithTree: (OLTree*)tree;
#if defined(OL_NO_OPENSTEP)
- (id) free;
#else
- (void) dealloc;
#endif

- (OLAssociativeIterator*) begin;
- (OLAssociativeIterator*) beginImpl;
- (void) clear;
- (int) compare: (id)other;
- (OLTreeNode*) copyNodes: (OLTreeNode*)node to: (OLTreeNode*)dest;
#if defined(OL_NO_OPENSTEP)
- (id) copy;
#else
- (id) copyWithZone: (NSZone*)zone;
#endif
- (unsigned) count: (id)key;
- (BOOL) empty;
- (OLAssociativeIterator*) end;
- (OLAssociativeIterator*) endImpl;
- (OLPair*) equalRange: (id)key;
- (OLPair*) equalRangeImpl: (id)key;
- (void) erase: (OLAssociativeIterator*)where;
- (void) eraseAll: (OLTreeNode*)node;
- (void) eraseFrom: (OLAssociativeIterator*)first to: (OLAssociativeIterator*)last;
- (void) eraseImpl: (OLTreeNode*)node;
- (unsigned) eraseKey: (id)key;
- (OLAssociativeIterator*) find: (id)key;
- (OLTreeNode*) findImpl: (id)key;
- (OLAssociativeIterator*) insertEqual: (id)object;
- (OLAssociativeIterator*) insertEqualAt: (OLAssociativeIterator*)where value: (id)object;
- (void) insertEqualFrom: (OLForwardIterator*)first to: (OLForwardIterator*)last;
- (OLAssociativeIterator*) insertEqualImpl: (id)object needIterator: (BOOL)needItor;
- (OLAssociativeIterator*) insertImplHint1: (OLTreeNode*)x where: (OLTreeNode*)y value: (id)object hint2: (OLTreeNode*)h2;
- (OLAssociativeIterator*) insertImplHint1: (OLTreeNode*)x where: (OLTreeNode*)y value: (id)object hint2: (OLTreeNode*)h2 needIterator: (BOOL)needItor;
- (OLAssociativeIterator*) insertImplHint1: (OLTreeNode*)x where: (OLTreeNode*)y value: (id)object hint2: (OLTreeNode*)h2 needIterator: (BOOL)needItor autorelease: (BOOL)autorel;
- (OLPair*) insertUnique: (id)object;
- (OLAssociativeIterator*) insertUniqueAt: (OLAssociativeIterator*)where value: (id)object;
- (void) insertUniqueFrom: (OLForwardIterator*)first to: (OLForwardIterator*)last;
- (OLAssociativeIterator*) insertUniqueImpl: (id)object success: (BOOL*)result needIterator: (BOOL)needItor;
- (BOOL) isEqualNonUnique: (id)object;
- (BOOL) isEqualUnique: (id)object;
- (OLStreamableFunctor<OLBoolBinaryFunction>*) keyComp;
- (id) keyOfValue: (id)value;
- (OLAssociativeIterator*) lowerBound: (id)key;
- (OLAssociativeIterator*) lowerBoundImpl: (id)key;
- (unsigned) maxSize;
- (OLReverseBidiIterator*) rbegin;
- (OLReverseBidiIterator*) rend;
- (unsigned) size;
- (void) swap: (OLTree*)tree;
- (OLAssociativeIterator*) upperBound: (id)key;
- (OLAssociativeIterator*) upperBoundImpl: (id)key;
- (id) valueOfValue: (id)value;

@end

@interface OLTreeMap : OLTree
{
}

- (void) assignEqualKey: (id)key value: (id)val;
- (void) assignUniqueKey: (id)key value: (id)val;
- (id) findValue: (id)key;
- (id) keyOfValue: (id)value;
- (id) valueOfValue: (id)value;

@end

#endif
