//
// $Id: Stack.m,v 1.16 2007/03/06 20:42:20 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Stack.h"
#import "Macros.h"
#import "ObjectInStream.h"
#import "ObjectOutStream.h"
#if !defined(OL_NO_OPENSTEP)
#import <Foundation/NSCoder.h>
#endif

#if !defined(OL_NO_OPENSTEP)
extern NSString* const DEQUE_KEY;
#endif

@implementation OLStack

+ (id) stack
{
    OL_BEGIN_AUTO_CTOR(OLStack)
        init
    OL_END_AUTO_CTOR;
}

+ (id) stackWithStack: (OLStack*)right
{
    OL_BEGIN_AUTO_CTOR(OLStack)
        initWithStack: right
    OL_END_AUTO_CTOR;
}

- (id) init
{
    [super init];
    deque = [[OLDeque alloc] init];
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (id) initWithCoder: (NSCoder*)decoder
{
    [super init];
    if ([decoder respondsToSelector: @selector(allowsKeyedCoding)] &&
        [decoder allowsKeyedCoding])
    {
        deque = OBJ_RETAIN_AUTO([decoder decodeObjectForKey: DEQUE_KEY]);
    }
    else
    {
        deque = OBJ_RETAIN_AUTO([decoder decodeObject]);
    }
    return self;
}
#endif

- (id) initWithObjectInStream: (OLObjectInStream*)stream
{
    [super init];
    deque = OBJ_RETAIN_AUTO([stream readObject]);
    return self;
}

- (id) initWithStack: (OLStack*)stack
{
    [super init];
    deque = [stack->deque copy];
    return self;
}

#if defined(OL_NO_OPENSTEP)
- (id) free
#else
- (void) dealloc
#endif
{
    OBJ_RELEASE(deque);
    SUPER_FREE;
}

- (int) compare: (id)other
{
    if (IS_KIND_OF(other, OLStack))
        return [deque compare: ((OLStack*)other)->deque];
    return -1;
}

#if defined(OL_NO_OPENSTEP)

- (id) copy
{
    return [[OLStack alloc] initWithStack: self];
}

#else

- (id) copyWithZone: (NSZone*)zone
{
    return [[OLStack allocWithZone: zone] initWithStack: self];

}

#endif

- (BOOL) empty
{
    return [deque empty];
}

#if !defined(OL_NO_OPENSTEP)
- (void) encodeWithCoder: (NSCoder*)encoder
{
    if ([encoder respondsToSelector: @selector(allowsKeyedCoding)] &&
        [encoder allowsKeyedCoding])
    {
        [encoder encodeObject: deque forKey: DEQUE_KEY];
    }
    else
    {
        [encoder encodeObject: deque];
    }
}
#endif

- (BOOL) isEqual: (id)object
{
    return IS_KIND_OF(object, OLStack) &&
           [((OLStack*)object)->deque isEqual: deque];

}

- (void) pop
{
    [deque popBack];
}

- (void) push: (id)object
{
    [deque pushBack: object];
}

- (unsigned) size
{
    return [deque size];
}

- (id) top
{
    return [deque back];
}

- (void) writeSelfToStream: (OLObjectOutStream*)stream
{
    [stream writeObject: deque];
}

@end
