/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Fragment;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.ProjectionDocument;

public class ProjectionTextStore
implements ITextStore {
    private ProjectionDocument fProjectionDocument;

    public ProjectionTextStore(ProjectionDocument projectionDocument) {
        this.fProjectionDocument = projectionDocument;
    }

    private int computeParentDocumentOffset(int offset) {
        try {
            return this.fProjectionDocument.toParentDocumentOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException();
        }
    }

    public void set(String contents) {
        try {
            Position[] projection = this.fProjectionDocument.getProjection();
            if (projection != null && projection.length > 0) {
                Position first = projection[0];
                Position last = projection[projection.length - 1];
                int length = last.offset - first.offset + last.length;
                this.getParentDocument().replace(first.getOffset(), length, contents);
            } else {
                this.getParentDocument().set(contents);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void replace(int offset, int length, String text) {
        try {
            int endoffset = length > 0 ? offset + length - 1 : offset;
            int o2 = this.computeParentDocumentOffset(endoffset);
            if (length > 0) {
                ++o2;
            }
            offset = this.computeParentDocumentOffset(offset);
            length = o2 - offset;
            this.getParentDocument().replace(offset, length, text);
        }
        catch (BadLocationException badLocationException) {}
    }

    public int getLength() {
        Position[] projection = this.fProjectionDocument.getProjection();
        if (projection == null || projection.length == 0) {
            return 0;
        }
        int length = 0;
        int i = 0;
        while (i < projection.length) {
            length += projection[i].length;
            ++i;
        }
        return length;
    }

    public String get(int offset, int length) {
        try {
            Fragment[] fragments = this.fProjectionDocument.getFragmentsOfRange(offset, length);
            if (fragments == null || fragments.length == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < fragments.length) {
                Position p = fragments[i].getOrigin();
                buffer.append(this.getParentDocument().get(p.offset, p.length));
                ++i;
            }
            return buffer.substring(offset -= fragments[0].offset, offset + length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IDocument getParentDocument() {
        return this.fProjectionDocument.getParentDocument();
    }

    public char get(int offset) {
        try {
            int o = this.computeParentDocumentOffset(offset);
            return this.getParentDocument().getChar(o);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }
}

