/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;

public class TypeReferencePattern
extends AndPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new TypeReferencePattern(null, null, 4);
        }
    };
    protected char[] qualification;
    protected char[] simpleName;
    protected char[] currentCategory;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.TYPE_REF, IIndexConstants.SUPER_REF, IIndexConstants.REF, IIndexConstants.CONSTRUCTOR_REF};
    protected static char[][] REF_CATEGORIES = new char[][]{IIndexConstants.REF};

    public static char[] createIndexKey(char[] typeName) {
        TypeReferencePattern record = TypeReferencePattern.getTypeReferenceRecord();
        record.simpleName = typeName;
        return record.encodeIndexKey();
    }

    public static TypeReferencePattern getTypeReferenceRecord() {
        return (TypeReferencePattern)indexRecord.get();
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchRule) {
        super(4, matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        if (simpleName == null) {
            this.segments = this.qualification == null ? IIndexConstants.ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification);
        }
        this.mustResolve = true;
    }

    public void decodeIndexKey(char[] key) {
        int nameLength = CharOperation.indexOf('/', key);
        if (nameLength != -1) {
            key = CharOperation.subarray(key, 0, nameLength);
        }
        this.simpleName = key;
        this.segments[0] = key;
    }

    public char[] encodeIndexKey() {
        if (this.simpleName == null) {
            if (this.currentSegment < 0) {
                return null;
            }
            return this.encodeIndexKey(this.segments[this.currentSegment]);
        }
        return this.encodeIndexKey(this.simpleName);
    }

    public SearchPattern getIndexRecord() {
        return TypeReferencePattern.getTypeReferenceRecord();
    }

    public char[][] getMatchCategories() {
        return this.simpleName == null ? REF_CATEGORIES : CATEGORIES;
    }

    protected boolean hasNextQuery() {
        if (this.simpleName != null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean isMatchingIndexRecord() {
        if (this.simpleName == null) {
            return this.matchesName(this.segments[this.currentSegment], TypeReferencePattern.getTypeReferenceRecord().segments[0]);
        }
        return this.matchesName(this.simpleName, TypeReferencePattern.getTypeReferenceRecord().simpleName);
    }

    protected void resetQuery() {
        if (this.simpleName == null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            buffer.append(this.qualification);
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

