/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.core.index.impl.Block;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.FileListBlock;
import org.eclipse.jdt.internal.core.index.impl.GammaCompressedIndexBlock;
import org.eclipse.jdt.internal.core.index.impl.IndexBlock;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexSummary;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.LRUCache;
import org.eclipse.jdt.internal.core.index.impl.SafeRandomAccessFile;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;
import org.eclipse.jdt.internal.core.util.Util;

public class BlocksIndexInput
extends IndexInput {
    public static final int CACHE_SIZE = 16;
    protected FileListBlock currentFileListBlock;
    protected int currentFileListBlockNum;
    protected int currentIndexBlockNum;
    protected IndexBlock currentIndexBlock;
    private RandomAccessFile raf;
    protected File indexFile;
    protected LRUCache blockCache;
    protected boolean opened = false;
    protected IndexSummary summary;

    public BlocksIndexInput(File inputFile) {
        this.indexFile = inputFile;
        this.blockCache = new LRUCache(16);
    }

    public void clearCache() {
        this.blockCache = new LRUCache(16);
    }

    public void close() throws IOException {
        if (this.opened) {
            this.summary = null;
            this.opened = false;
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        IndexedFile file = null;
        file = this.currentFileListBlock.getFile(this.filePosition);
        if (file == null) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(this.filePosition);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
            file = this.currentFileListBlock.getFile(this.filePosition);
        }
        return file;
    }

    protected WordEntry getEntry(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return null;
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        return block.findExactEntry(word);
    }

    protected FileListBlock getFileListBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get(key);
        if (block != null && block instanceof FileListBlock) {
            return (FileListBlock)block;
        }
        FileListBlock fileListBlock = new FileListBlock(8192);
        fileListBlock.read(this.raf, blockNum);
        this.blockCache.put(key, fileListBlock);
        return fileListBlock;
    }

    protected IndexBlock getIndexBlock(int blockNum) throws IOException {
        Integer key = new Integer(blockNum);
        Block block = (Block)this.blockCache.get(key);
        if (block != null && block instanceof IndexBlock) {
            return (IndexBlock)block;
        }
        GammaCompressedIndexBlock indexBlock = new GammaCompressedIndexBlock(8192);
        indexBlock.read(this.raf, blockNum);
        this.blockCache.put(key, indexBlock);
        return indexBlock;
    }

    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        int blockNum = this.summary.getBlockNumForFileNum(fileNum);
        if (blockNum == -1) {
            return null;
        }
        FileListBlock block = this.getFileListBlock(blockNum);
        return block.getFile(fileNum);
    }

    public IndexedFile getIndexedFile(SearchDocument document) throws IOException {
        this.setFirstFile();
        String name = document.getPath();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            String path = file.getPath();
            if (path.equals(name)) {
                return file;
            }
            this.moveToNextFile();
        }
        return null;
    }

    protected int[] getMatchingFileNumbers(char[] word) throws IOException {
        int blockNum = this.summary.getBlockNumForWord(word);
        if (blockNum == -1) {
            return new int[0];
        }
        IndexBlock block = this.getIndexBlock(blockNum);
        WordEntry entry = block.findExactEntry(word);
        return entry == null ? new int[]{} : entry.getRefs();
    }

    public int getNumFiles() {
        return this.summary.getNumFiles();
    }

    public int getNumWords() {
        return this.summary.getNumWords();
    }

    public Object getSource() {
        return this.indexFile;
    }

    protected void init() throws IOException {
        this.clearCache();
        this.setFirstFile();
        this.setFirstWord();
    }

    public void moveToNextFile() {
        ++this.filePosition;
    }

    public void moveToNextWordEntry() throws IOException {
        boolean endOfBlock;
        ++this.wordPosition;
        if (!this.hasMoreWords()) {
            return;
        }
        boolean bl = endOfBlock = !this.currentIndexBlock.nextEntry(this.currentWordEntry);
        if (endOfBlock) {
            this.currentIndexBlock = this.getIndexBlock(++this.currentIndexBlockNum);
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }

    public void open() throws IOException {
        if (!this.opened) {
            this.raf = new SafeRandomAccessFile(this.indexFile, "r");
            String sig = this.raf.readUTF();
            if (!sig.equals("INDEX FILE 0.016")) {
                throw new IOException(Util.bind("exception.wrongFormat"));
            }
            int summaryBlockNum = this.raf.readInt();
            this.raf.seek((long)summaryBlockNum * 8192L);
            this.summary = new IndexSummary();
            this.summary.read(this.raf);
            this.init();
            this.opened = true;
        }
    }

    public String[] query(String word) throws IOException {
        this.open();
        int[] fileNums = this.getMatchingFileNumbers(word.toCharArray());
        int size = fileNums.length;
        String[] paths = new String[size];
        int i = 0;
        while (i < size) {
            paths[i] = this.getIndexedFile(fileNums[i]).getPath();
            ++i;
        }
        return paths;
    }

    public EntryResult[] queryEntriesMatching(char[] pattern) throws IOException {
        this.open();
        if (pattern == null || pattern.length == 0) {
            return null;
        }
        int[] blockNums = null;
        int firstStar = CharOperation.indexOf('*', pattern);
        switch (firstStar) {
            case -1: {
                WordEntry entry = this.getEntry(pattern);
                if (entry == null) {
                    return null;
                }
                return new EntryResult[]{new EntryResult(entry.getWord(), entry.getRefs())};
            }
            case 0: {
                blockNums = this.summary.getAllBlockNums();
                break;
            }
            default: {
                char[] prefix = CharOperation.subarray(pattern, 0, firstStar);
                blockNums = this.summary.getBlockNumsForPrefix(prefix);
            }
        }
        if (blockNums == null || blockNums.length == 0) {
            return null;
        }
        EntryResult[] entries = new EntryResult[5];
        int count = 0;
        int i = 0;
        int max = blockNums.length;
        while (i < max) {
            IndexBlock block = this.getIndexBlock(blockNums[i]);
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.match(entry.getWord(), pattern, true)) {
                    if (count == entries.length) {
                        EntryResult[] entryResultArray = entries;
                        entries = new EntryResult[count * 2];
                        System.arraycopy(entryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            ++i;
        }
        if (count != entries.length) {
            EntryResult[] entryResultArray = entries;
            entries = new EntryResult[count];
            System.arraycopy(entryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    public EntryResult[] queryEntries(char[] pattern, int matchRule) throws IOException {
        return this.queryEntriesPrefixedBy(pattern);
    }

    public EntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        EntryResult[] entries = new EntryResult[5];
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals(prefix, entry.getWord())) {
                    if (count == entries.length) {
                        EntryResult[] entryResultArray = entries;
                        entries = new EntryResult[count * 2];
                        System.arraycopy(entryResultArray, 0, entries, 0, count);
                    }
                    entries[count++] = new EntryResult(entry.getWord(), entry.getRefs());
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        if (count == 0) {
            return null;
        }
        if (count != entries.length) {
            EntryResult[] entryResultArray = entries;
            entries = new EntryResult[count];
            System.arraycopy(entryResultArray, 0, entries, 0, count);
        }
        return entries;
    }

    public String[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        this.open();
        int blockLoc = this.summary.getFirstBlockLocationForPrefix(prefix);
        if (blockLoc < 0) {
            return null;
        }
        HashtableOfInt fileMatches = new HashtableOfInt(20);
        int count = 0;
        while (blockLoc >= 0) {
            IndexBlock block = this.getIndexBlock(this.summary.getBlockNum(blockLoc));
            block.reset();
            boolean found = false;
            WordEntry entry = new WordEntry();
            while (block.nextEntry(entry)) {
                if (CharOperation.prefixEquals(prefix, entry.getWord())) {
                    int[] refs = entry.getRefs();
                    int i = 0;
                    int max = refs.length;
                    while (i < max) {
                        int ref = refs[i];
                        if (!fileMatches.containsKey(ref)) {
                            ++count;
                            fileMatches.put(ref, this.getIndexedFile(ref));
                        }
                        ++i;
                    }
                    found = true;
                    continue;
                }
                if (found) break;
            }
            blockLoc = this.summary.getNextBlockLocationForPrefix(prefix, blockLoc);
        }
        String[] paths = new String[count];
        Object[] indexedFiles = fileMatches.valueTable;
        int i = 0;
        int index = 0;
        int max = indexedFiles.length;
        while (i < max) {
            IndexedFile indexedFile = (IndexedFile)indexedFiles[i];
            if (indexedFile != null) {
                paths[index++] = indexedFile.getPath();
            }
            ++i;
        }
        return paths;
    }

    public String[] queryInDocumentNames(String word) throws IOException {
        this.open();
        ArrayList<String> matches = new ArrayList<String>();
        this.setFirstFile();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        String[] match = new String[matches.size()];
        matches.toArray(match);
        return match;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.getNumFiles() > 0) {
            this.currentFileListBlockNum = this.summary.getBlockNumForFileNum(1);
            this.currentFileListBlock = this.getFileListBlock(this.currentFileListBlockNum);
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.getNumWords() > 0) {
            this.currentIndexBlockNum = this.summary.getFirstWordBlockNum();
            this.currentIndexBlock = this.getIndexBlock(this.currentIndexBlockNum);
            this.currentWordEntry = new WordEntry();
            this.currentIndexBlock.reset();
            this.currentIndexBlock.nextEntry(this.currentWordEntry);
        }
    }
}

