/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class RegistryResolver {
    private Map idmap;
    private PluginRegistryModel reg;
    private MultiStatus status;
    private boolean trimPlugins = true;
    private boolean crossLink = true;
    private boolean DEBUG_RESOLVE = false;
    private static final String OPTION_DEBUG_RESOLVE = "org.eclipse.core.runtime/registry/debug/resolve";

    public RegistryResolver() {
        String debug = Platform.getDebugOption(OPTION_DEBUG_RESOLVE);
        this.DEBUG_RESOLVE = debug == null ? false : debug.equalsIgnoreCase("true");
    }

    private void add(PluginDescriptorModel pd) {
        String key = pd.getId();
        IndexEntry ix = (IndexEntry)this.idmap.get(key);
        if (ix == null) {
            ix = new IndexEntry(key);
            this.idmap.put(key, ix);
        }
        List verList = ix.versions();
        int i = 0;
        i = 0;
        while (i < verList.size()) {
            PluginDescriptorModel element = (PluginDescriptorModel)verList.get(i);
            if (this.getVersionIdentifier(pd).equals(this.getVersionIdentifier(element))) {
                return;
            }
            if (this.getVersionIdentifier(pd).isGreaterThan(this.getVersionIdentifier(element))) break;
            ++i;
        }
        verList.add(i, pd);
    }

    private void addExtensions(ExtensionModel[] extensions, PluginDescriptorModel plugin) {
        int extLength = extensions.length;
        int i = 0;
        while (i < extLength) {
            extensions[i].setParentPluginDescriptor(plugin);
            ++i;
        }
        ExtensionModel[] list = plugin.getDeclaredExtensions();
        int listLength = list == null ? 0 : list.length;
        ExtensionModel[] result = null;
        if (list == null) {
            result = new ExtensionModel[extLength];
        } else {
            result = new ExtensionModel[list.length + extLength];
            System.arraycopy(list, 0, result, 0, list.length);
        }
        System.arraycopy(extensions, 0, result, listLength, extLength);
        plugin.setDeclaredExtensions(result);
    }

    private void addExtensionPoints(ExtensionPointModel[] extensionPoints, PluginDescriptorModel plugin) {
        int extPtLength = extensionPoints.length;
        int i = 0;
        while (i < extPtLength) {
            extensionPoints[i].setParentPluginDescriptor(plugin);
            ++i;
        }
        ExtensionPointModel[] list = plugin.getDeclaredExtensionPoints();
        int listLength = list == null ? 0 : list.length;
        ExtensionPointModel[] result = null;
        if (list == null) {
            result = new ExtensionPointModel[extPtLength];
        } else {
            result = new ExtensionPointModel[list.length + extPtLength];
            System.arraycopy(list, 0, result, 0, list.length);
        }
        System.arraycopy(extensionPoints, 0, result, listLength, extPtLength);
        plugin.setDeclaredExtensionPoints(result);
    }

    private void addLibraries(LibraryModel[] libraries, PluginDescriptorModel plugin) {
        int listLength;
        int libLength = libraries.length;
        LibraryModel[] list = plugin.getRuntime();
        LibraryModel[] result = null;
        int n = listLength = list == null ? 0 : list.length;
        if (list == null) {
            result = new LibraryModel[libLength];
        } else {
            result = new LibraryModel[list.length + libLength];
            System.arraycopy(list, 0, result, 0, list.length);
        }
        System.arraycopy(libraries, 0, result, listLength, libLength);
        plugin.setRuntime(result);
    }

    private void addPrerequisites(PluginPrerequisiteModel[] prerequisites, PluginDescriptorModel plugin) {
        int listLength;
        int reqLength = prerequisites.length;
        PluginPrerequisiteModel[] list = plugin.getRequires();
        PluginPrerequisiteModel[] result = null;
        int n = listLength = list == null ? 0 : list.length;
        if (list == null) {
            result = new PluginPrerequisiteModel[reqLength];
        } else {
            result = new PluginPrerequisiteModel[list.length + reqLength];
            System.arraycopy(list, 0, result, 0, list.length);
        }
        System.arraycopy(prerequisites, 0, result, listLength, reqLength);
        plugin.setRequires(result);
    }

    private void debug(String s) {
        System.out.println("Registry Resolve: " + s);
    }

    private void error(String message) {
        Status error = new Status(2, "org.eclipse.core.runtime", 1, message, null);
        this.status.add(error);
        if (InternalPlatform.DEBUG && this.DEBUG_RESOLVE) {
            System.out.println(error.toString());
        }
    }

    private void information(String message) {
        if (InternalPlatform.DEBUG && this.DEBUG_RESOLVE) {
            System.out.println(message);
        }
    }

    public IExtensionPoint getExtensionPoint(PluginDescriptorModel plugin, String extensionPointId) {
        if (extensionPointId == null) {
            return null;
        }
        ExtensionPointModel[] list = plugin.getDeclaredExtensionPoints();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (extensionPointId.equals(list[i].getId())) {
                return (IExtensionPoint)((Object)list[i]);
            }
            ++i;
        }
        return null;
    }

    private PluginVersionIdentifier getVersionIdentifier(PluginModel model) {
        try {
            return new PluginVersionIdentifier(model.getVersion());
        }
        catch (Throwable throwable) {
            return new PluginVersionIdentifier("0.0.0");
        }
    }

    private PluginVersionIdentifier getVersionIdentifier(PluginPrerequisiteModel prereq) {
        String version = prereq.getVersion();
        return version == null ? null : new PluginVersionIdentifier(version);
    }

    private boolean fragmentHasPrerequisites(PluginFragmentModel fragment) {
        PluginPrerequisiteModel[] requires = fragment.getRequires();
        if (requires == null || requires.length == 0) {
            return true;
        }
        int i = 0;
        while (i < requires.length) {
            if (this.idmap.get(requires[i].getPlugin()) == null) {
                this.error(Policy.bind("parse.badPrereqOnFrag", fragment.getName(), requires[i].getPlugin()));
                return false;
            }
            ++i;
        }
        return true;
    }

    private void linkFragments() {
        PluginFragmentModel[] fragments = this.reg.getFragments();
        int i = 0;
        while (i < fragments.length) {
            PluginFragmentModel fragment = fragments[i];
            if (!this.requiredFragment(fragment)) {
                String id = fragment.getId();
                if (id != null) {
                    this.error(Policy.bind("parse.fragmentMissingAttr", id));
                } else {
                    String name = fragment.getName();
                    if (name != null) {
                        this.error(Policy.bind("parse.fragmentMissingAttr", name));
                    } else {
                        this.error(Policy.bind("parse.fragmentMissingIdName"));
                    }
                }
            } else if (this.fragmentHasPrerequisites(fragment)) {
                PluginFragmentModel[] list;
                PluginDescriptorModel plugin = null;
                IndexEntry ix = (IndexEntry)this.idmap.get(fragment.getPluginId());
                byte matchType = fragment.getMatch();
                if (ix != null) {
                    list = ix.versions().iterator();
                    while (list.hasNext() && plugin == null) {
                        PluginDescriptorModel pd = (PluginDescriptorModel)list.next();
                        if (!pd.getEnabled()) continue;
                        switch (matchType) {
                            case 1: {
                                if (!this.getVersionIdentifier(pd).isPerfect(new PluginVersionIdentifier(fragment.getPluginVersion()))) break;
                                plugin = pd;
                                break;
                            }
                            case 2: {
                                if (!this.getVersionIdentifier(pd).isEquivalentTo(new PluginVersionIdentifier(fragment.getPluginVersion()))) break;
                                plugin = pd;
                                break;
                            }
                            case 0: 
                            case 3: {
                                if (!this.getVersionIdentifier(pd).isCompatibleWith(new PluginVersionIdentifier(fragment.getPluginVersion()))) break;
                                plugin = pd;
                                break;
                            }
                            case 4: {
                                if (!this.getVersionIdentifier(pd).isGreaterOrEqualTo(new PluginVersionIdentifier(fragment.getPluginVersion()))) break;
                                plugin = pd;
                            }
                        }
                    }
                }
                if (plugin == null) {
                    this.error(Policy.bind("parse.missingFragmentPd", fragment.getPluginId(), fragment.getId()));
                } else {
                    PluginFragmentModel[] newList;
                    list = plugin.getFragments();
                    if (list == null) {
                        newList = new PluginFragmentModel[]{fragment};
                    } else {
                        newList = new PluginFragmentModel[list.length + 1];
                        System.arraycopy(list, 0, newList, 0, list.length);
                        newList[list.length] = fragment;
                    }
                    plugin.setFragments(newList);
                }
            }
            ++i;
        }
    }

    private void removeConstraintFor(PluginPrerequisiteModel prereq) {
        String id = prereq.getPlugin();
        IndexEntry ix = (IndexEntry)this.idmap.get(id);
        if (ix == null) {
            if (this.DEBUG_RESOLVE) {
                this.debug("unable to locate index entry for " + id);
            }
            return;
        }
        ix.removeConstraintFor(prereq);
    }

    private void resolve() {
        Object plugins;
        PluginDescriptorModel[] pluginList = this.reg.getPlugins();
        this.idmap = new HashMap();
        int i = 0;
        while (i < pluginList.length) {
            if (!this.requiredPluginDescriptor(pluginList[i])) {
                pluginList[i].setEnabled(false);
                String id = pluginList[i].getId();
                if (id != null) {
                    this.error(Policy.bind("parse.pluginMissingAttr", id));
                } else {
                    String name = pluginList[i].getName();
                    if (name != null) {
                        this.error(Policy.bind("parse.pluginMissingAttr", name));
                    } else {
                        this.error(Policy.bind("parse.pluginMissingIdName"));
                    }
                }
            } else {
                this.add(pluginList[i]);
            }
            ++i;
        }
        this.linkFragments();
        i = 0;
        while (i < pluginList.length) {
            if (pluginList[i].getFragments() != null) {
                this.resolvePluginFragments(pluginList[i]);
            }
            ++i;
        }
        List roots = this.resolveRootDescriptors();
        if (roots.size() == 0) {
            plugins = this.reg.getPlugins();
            int i2 = 0;
            while (i2 < ((PluginDescriptorModel[])plugins).length) {
                plugins[i2].setEnabled(false);
                ++i2;
            }
            this.resolvePluginRegistry();
            this.idmap = null;
            this.reg = null;
            this.error(Policy.bind("plugin.unableToResolve"));
            return;
        }
        HashSet rootsSet = new HashSet(roots);
        while (!rootsSet.isEmpty()) {
            HashSet orphans = new HashSet();
            Iterator rootsIter = rootsSet.iterator();
            while (rootsIter.hasNext()) {
                String rootID = (String)rootsIter.next();
                this.resolveNode(rootID, null, null, null, orphans);
            }
            Iterator orphansIter = orphans.iterator();
            while (orphansIter.hasNext()) {
                IndexEntry orphan = (IndexEntry)this.idmap.get(orphansIter.next());
                if (orphan.isRoot()) {
                    if (this.DEBUG_RESOLVE) {
                        this.debug("orphan " + orphan.getId());
                    }
                    roots.add(orphan.getId());
                    continue;
                }
                orphansIter.remove();
            }
            rootsSet = orphans;
        }
        plugins = this.idmap.entrySet().iterator();
        while (plugins.hasNext()) {
            IndexEntry ix = (IndexEntry)((Map.Entry)plugins.next()).getValue();
            ix.resolveDependencies(roots);
        }
        this.resolvePluginRegistry();
        this.idmap = null;
        this.reg = null;
    }

    public IStatus resolve(PluginRegistryModel registry) {
        this.status = new MultiStatus("org.eclipse.core.runtime", 0, "", null);
        if (registry.isResolved()) {
            return this.status;
        }
        this.reg = registry;
        this.resolve();
        registry.markResolved();
        return this.status;
    }

    private void resolveExtension(ExtensionModel ext) {
        String target = ext.getExtensionPoint();
        int ix = target.lastIndexOf(".");
        String pluginId = target.substring(0, ix);
        String extPtId = target.substring(ix + 1);
        PluginDescriptorModel plugin = this.reg.getPlugin(pluginId);
        if (plugin == null) {
            String message = Policy.bind("parse.extPointUnknown", target, ext.getParentPluginDescriptor().getId());
            this.error(message);
            return;
        }
        if (!plugin.getEnabled()) {
            String message = Policy.bind("parse.extPointDisabled", target, ext.getParentPluginDescriptor().getId());
            this.error(message);
            return;
        }
        ExtensionPointModel extPt = (ExtensionPointModel)((Object)this.getExtensionPoint(plugin, extPtId));
        if (extPt == null) {
            String message = Policy.bind("parse.extPointUnknown", target, ext.getParentPluginDescriptor().getId());
            this.error(message);
            return;
        }
        ExtensionModel[] oldValues = extPt.getDeclaredExtensions();
        ExtensionModel[] newValues = null;
        if (oldValues == null) {
            newValues = new ExtensionModel[1];
        } else {
            newValues = new ExtensionModel[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
        }
        newValues[newValues.length - 1] = ext;
        extPt.setDeclaredExtensions(newValues);
    }

    private void resolveFragments() {
        PluginFragmentModel[] fragments = this.reg.getFragments();
        HashSet<String> seen = new HashSet<String>(5);
        int i = 0;
        while (i < fragments.length) {
            PluginFragmentModel fragment = fragments[i];
            if (this.requiredFragment(fragment) && !seen.contains(fragment.getId())) {
                seen.add(fragment.getId());
                PluginDescriptorModel plugin = this.reg.getPlugin(fragment.getPluginId(), fragment.getPluginVersion());
                if (plugin != null) {
                    this.resolvePluginFragments(plugin);
                }
            }
            ++i;
        }
    }

    private Cookie resolveNode(String child, PluginDescriptorModel parent, PluginPrerequisiteModel prq, Cookie cookie, Set orphans) {
        PluginPrerequisiteModel prereq;
        IndexEntry ix;
        if (this.DEBUG_RESOLVE) {
            this.debug("PUSH> " + child);
        }
        if (cookie == null) {
            cookie = new Cookie();
        }
        if ((ix = (IndexEntry)this.idmap.get(child)) == null) {
            if (prq.getOptional() && parent != null && child != null) {
                return cookie;
            }
            if (parent != null) {
                this.error(Policy.bind("parse.prereqDisabled", new String[]{parent.getId(), child}));
            }
            if (this.DEBUG_RESOLVE) {
                this.debug("<POP  " + child + " not found");
            }
            cookie.isOk(false);
            return cookie;
        }
        Constraint currentConstraint = new Constraint(parent, prq);
        PluginDescriptorModel childPd = null;
        if (parent != null) {
            childPd = ix.addConstraint(currentConstraint);
            if (childPd == null) {
                if (prq.getOptional()) {
                    orphans.add(ix.getId());
                    this.information(Policy.bind("parse.unsatisfiedOptPrereq", parent.getId(), child));
                    return cookie;
                }
                String message = Policy.bind("parse.unsatisfiedPrereq", parent.getId(), child);
                this.error(message);
                if (this.DEBUG_RESOLVE) {
                    this.debug("<POP  " + child + " unable to satisfy constraint");
                }
                cookie.isOk(false);
                return cookie;
            }
            if (!cookie.addChange(currentConstraint)) {
                if (prq.getOptional()) {
                    this.information(Policy.bind("parse.prereqOptLoop", parent.getId(), child));
                    return cookie;
                }
                String message = Policy.bind("parse.prereqLoop", parent.getId(), child);
                this.error(message);
                if (this.DEBUG_RESOLVE) {
                    this.debug("<POP  " + child + " prerequisite loop");
                }
                cookie.isOk(false);
                return cookie;
            }
        } else {
            childPd = ix.getMatchingDescriptorFor(currentConstraint);
            if (childPd == null) {
                if (this.DEBUG_RESOLVE) {
                    this.debug("<POP  " + child + " not found (missing descriptor entry)");
                }
                cookie.isOk(false);
                return cookie;
            }
        }
        if (ix.isResolvedFor(currentConstraint)) {
            if (this.DEBUG_RESOLVE) {
                this.debug("<POP  " + child + " already resolved");
            }
            return cookie;
        }
        PluginPrerequisiteModel[] prereqs = childPd.getRequires();
        prereqs = prereqs == null ? new PluginPrerequisiteModel[]{} : prereqs;
        int i = 0;
        while (cookie.isOk() && i < prereqs.length) {
            prereq = prereqs[i];
            cookie = this.resolveNode(prereq.getPlugin(), childPd, prereq, cookie, orphans);
            ++i;
        }
        if (!cookie.isOk()) {
            Iterator change = cookie.getChanges().iterator();
            while (change.hasNext()) {
                Constraint cookieConstraint = (Constraint)change.next();
                prereq = cookieConstraint.getPrerequisite();
                if (childPd == cookieConstraint.getParent() && !orphans.contains(prereq.getPlugin()) && this.idmap.get(prereq.getPlugin()) != null) {
                    orphans.add(prereq.getPlugin());
                }
                this.removeConstraintFor(prereq);
            }
            int i2 = 0;
            while (i2 < prereqs.length) {
                if (!orphans.contains(prereqs[i2].getPlugin()) && this.idmap.get(prereqs[i2].getPlugin()) != null) {
                    orphans.add(prereqs[i2].getPlugin());
                }
                ++i2;
            }
            if (parent != null) {
                this.error(Policy.bind("parse.prereqDisabled", parent.getId(), child));
            }
            childPd.setEnabled(false);
            if (this.DEBUG_RESOLVE) {
                this.debug("<POP  " + child + " failed to resolve subtree");
            }
            return cookie;
        }
        ix.isResolvedFor(currentConstraint, true);
        if (this.DEBUG_RESOLVE) {
            this.debug("<POP  " + child + " " + this.getVersionIdentifier(childPd));
        }
        return cookie;
    }

    private void resolvePluginDescriptor(PluginDescriptorModel pd) {
        ExtensionModel[] list = pd.getDeclaredExtensions();
        if (list == null || list.length == 0 || !pd.getEnabled()) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            this.resolveExtension(list[i]);
            ++i;
        }
    }

    private void resolvePluginFragment(PluginFragmentModel fragment, PluginDescriptorModel plugin) {
        PluginPrerequisiteModel[] prerequisites;
        LibraryModel[] libraries;
        ExtensionPointModel[] points;
        ExtensionModel[] extensions = fragment.getDeclaredExtensions();
        if (extensions != null) {
            this.addExtensions(extensions, plugin);
        }
        if ((points = fragment.getDeclaredExtensionPoints()) != null) {
            this.addExtensionPoints(points, plugin);
        }
        if ((libraries = fragment.getRuntime()) != null) {
            this.addLibraries(libraries, plugin);
        }
        if ((prerequisites = fragment.getRequires()) != null) {
            this.addPrerequisites(prerequisites, plugin);
        }
    }

    private void resolvePluginFragments(PluginDescriptorModel plugin) {
        boolean dirty = false;
        PluginFragmentModel[] fragmentList = plugin.getFragments();
        HashMap<String, PluginFragmentModel> latestFragments = new HashMap<String, PluginFragmentModel>(30);
        int i = 0;
        while (i < fragmentList.length) {
            String fragmentId = fragmentList[i].getId();
            PluginFragmentModel latestVersion = (PluginFragmentModel)latestFragments.get(fragmentId);
            if (latestVersion == null) {
                latestFragments.put(fragmentId, fragmentList[i]);
            } else {
                dirty = true;
                if (this.getVersionIdentifier(fragmentList[i]).equals(this.getVersionIdentifier(latestVersion))) {
                    this.error(Policy.bind("parse.duplicateFragment", fragmentId, fragmentList[i].getVersion()));
                }
                if (this.getVersionIdentifier(fragmentList[i]).isGreaterThan(this.getVersionIdentifier(latestVersion))) {
                    latestFragments.put(fragmentId, fragmentList[i]);
                }
            }
            ++i;
        }
        HashSet<PluginFragmentModel> latestOnly = new HashSet<PluginFragmentModel>();
        Iterator list = latestFragments.values().iterator();
        while (list.hasNext()) {
            PluginFragmentModel latestFragment = (PluginFragmentModel)list.next();
            if (dirty) {
                latestOnly.add(latestFragment);
            }
            int numLibraries = latestFragment.getRuntime() == null ? 0 : latestFragment.getRuntime().length;
            this.resolvePluginFragment(latestFragment, plugin);
            if (numLibraries == 0) continue;
            LibraryModel[] libraries = plugin.getRuntime();
            HashSet<String> libNames = new HashSet<String>();
            int setSize = libNames.size();
            int i2 = 0;
            while (i2 < libraries.length) {
                libNames.add(libraries[i2].getName());
                if (libNames.size() == setSize) {
                    String[] bindings = new String[]{latestFragment.getId(), plugin.getId(), libraries[i2].getName()};
                    this.error(Policy.bind("parse.duplicateLib", bindings));
                } else {
                    setSize = libNames.size();
                }
                ++i2;
            }
        }
        if (dirty) {
            plugin.setFragments(latestOnly.toArray(new PluginFragmentModel[latestOnly.size()]));
        }
    }

    private void resolvePluginRegistry() {
        if (this.trimPlugins) {
            this.trimRegistry();
        }
        if (this.crossLink) {
            PluginDescriptorModel[] plugins = this.reg.getPlugins();
            int i = 0;
            while (i < plugins.length) {
                this.resolvePluginDescriptor(plugins[i]);
                ++i;
            }
        }
    }

    private boolean requiredPluginDescriptor(PluginDescriptorModel plugin) {
        int i;
        boolean retValue = true;
        boolean bl = retValue = plugin.getName() != null && plugin.getId() != null && plugin.getVersion() != null;
        if (!retValue) {
            return retValue;
        }
        PluginPrerequisiteModel[] requiresList = plugin.getRequires();
        ExtensionModel[] extensions = plugin.getDeclaredExtensions();
        ExtensionPointModel[] extensionPoints = plugin.getDeclaredExtensionPoints();
        LibraryModel[] libraryList = plugin.getRuntime();
        PluginFragmentModel[] fragments = plugin.getFragments();
        if (requiresList != null) {
            i = 0;
            while (i < requiresList.length && retValue) {
                retValue = retValue && this.requiredPrerequisite(requiresList[i]);
                ++i;
            }
        }
        if (extensions != null) {
            i = 0;
            while (i < extensions.length && retValue) {
                retValue = retValue && this.requiredExtension(extensions[i]);
                ++i;
            }
        }
        if (extensionPoints != null) {
            i = 0;
            while (i < extensionPoints.length && retValue) {
                retValue = retValue && this.requiredExtensionPoint(extensionPoints[i]);
                ++i;
            }
        }
        if (libraryList != null) {
            i = 0;
            while (i < libraryList.length && retValue) {
                retValue = retValue && this.requiredLibrary(libraryList[i]);
                ++i;
            }
        }
        if (fragments != null) {
            i = 0;
            while (i < fragments.length && retValue) {
                retValue = retValue && this.requiredFragment(fragments[i]);
                ++i;
            }
        }
        return retValue;
    }

    private boolean requiredPrerequisite(PluginPrerequisiteModel prerequisite) {
        return prerequisite.getPlugin() != null;
    }

    private boolean requiredExtension(ExtensionModel extension) {
        return extension.getExtensionPoint() != null;
    }

    private boolean requiredExtensionPoint(ExtensionPointModel extensionPoint) {
        return extensionPoint.getName() != null && extensionPoint.getId() != null;
    }

    private boolean requiredLibrary(LibraryModel library) {
        return library.getName() != null;
    }

    private boolean requiredFragment(PluginFragmentModel fragment) {
        return fragment.getName() != null && fragment.getId() != null && fragment.getPlugin() != null && fragment.getPluginVersion() != null && fragment.getVersion() != null;
    }

    private List resolveRootDescriptors() {
        PluginDescriptorModel pd;
        int i;
        ArrayList ids = new ArrayList();
        ids.addAll(this.idmap.keySet());
        Iterator p = this.idmap.entrySet().iterator();
        while (p.hasNext()) {
            List list;
            int ixSize;
            IndexEntry ix = (IndexEntry)p.next().getValue();
            if (ix == null || (ixSize = (list = ix.versions()).size()) <= 0) continue;
            i = 0;
            while (i < ixSize) {
                pd = (PluginDescriptorModel)list.get(i);
                PluginPrerequisiteModel[] prereqs = pd.getRequires();
                int j = 0;
                while (prereqs != null && j < prereqs.length) {
                    ids.remove(prereqs[j].getPlugin());
                    ++j;
                }
                ++i;
            }
        }
        if (ids.size() > 0) {
            p = ids.iterator();
            while (p.hasNext()) {
                String id = (String)((Object)p.next());
                IndexEntry ix = (IndexEntry)this.idmap.get(id);
                if (ix == null) continue;
                List list = ix.versions();
                i = 0;
                while (i < list.size()) {
                    pd = (PluginDescriptorModel)list.get(i);
                    if (i == 0) {
                        if (this.DEBUG_RESOLVE) {
                            this.debug("root " + pd);
                        }
                    } else {
                        if (this.DEBUG_RESOLVE) {
                            this.debug("     " + pd + " disabled");
                        }
                        pd.setEnabled(false);
                    }
                    ++i;
                }
            }
        } else if (this.DEBUG_RESOLVE) {
            this.debug("NO ROOTS");
        }
        return ids;
    }

    public void setCrossLink(boolean value) {
        this.crossLink = value;
    }

    public void setTrimPlugins(boolean value) {
        this.trimPlugins = value;
    }

    private void trimRegistry() {
        PluginDescriptorModel[] list = this.reg.getPlugins();
        int i = 0;
        while (i < list.length) {
            PluginDescriptorModel pd = list[i];
            if (!pd.getEnabled()) {
                if (this.DEBUG_RESOLVE) {
                    this.debug("removing " + pd.toString());
                }
                this.reg.removePlugin(pd.getId(), pd.getVersion());
            }
            ++i;
        }
    }

    private class Constraint {
        private PluginDescriptorModel parent;
        private PluginPrerequisiteModel prq;
        private PluginVersionIdentifier ver;
        private byte type = 0;
        private ConstraintsEntry cEntry = null;

        Constraint(PluginDescriptorModel parent, PluginPrerequisiteModel prq) {
            this.parent = parent;
            this.prq = prq;
            if (prq != null) {
                this.ver = RegistryResolver.this.getVersionIdentifier(prq);
                this.type = prq.getMatchByte();
                if (this.ver != null && this.type == 0) {
                    this.type = (byte)3;
                }
            }
        }

        private int getMatchType() {
            return this.type;
        }

        private ConstraintsEntry getConstraintsEntry() {
            return this.cEntry;
        }

        private void setConstraintsEntry(ConstraintsEntry entry) {
            this.cEntry = entry;
        }

        private PluginDescriptorModel getParent() {
            return this.parent;
        }

        private PluginPrerequisiteModel getPrerequisite() {
            return this.prq;
        }

        private PluginVersionIdentifier getVersionIdentifier() {
            return this.ver;
        }

        public String toString() {
            if (this.prq == null) {
                return "(null)";
            }
            String s = String.valueOf(this.parent.toString()) + "->" + this.prq.getPlugin();
            switch (this.prq.getMatchByte()) {
                case 0: {
                    s = String.valueOf(s) + "(any)";
                    break;
                }
                case 1: {
                    s = String.valueOf(s) + "perfect";
                    break;
                }
                case 2: {
                    s = String.valueOf(s) + "equivalent";
                    break;
                }
                case 3: {
                    s = String.valueOf(s) + "compatible";
                    break;
                }
                case 4: {
                    s = String.valueOf(s) + "greaterOrEqual";
                }
            }
            return s;
        }
    }

    private class ConstraintsEntry {
        private IndexEntry parent;
        private List constraintList = new LinkedList();
        private PluginDescriptorModel lastResolved = null;
        private boolean isResolved = false;
        private PluginDescriptorModel bestMatch = null;
        private boolean bestMatchEnabled = false;

        ConstraintsEntry(IndexEntry parent) {
            this.parent = parent;
        }

        private int constraintCount() {
            return this.constraintList.size();
        }

        private PluginDescriptorModel addConstraint(Constraint c) {
            this.constraintList.add(c);
            c.setConstraintsEntry(this);
            List constrained = this.getMatchingDescriptors();
            if (constrained.size() <= 0) {
                this.constraintList.remove(c);
                c.setConstraintsEntry(null);
                return null;
            }
            PluginDescriptorModel match = (PluginDescriptorModel)constrained.get(0);
            if (!match.equals(this.lastResolved)) {
                this.lastResolved = match;
                this.isResolved = false;
            }
            return match;
        }

        private void removeConstraint(Constraint c) {
            if (RegistryResolver.this.DEBUG_RESOLVE) {
                RegistryResolver.this.debug("removing constraint " + c.toString());
            }
            this.constraintList.remove(c);
            c.setConstraintsEntry(null);
            this.lastResolved = null;
            this.isResolved = false;
        }

        private void removeConstraintFor(PluginPrerequisiteModel prereq) {
            ArrayList<Constraint> remove = new ArrayList<Constraint>();
            Iterator list = this.constraintList.iterator();
            while (list.hasNext()) {
                Constraint c = (Constraint)list.next();
                if (c.getPrerequisite() != prereq) continue;
                remove.add(c);
            }
            list = remove.iterator();
            while (list.hasNext()) {
                this.removeConstraint((Constraint)list.next());
            }
        }

        private PluginDescriptorModel getMatchingDescriptor() {
            List constrained = this.getMatchingDescriptors();
            if (constrained.size() <= 0) {
                return null;
            }
            return (PluginDescriptorModel)constrained.get(0);
        }

        private List getMatchingDescriptors() {
            LinkedList<PluginDescriptorModel> constrained = new LinkedList<PluginDescriptorModel>();
            Iterator list = this.parent.versions().iterator();
            while (list.hasNext()) {
                PluginDescriptorModel pd = (PluginDescriptorModel)list.next();
                if (!pd.getEnabled()) continue;
                constrained.add(pd);
            }
            list = this.constraintList.iterator();
            while (list.hasNext()) {
                Constraint c = (Constraint)list.next();
                if (c.getMatchType() == 0) continue;
                Iterator list2 = this.parent.versions().iterator();
                while (list2.hasNext()) {
                    PluginDescriptorModel pd = (PluginDescriptorModel)list2.next();
                    if (!pd.getEnabled()) continue;
                    switch (c.getMatchType()) {
                        case 1: {
                            if (RegistryResolver.this.getVersionIdentifier(pd).isPerfect(c.getVersionIdentifier())) break;
                            constrained.remove(pd);
                            break;
                        }
                        case 2: {
                            if (RegistryResolver.this.getVersionIdentifier(pd).isEquivalentTo(c.getVersionIdentifier())) break;
                            constrained.remove(pd);
                            break;
                        }
                        case 3: {
                            if (RegistryResolver.this.getVersionIdentifier(pd).isCompatibleWith(c.getVersionIdentifier())) break;
                            constrained.remove(pd);
                            break;
                        }
                        case 4: {
                            if (RegistryResolver.this.getVersionIdentifier(pd).isGreaterOrEqualTo(c.getVersionIdentifier())) break;
                            constrained.remove(pd);
                        }
                    }
                }
            }
            return constrained;
        }

        private void preresolve(List roots) {
            if (this.constraintList.size() <= 0) {
                if (roots.contains(this.parent.getId())) {
                    this.bestMatch = (PluginDescriptorModel)this.parent.versions().get(0);
                    if (this.bestMatch == null) {
                        if (RegistryResolver.this.DEBUG_RESOLVE) {
                            RegistryResolver.this.debug("*ERROR* no resolved descriptor for " + this.parent.getId());
                        }
                    } else {
                        this.bestMatchEnabled = this.bestMatch.getEnabled();
                    }
                }
            } else {
                this.bestMatch = this.getMatchingDescriptor();
                if (this.bestMatch == null) {
                    if (RegistryResolver.this.DEBUG_RESOLVE) {
                        RegistryResolver.this.debug("*ERROR* no resolved descriptor for " + this.parent.getId());
                    }
                } else {
                    this.bestMatchEnabled = true;
                }
            }
        }

        private void resolve() {
            if (this.bestMatch != null) {
                this.bestMatch.setEnabled(this.bestMatchEnabled);
                if (this.bestMatchEnabled) {
                    if (RegistryResolver.this.DEBUG_RESOLVE) {
                        RegistryResolver.this.debug("configured " + this.bestMatch.toString());
                    }
                    if (this.constraintList.size() > 0) {
                        int i = 0;
                        while (i < this.constraintList.size()) {
                            PluginPrerequisiteModel prq = ((Constraint)this.constraintList.get(i)).getPrerequisite();
                            prq.setResolvedVersion(RegistryResolver.this.getVersionIdentifier(this.bestMatch).toString());
                            ++i;
                        }
                    }
                }
            }
        }

        private boolean isResolved() {
            return this.isResolved;
        }

        private void isResolved(boolean isResolved) {
            this.isResolved = isResolved;
        }
    }

    private class IndexEntry {
        private String id;
        private List verList = new LinkedList();
        private List concurrentList = new ArrayList();

        IndexEntry(String id) {
            this.id = id;
            this.concurrentList.add(new ConstraintsEntry(this));
        }

        private String getId() {
            return this.id;
        }

        private ConstraintsEntry getConstraintsEntryFor(Constraint c) {
            ConstraintsEntry ce = c.getConstraintsEntry();
            if (ce != null) {
                return ce;
            }
            ce = (ConstraintsEntry)this.concurrentList.get(0);
            if (c.getPrerequisite() == null) {
                c.setConstraintsEntry(ce);
            }
            return ce;
        }

        private PluginDescriptorModel addConstraint(Constraint c) {
            ConstraintsEntry cie;
            PluginDescriptorModel pd;
            int concurrentCount = this.concurrentList.size();
            Iterator list = this.concurrentList.iterator();
            while (list.hasNext()) {
                ConstraintsEntry cie2 = (ConstraintsEntry)list.next();
                PluginDescriptorModel pd2 = cie2.addConstraint(c);
                if (pd2 == null) continue;
                if (concurrentCount <= 1) {
                    return pd2;
                }
                if (this.allowConcurrencyFor(pd2)) {
                    return pd2;
                }
                cie2.removeConstraint(c);
                return null;
            }
            if (this.concurrentList.size() == 1 && !this.allowConcurrencyFor(pd = (cie = (ConstraintsEntry)this.concurrentList.get(0)).getMatchingDescriptor())) {
                return null;
            }
            cie = new ConstraintsEntry(this);
            pd = cie.addConstraint(c);
            if (pd == null) {
                cie.removeConstraint(c);
                return null;
            }
            if (!this.allowConcurrencyFor(pd)) {
                cie.removeConstraint(c);
                return null;
            }
            if (RegistryResolver.this.DEBUG_RESOLVE) {
                RegistryResolver.this.debug("creating new constraints list in " + this.id + " for " + c.toString());
            }
            this.concurrentList.add(cie);
            return pd;
        }

        private boolean allowConcurrencyFor(PluginDescriptorModel pd) {
            if (pd == null) {
                return false;
            }
            if (pd.getDeclaredExtensions() != null && pd.getDeclaredExtensions().length > 0) {
                return false;
            }
            return pd.getDeclaredExtensionPoints() == null || pd.getDeclaredExtensionPoints().length <= 0;
        }

        private void removeConstraint(Constraint c) {
            ConstraintsEntry cie = this.getConstraintsEntryFor(c);
            cie.removeConstraint(c);
            if (this.concurrentList.get(0) != cie && cie.constraintCount() == 0) {
                this.concurrentList.remove(cie);
            }
        }

        private void removeConstraintFor(PluginPrerequisiteModel prereq) {
            Iterator list = this.concurrentList.iterator();
            while (list.hasNext()) {
                ((ConstraintsEntry)list.next()).removeConstraintFor(prereq);
            }
        }

        private PluginDescriptorModel getMatchingDescriptorFor(Constraint c) {
            ConstraintsEntry cie = this.getConstraintsEntryFor(c);
            return cie.getMatchingDescriptor();
        }

        private void disableAllDescriptors() {
            Iterator list = this.verList.iterator();
            while (list.hasNext()) {
                PluginDescriptorModel pd = (PluginDescriptorModel)list.next();
                pd.setEnabled(false);
            }
        }

        private void resolveDependencies(List roots) {
            Iterator list = this.concurrentList.iterator();
            while (list.hasNext()) {
                ((ConstraintsEntry)list.next()).preresolve(roots);
            }
            this.disableAllDescriptors();
            list = this.concurrentList.iterator();
            while (list.hasNext()) {
                ((ConstraintsEntry)list.next()).resolve();
            }
        }

        private boolean isRoot() {
            if (this.concurrentList.size() != 1) {
                return false;
            }
            ConstraintsEntry constraintsEntry = (ConstraintsEntry)this.concurrentList.get(0);
            return constraintsEntry.constraintCount() == 0;
        }

        private List versions() {
            return this.verList;
        }

        private boolean isResolvedFor(Constraint c) {
            ConstraintsEntry cie = this.getConstraintsEntryFor(c);
            return cie.isResolved();
        }

        private void isResolvedFor(Constraint c, boolean value) {
            ConstraintsEntry cie = this.getConstraintsEntryFor(c);
            cie.isResolved(value);
        }
    }

    private class Cookie {
        private boolean ok = true;
        private List changes = new ArrayList();

        Cookie() {
        }

        private boolean addChange(Constraint c) {
            PluginPrerequisiteModel prereq = c.getPrerequisite();
            Iterator list = this.changes.iterator();
            while (list.hasNext()) {
                if (prereq != ((Constraint)list.next()).getPrerequisite()) continue;
                return false;
            }
            this.changes.add(c);
            return true;
        }

        private List getChanges() {
            return this.changes;
        }

        private void clearChanges() {
            if (this.changes.size() >= 0) {
                this.changes = new ArrayList();
            }
        }

        private boolean isOk() {
            return this.ok;
        }

        private void isOk(boolean value) {
            this.ok = value;
        }
    }
}

