/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;

public class SimpleScope
implements IScope {
    private World world;
    private ResolvedTypeX enclosingType;
    private FormalBinding[] bindings;
    private String[] importedPrefixes = javaLangPrefixArray;
    private String[] importedNames = ZERO_STRINGS;
    public static final String[] ZERO_STRINGS = new String[0];
    public static final String[] javaLangPrefixArray = new String[]{"java.lang."};

    public SimpleScope(World world, FormalBinding[] bindings) {
        this.world = world;
        this.bindings = bindings;
    }

    public TypeX lookupType(String name, IHasPosition location) {
        int i = 0;
        while (i < this.importedNames.length) {
            String importedName = this.importedNames[i];
            if (importedName.endsWith(name)) {
                return this.world.resolve(importedName);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.importedPrefixes.length) {
            String importedPrefix = this.importedPrefixes[i2];
            ResolvedTypeX tryType = this.world.resolve(TypeX.forName(importedPrefix + name), true);
            if (tryType != ResolvedTypeX.MISSING) {
                return tryType;
            }
            ++i2;
        }
        return this.world.resolve(TypeX.forName(name), true);
    }

    public IMessageHandler getMessageHandler() {
        return this.world.getMessageHandler();
    }

    public FormalBinding lookupFormal(String name) {
        int i = 0;
        int len = this.bindings.length;
        while (i < len) {
            if (this.bindings[i].getName().equals(name)) {
                return this.bindings[i];
            }
            ++i;
        }
        return null;
    }

    public FormalBinding getFormal(int i) {
        return this.bindings[i];
    }

    public int getFormalCount() {
        return this.bindings.length;
    }

    public String[] getImportedNames() {
        return this.importedNames;
    }

    public String[] getImportedPrefixes() {
        return this.importedPrefixes;
    }

    public void setImportedNames(String[] importedNames) {
        this.importedNames = importedNames;
    }

    public void setImportedPrefixes(String[] importedPrefixes) {
        this.importedPrefixes = importedPrefixes;
    }

    public static FormalBinding[] makeFormalBindings(TypeX[] types, String[] names) {
        int len = types.length;
        FormalBinding[] bindings = new FormalBinding[len];
        int i = 0;
        while (i < len) {
            bindings[i] = new FormalBinding(types[i], names[i], i);
            ++i;
        }
        return bindings;
    }

    public ISourceLocation makeSourceLocation(IHasPosition location) {
        return new SourceLocation(ISourceLocation.NO_FILE, 0);
    }

    public void message(IMessage.Kind kind, IHasPosition location1, IHasPosition location2, String message) {
        this.message(kind, location1, message);
        this.message(kind, location2, message);
    }

    public void message(IMessage.Kind kind, IHasPosition location, String message) {
        this.getMessageHandler().handleMessage(new Message(message, kind, null, this.makeSourceLocation(location)));
    }

    public World getWorld() {
        return this.world;
    }

    public ResolvedTypeX getEnclosingType() {
        return this.enclosingType;
    }
}

