/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.util.FileUtil;

public class AjBuildConfig {
    private boolean shouldProceed = true;
    public static final String AJLINT_IGNORE = "ignore";
    public static final String AJLINT_WARN = "warn";
    public static final String AJLINT_ERROR = "error";
    public static final String AJLINT_DEFAULT = "default";
    private File outputDir;
    private File outputJar;
    private List sourceRoots = new ArrayList();
    private List files = new ArrayList();
    private List binaryFiles = new ArrayList();
    private List inJars = new ArrayList();
    private List inPath = new ArrayList();
    private Map sourcePathResources = new HashMap();
    private List aspectpath = new ArrayList();
    private List classpath = new ArrayList();
    private Map javaOptions = new HashMap();
    private Map ajOptions = new HashMap();
    private File configFile;
    private boolean generateModelMode = false;
    private boolean generateJavadocsInModelMode = false;
    private boolean emacsSymMode = false;
    private boolean noWeave = false;
    private boolean XserializableAspects = false;
    private boolean XlazyTjp = false;
    private boolean XnoInline = false;
    private boolean Xreweavable = false;
    private boolean XreweavableCompressClasses = false;
    private String lintMode = "default";
    private File lintSpecFile = null;
    private boolean override = true;
    private boolean incrementalMode;
    private File incrementalFile;

    public AjBuildConfig() {
        this.javaOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", AJLINT_IGNORE);
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", AJLINT_IGNORE);
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", AJLINT_IGNORE);
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", AJLINT_IGNORE);
        this.javaOptions.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", AJLINT_IGNORE);
        this.javaOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.javaOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
    }

    public List getFiles() {
        return this.files;
    }

    public List getBinaryFiles() {
        return this.binaryFiles;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setFiles(List files) {
        this.files = files;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public Map getAjOptions() {
        return this.ajOptions;
    }

    public Map getJavaOptions() {
        return this.javaOptions;
    }

    public void setAjOptions(Map ajOptions) {
        this.ajOptions = ajOptions;
    }

    public void setJavaOptions(Map javaOptions) {
        this.javaOptions = javaOptions;
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List classpath) {
        this.classpath = classpath;
    }

    public File getOutputJar() {
        return this.outputJar;
    }

    public List getInpath() {
        return this.inPath;
    }

    public List getInJars() {
        return this.inJars;
    }

    public Map getSourcePathResources() {
        return this.sourcePathResources;
    }

    public void setOutputJar(File outputJar) {
        this.outputJar = outputJar;
    }

    public void setInJars(List sourceJars) {
        this.inJars = sourceJars;
    }

    public void setInPath(List dirsOrJars) {
        this.inPath = dirsOrJars;
        this.binaryFiles = new ArrayList();
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".class");
            }
        };
        Iterator iter = dirsOrJars.iterator();
        while (iter.hasNext()) {
            File inpathElement = (File)iter.next();
            if (!inpathElement.isDirectory()) continue;
            File[] files = FileUtil.listFiles(inpathElement, filter);
            int i = 0;
            while (i < files.length) {
                this.binaryFiles.add(new BinarySourceFile(inpathElement, files[i]));
                ++i;
            }
        }
    }

    public List getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(List sourceRootDir) {
        this.sourceRoots = sourceRootDir;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public boolean isEmacsSymMode() {
        return this.emacsSymMode;
    }

    public void setEmacsSymMode(boolean emacsSymMode) {
        this.emacsSymMode = emacsSymMode;
    }

    public boolean isGenerateModelMode() {
        return this.generateModelMode;
    }

    public void setGenerateModelMode(boolean structureModelMode) {
        this.generateModelMode = structureModelMode;
    }

    public void setIncrementalMode(boolean incrementalMode) {
        this.incrementalMode = incrementalMode;
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    public void setIncrementalFile(File incrementalFile) {
        this.incrementalFile = incrementalFile;
    }

    public boolean isIncrementalFileMode() {
        return null != this.incrementalFile;
    }

    public List getFullClasspath() {
        ArrayList<String> full = new ArrayList<String>();
        Iterator i = this.inJars.iterator();
        while (i.hasNext()) {
            full.add(((File)i.next()).getAbsolutePath());
        }
        Iterator i2 = this.inPath.iterator();
        while (i2.hasNext()) {
            full.add(((File)i2.next()).getAbsolutePath());
        }
        Iterator i3 = this.aspectpath.iterator();
        while (i3.hasNext()) {
            full.add(((File)i3.next()).getAbsolutePath());
        }
        full.addAll(this.getClasspath());
        return full;
    }

    public String getLintMode() {
        return this.lintMode;
    }

    public File getLintSpecFile() {
        return this.lintSpecFile;
    }

    public List getAspectpath() {
        return this.aspectpath;
    }

    public boolean isNoWeave() {
        return this.noWeave;
    }

    public void setLintMode(String lintMode) {
        this.lintMode = lintMode;
    }

    public void setLintSpecFile(File lintSpecFile) {
        this.lintSpecFile = lintSpecFile;
    }

    public void setAspectpath(List aspectpath) {
        this.aspectpath = aspectpath;
    }

    public void setNoWeave(boolean noWeave) {
        this.noWeave = noWeave;
    }

    public boolean isXserializableAspects() {
        return this.XserializableAspects;
    }

    public void setXserializableAspects(boolean xserializableAspects) {
        this.XserializableAspects = xserializableAspects;
    }

    public boolean isXnoInline() {
        return this.XnoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.XnoInline = xnoInline;
    }

    public boolean hasSources() {
        return null != this.configFile || 0 < this.sourceRoots.size() || 0 < this.files.size() || 0 < this.inJars.size() || 0 < this.inPath.size();
    }

    public void installGlobals(AjBuildConfig global) {
        this.join(this.ajOptions, global.ajOptions);
        this.join(this.aspectpath, global.aspectpath);
        this.join(this.classpath, global.classpath);
        if (null == this.configFile) {
            this.configFile = global.configFile;
        }
        if (!this.emacsSymMode && global.emacsSymMode) {
            this.emacsSymMode = true;
        }
        this.join(this.files, global.files);
        if (!this.generateModelMode && global.generateModelMode) {
            this.generateModelMode = true;
        }
        if (null == this.incrementalFile) {
            this.incrementalFile = global.incrementalFile;
        }
        if (!this.incrementalMode && global.incrementalMode) {
            this.incrementalMode = true;
        }
        this.join(this.inJars, global.inJars);
        this.join(this.inPath, global.inPath);
        this.join(this.javaOptions, global.javaOptions);
        if (null == this.lintMode || AJLINT_DEFAULT.equals(this.lintMode)) {
            this.lintMode = global.lintMode;
        }
        if (null == this.lintSpecFile) {
            this.lintSpecFile = global.lintSpecFile;
        }
        if (!this.noWeave && global.noWeave) {
            this.noWeave = true;
        }
        if (null == this.outputDir && null == this.outputJar) {
            if (null != global.outputDir) {
                this.outputDir = global.outputDir;
            }
            if (null != global.outputJar) {
                this.outputJar = global.outputJar;
            }
        }
        this.join(this.sourceRoots, global.sourceRoots);
        if (!this.XnoInline && global.XnoInline) {
            this.XnoInline = true;
        }
        if (!this.XserializableAspects && global.XserializableAspects) {
            this.XserializableAspects = true;
        }
    }

    void join(Collection local, Collection global) {
        Iterator iter = global.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (local.contains(next)) continue;
            local.add(next);
        }
    }

    void join(Map local, Map global) {
        Iterator iter = global.keySet().iterator();
        while (iter.hasNext()) {
            Object value;
            Object key = iter.next();
            if (!this.override && null != local.get(key) || null == (value = global.get(key))) continue;
            local.put(key, value);
        }
    }

    public void setSourcePathResources(Map map) {
        this.sourcePathResources = map;
    }

    public boolean shouldProceed() {
        return this.shouldProceed;
    }

    public void doNotProceed() {
        this.shouldProceed = false;
    }

    public boolean isXlazyTjp() {
        return this.XlazyTjp;
    }

    public void setXlazyTjp(boolean b) {
        this.XlazyTjp = b;
    }

    public void setXreweavable(boolean b) {
        this.Xreweavable = true;
    }

    public boolean isXreweavable() {
        return this.Xreweavable;
    }

    public void setXreweavableCompressClasses(boolean b) {
        this.XreweavableCompressClasses = true;
    }

    public boolean getXreweavableCompressClasses() {
        return this.XreweavableCompressClasses;
    }

    public boolean isGenerateJavadocsInModelMode() {
        return this.generateJavadocsInModelMode;
    }

    public void setGenerateJavadocsInModelMode(boolean generateJavadocsInModelMode) {
        this.generateJavadocsInModelMode = generateJavadocsInModelMode;
    }

    public static class BinarySourceFile {
        public File fromInPathDirectory;
        public File binSrc;

        public BinarySourceFile(File dir, File src) {
            this.fromInPathDirectory = dir;
            this.binSrc = src;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BinarySourceFile && obj != null) {
                BinarySourceFile other = (BinarySourceFile)obj;
                return this.binSrc.equals(other.binSrc);
            }
            return false;
        }

        public int hashCode() {
            return this.binSrc != null ? this.binSrc.hashCode() : 0;
        }
    }
}

