/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.GlobalViewProperties;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.internal.NavigationHistoryModel;
import org.aspectj.ajde.ui.internal.TreeStructureViewBuilder;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.internal.AspectJElementHierarchy;

public class StructureViewManager {
    private TreeStructureViewBuilder treeViewBuilder;
    private NavigationHistoryModel historyModel = new NavigationHistoryModel();
    private ArrayList structureViews = new ArrayList();
    private FileStructureView defaultFileView = null;
    private static final StructureViewProperties DEFAULT_VIEW_PROPERTIES;
    private static final List AVAILABLE_RELATIONS;
    public final IHierarchyListener VIEW_LISTENER = new IHierarchyListener(){

        public void elementsUpdated(IHierarchy model) {
            Ajde.getDefault().logEvent("updating structure views: " + StructureViewManager.this.structureViews);
            Iterator it = ((AbstractList)StructureViewManager.this.structureViews).iterator();
            while (it.hasNext()) {
                StructureViewManager.this.treeViewBuilder.buildView((StructureView)it.next(), (AspectJElementHierarchy)model);
            }
        }
    };

    public StructureViewManager(StructureViewNodeFactory nodeFactory) {
        this.treeViewBuilder = new TreeStructureViewBuilder(nodeFactory);
        AsmManager.getDefault().addListener(this.VIEW_LISTENER);
    }

    public void fireNavigateBackAction(StructureView view) {
        IProgramElement backNode = this.historyModel.navigateBack();
        if (backNode == null) {
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("No node to navigate back to in history");
        } else {
            this.navigationAction(backNode, false);
        }
    }

    public void fireNavigateForwardAction(StructureView view) {
        IProgramElement forwardNode = this.historyModel.navigateForward();
        if (forwardNode == null) {
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("No node to navigate forward to in history");
        } else {
            this.navigationAction(forwardNode, false);
        }
    }

    public void fireNavigationAction(String newFilePath, int lineNumber) {
        IProgramElement currNode = Ajde.getDefault().getStructureModelManager().getHierarchy().findElementForSourceLine(newFilePath, lineNumber);
        if (currNode instanceof IProgramElement) {
            this.navigationAction(currNode, true);
        }
    }

    public void fireNavigationAction(IProgramElement pe, boolean isLink) {
        this.navigationAction(pe, isLink);
    }

    private void navigationAction(IProgramElement node, boolean recordHistory) {
        if (node == null) {
            return;
        }
        Ajde.getDefault().logEvent("navigating to node: " + node + ", recordHistory: " + recordHistory);
        if (recordHistory) {
            this.historyModel.navigateToNode(node);
        }
        if (this.defaultFileView != null && node.getSourceLocation() != null) {
            String newFilePath = node.getSourceLocation().getSourceFile().getAbsolutePath();
            if (this.defaultFileView.getSourceFile() != null && !this.defaultFileView.getSourceFile().equals(newFilePath)) {
                this.defaultFileView.setSourceFile(newFilePath);
                this.treeViewBuilder.buildView(this.defaultFileView, AsmManager.getDefault().getHierarchy());
            }
        }
        Iterator it = ((AbstractList)this.structureViews).iterator();
        while (it.hasNext()) {
            StructureView view = (StructureView)it.next();
            if (view instanceof GlobalStructureView && recordHistory && this.defaultFileView != null) continue;
            if (node.getKind().equals(IProgramElement.Kind.CODE)) {
                IProgramElement parentNode = node.getParent();
                if (parentNode == null) continue;
                IStructureViewNode currNode = view.findCorrespondingViewNode(parentNode);
                int lineOffset = node.getSourceLocation().getLine() - parentNode.getSourceLocation().getLine();
                if (currNode == null) continue;
                view.setActiveNode(currNode, lineOffset);
                continue;
            }
            IStructureViewNode currNode = view.findCorrespondingViewNode(node);
            if (currNode == null) continue;
            view.setActiveNode(currNode);
        }
    }

    public void refreshView(StructureView view) {
        IStructureViewNode activeNode = view.getActiveNode();
        this.treeViewBuilder.buildView(view, Ajde.getDefault().getStructureModelManager().getHierarchy());
        view.setActiveNode(activeNode);
    }

    public StructureViewProperties getDefaultViewProperties() {
        return DEFAULT_VIEW_PROPERTIES;
    }

    public List getAvailableRelations() {
        return AVAILABLE_RELATIONS;
    }

    public GlobalStructureView createGlobalView(GlobalViewProperties properties) {
        GlobalStructureView view = new GlobalStructureView(properties);
        this.structureViews.add(view);
        return view;
    }

    public FileStructureView createViewForSourceFile(String sourceFilePath, StructureViewProperties properties) {
        Ajde.getDefault().logEvent("creating view for file: " + sourceFilePath);
        if (properties == null) {
            properties = DEFAULT_VIEW_PROPERTIES;
        }
        FileStructureView view = new FileStructureView(properties);
        view.setSourceFile(sourceFilePath);
        this.treeViewBuilder.buildView(view, AsmManager.getDefault().getHierarchy());
        this.structureViews.add(view);
        return view;
    }

    public boolean deleteView(StructureView view) {
        return ((AbstractCollection)this.structureViews).remove(view);
    }

    public void setDefaultFileView(FileStructureView defaultFileView) {
        this.defaultFileView = defaultFileView;
    }

    public FileStructureView getDefaultFileView() {
        return this.defaultFileView;
    }

    static {
        AVAILABLE_RELATIONS = new ArrayList();
        AVAILABLE_RELATIONS.add(IRelationship.Kind.ADVICE);
        AVAILABLE_RELATIONS.add(IRelationship.Kind.DECLARE);
        DEFAULT_VIEW_PROPERTIES = new StructureViewProperties();
        DEFAULT_VIEW_PROPERTIES.setRelations(AVAILABLE_RELATIONS);
    }
}

