/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource == null ? (class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.WrapperConnectionPoolDataSource")) : class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource);
    ConnectionTester connectionTester;
    Map userOverrides;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource;

    public WrapperConnectionPoolDataSource() {
        block2: {
            this.connectionTester = C3P0ImplUtils.defaultConnectionTester();
            VetoableChangeListener setConnectionTesterListener = new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    String propName = evt.getPropertyName();
                    Object val = evt.getNewValue();
                    if ("connectionTesterClassName".equals(propName)) {
                        try {
                            WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)val);
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "Failed to create ConnectionTester of class " + val, e);
                            }
                            throw new PropertyVetoException("Could not instantiate connection tester class with name '" + val + "'.", evt);
                        }
                    }
                    if ("userOverridesAsString".equals(propName)) {
                        try {
                            WrapperConnectionPoolDataSource.this.userOverrides = C3P0ImplUtils.parseUserOverridesAsString((String)val);
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + val, e);
                            }
                            throw new PropertyVetoException("Failed to parse stringified userOverrides. " + val, evt);
                        }
                    }
                }
            };
            this.addVetoableChangeListener(setConnectionTesterListener);
            try {
                this.userOverrides = C3P0ImplUtils.parseUserOverridesAsString(this.getUserOverridesAsString());
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block2;
                logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + this.getUserOverridesAsString(), e);
            }
        }
        C3P0Registry.register(this);
    }

    public WrapperConnectionPoolDataSource(String configName) {
        block3: {
            this();
            try {
                if (configName != null) {
                    C3P0Config.bindNamedConfigToBean(this, configName);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "Error binding WrapperConnectionPoolDataSource to named-config '" + configName + "'. Some default-config values may be used.", e);
            }
        }
    }

    public PooledConnection getPooledConnection() throws SQLException {
        DataSource nds = this.getNestedDataSource();
        if (nds == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection conn = nds.getConnection();
        if (conn == null) {
            throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
        }
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        DataSource nds = this.getNestedDataSource();
        if (nds == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection conn = nds.getConnection(user, password);
        if (conn == null) {
            throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
        }
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getNestedDataSource().setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'user' property from our nested DataSource. Defaulting to no specified username.", e);
            }
            return null;
        }
    }

    public String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'password' property from our nested DataSource. Defaulting to no specified password.", e);
            }
            return null;
        }
    }

    public Map getUserOverrides() {
        return this.userOverrides;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        return sb.toString();
    }

    protected String extraToStringInfo() {
        if (this.userOverrides != null) {
            return "; userOverrides: " + this.userOverrides.toString();
        }
        return null;
    }

    private synchronized void recreateConnectionTester(String className) throws Exception {
        ConnectionTester ct;
        this.connectionTester = className != null ? (ct = (ConnectionTester)Class.forName(className).newInstance()) : C3P0ImplUtils.defaultConnectionTester();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

