/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.VersionedStringProperty;
import com.mysql.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class CharsetMapping {
    private static final Properties CHARSET_CONFIG;
    public static final String[] INDEX_TO_CHARSET;
    private static final Map JAVA_TO_MYSQL_CHARSET_MAP;
    private static final Map JAVA_UC_TO_MYSQL_CHARSET_MAP;
    private static final Map MULTIBYTE_CHARSETS;
    private static final Map MYSQL_TO_JAVA_CHARSET_MAP;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("CharsetMapping.java", Class.forName("com.mysql.jdbc.CharsetMapping"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-getJavaEncodingForMysqlEncoding-com.mysql.jdbc.CharsetMapping-java.lang.String:com.mysql.jdbc.Connection:-mysqlEncoding:conn:-java.sql.SQLException:-java.lang.String-"), 408);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-getMysqlEncodingForJavaEncoding-com.mysql.jdbc.CharsetMapping-java.lang.String:com.mysql.jdbc.Connection:-javaEncodingUC:conn:-java.sql.SQLException:-java.lang.String-"), 418);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-getNumberOfCharsetsConfigured-com.mysql.jdbc.CharsetMapping----int-"), 465);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-isAliasForSjis-com.mysql.jdbc.CharsetMapping-java.lang.String:-encoding:--boolean-"), 470);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("18-isMultibyteCharset-com.mysql.jdbc.CharsetMapping-java.lang.String:-javaEncodingName:--boolean-"), 479);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-populateMapWithKeyValuePairs-com.mysql.jdbc.CharsetMapping-java.lang.String:java.util.Map:boolean:boolean:-configKey:mapToPopulate:addVersionedProperties:addUppercaseKeys:--void-"), 488);
        CHARSET_CONFIG = new Properties();
        CHARSET_CONFIG.setProperty("javaToMysqlMappings", "US-ASCII =\t\t\tusa7,US-ASCII =\t\t\tascii,Big5 = \t\t\t\tbig5,GBK = \t\t\t\tgbk,SJIS = \t\t\t\tsjis,EUC_CN = \t\t\tgb2312,EUC_JP = \t\t\tujis,EUC_JP_Solaris = \t>5.0.3 eucjpms,EUC_KR = \t\t\teuc_kr,EUC_KR = \t\t\t>4.1.0 euckr,ISO8859_1 =\t\t\t*latin1,ISO8859_1 =\t\t\tlatin1_de,ISO8859_1 =\t\t\tgerman1,ISO8859_1 =\t\t\tdanish,ISO8859_2 =\t\t\tlatin2,ISO8859_2 =\t\t\tczech,ISO8859_2 =\t\t\thungarian,ISO8859_2  =\t\tcroat,ISO8859_7  =\t\tgreek,ISO8859_7  =\t\tlatin7,ISO8859_8  = \t\thebrew,ISO8859_9  =\t\tlatin5,ISO8859_13 =\t\tlatvian,ISO8859_13 =\t\tlatvian1,ISO8859_13 =\t\testonia,Cp437 =             *>4.1.0 cp850,Cp437 =\t\t\t\tdos,Cp850 =\t\t\t\tCp850,Cp852 = \t\t\tCp852,Cp866 = \t\t\tcp866,KOI8_R = \t\t\tkoi8_ru,KOI8_R = \t\t\t>4.1.0 koi8r,TIS620 = \t\t\ttis620,Cp1250 = \t\t\tcp1250,Cp1250 = \t\t\twin1250,Cp1251 = \t\t\t*>4.1.0 cp1251,Cp1251 = \t\t\twin1251,Cp1251 = \t\t\tcp1251cias,Cp1251 = \t\t\tcp1251csas,Cp1256 = \t\t\tcp1256,Cp1251 = \t\t\twin1251ukr,Cp1252 =             latin1,Cp1257 = \t\t\tcp1257,MacRoman = \t\t\tmacroman,MacCentralEurope = \tmacce,UTF-8 = \t\tutf8,UnicodeBig = \tucs2,US-ASCII =\t\tbinary,Cp943 =        \tsjis,MS932 =\t\t\tsjis,MS932 =        \t>4.1.11 cp932,WINDOWS-31J =\tsjis,WINDOWS-31J = \t>4.1.11 cp932,CP932 =\t\t\tsjis,CP932 =\t\t\t*>4.1.11 cp932,SHIFT_JIS = \tsjis,ASCII =\t\t\tascii,LATIN5 =\t\tlatin5,LATIN7 =\t\tlatin7,HEBREW =\t\thebrew,GREEK =\t\t\tgreek,EUCKR =\t\t\teuckr,GB2312 =\t\tgb2312,LATIN2 =\t\tlatin2");
        HashMap javaToMysqlMap = new HashMap();
        CharsetMapping.populateMapWithKeyValuePairs("javaToMysqlMappings", javaToMysqlMap, true, false);
        JAVA_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(javaToMysqlMap);
        HashMap mysqlToJavaMap = new HashMap();
        Set keySet = JAVA_TO_MYSQL_CHARSET_MAP.keySet();
        Iterator javaCharsets = keySet.iterator();
        while (javaCharsets.hasNext()) {
            Object javaEncodingName = javaCharsets.next();
            List mysqlEncodingList = (List)JAVA_TO_MYSQL_CHARSET_MAP.get(javaEncodingName);
            Iterator mysqlEncodings = mysqlEncodingList.iterator();
            String mysqlEncodingName = null;
            while (mysqlEncodings.hasNext()) {
                VersionedStringProperty mysqlProp = (VersionedStringProperty)mysqlEncodings.next();
                mysqlEncodingName = mysqlProp.toString();
                mysqlToJavaMap.put(mysqlEncodingName, javaEncodingName);
                mysqlToJavaMap.put(mysqlEncodingName.toUpperCase(Locale.ENGLISH), javaEncodingName);
            }
        }
        mysqlToJavaMap.put("cp932", "Windows-31J");
        mysqlToJavaMap.put("CP932", "Windows-31J");
        MYSQL_TO_JAVA_CHARSET_MAP = Collections.unmodifiableMap(mysqlToJavaMap);
        HashMap ucMap = new HashMap(JAVA_TO_MYSQL_CHARSET_MAP.size());
        Iterator javaNamesKeys = JAVA_TO_MYSQL_CHARSET_MAP.keySet().iterator();
        while (javaNamesKeys.hasNext()) {
            String key = (String)javaNamesKeys.next();
            ucMap.put(key.toUpperCase(Locale.ENGLISH), JAVA_TO_MYSQL_CHARSET_MAP.get(key));
        }
        JAVA_UC_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(ucMap);
        HashMap tempMapMulti = new HashMap();
        CHARSET_CONFIG.setProperty("multibyteCharsets", "Big5 = \t\t\tbig5,GBK = \t\t\tgbk,SJIS = \t\t\tsjis,EUC_CN = \t\tgb2312,EUC_JP = \t\tujis,EUC_JP_Solaris = eucjpms,EUC_KR = \t\teuc_kr,EUC_KR = \t\t>4.1.0 euckr,Cp943 =        \tsjis,Cp943 = \t\tcp943,WINDOWS-31J =\tsjis,WINDOWS-31J = \tcp932,CP932 =\t\t\tcp932,MS932 =\t\t\tsjis,MS932 =        \tcp932,SHIFT_JIS = \tsjis,EUCKR =\t\t\teuckr,GB2312 =\t\tgb2312,UTF-8 = \t\tutf8,utf8 =          utf8,UnicodeBig = \tucs2");
        CharsetMapping.populateMapWithKeyValuePairs("multibyteCharsets", tempMapMulti, false, true);
        MULTIBYTE_CHARSETS = Collections.unmodifiableMap(tempMapMulti);
        INDEX_TO_CHARSET = new String[99];
        try {
            CharsetMapping.INDEX_TO_CHARSET[1] = CharsetMapping.getJavaEncodingForMysqlEncoding("big5", null);
            CharsetMapping.INDEX_TO_CHARSET[2] = CharsetMapping.getJavaEncodingForMysqlEncoding("czech", null);
            CharsetMapping.INDEX_TO_CHARSET[3] = CharsetMapping.getJavaEncodingForMysqlEncoding("dec8", null);
            CharsetMapping.INDEX_TO_CHARSET[4] = CharsetMapping.getJavaEncodingForMysqlEncoding("dos", null);
            CharsetMapping.INDEX_TO_CHARSET[5] = CharsetMapping.getJavaEncodingForMysqlEncoding("german1", null);
            CharsetMapping.INDEX_TO_CHARSET[6] = CharsetMapping.getJavaEncodingForMysqlEncoding("hp8", null);
            CharsetMapping.INDEX_TO_CHARSET[7] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8_ru", null);
            CharsetMapping.INDEX_TO_CHARSET[8] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1", null);
            CharsetMapping.INDEX_TO_CHARSET[9] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin2", null);
            CharsetMapping.INDEX_TO_CHARSET[10] = CharsetMapping.getJavaEncodingForMysqlEncoding("swe7", null);
            CharsetMapping.INDEX_TO_CHARSET[11] = CharsetMapping.getJavaEncodingForMysqlEncoding("usa7", null);
            CharsetMapping.INDEX_TO_CHARSET[12] = CharsetMapping.getJavaEncodingForMysqlEncoding("ujis", null);
            CharsetMapping.INDEX_TO_CHARSET[13] = CharsetMapping.getJavaEncodingForMysqlEncoding("sjis", null);
            CharsetMapping.INDEX_TO_CHARSET[14] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251", null);
            CharsetMapping.INDEX_TO_CHARSET[15] = CharsetMapping.getJavaEncodingForMysqlEncoding("danish", null);
            CharsetMapping.INDEX_TO_CHARSET[16] = CharsetMapping.getJavaEncodingForMysqlEncoding("hebrew", null);
            CharsetMapping.INDEX_TO_CHARSET[18] = CharsetMapping.getJavaEncodingForMysqlEncoding("tis620", null);
            CharsetMapping.INDEX_TO_CHARSET[19] = CharsetMapping.getJavaEncodingForMysqlEncoding("euc_kr", null);
            CharsetMapping.INDEX_TO_CHARSET[20] = CharsetMapping.getJavaEncodingForMysqlEncoding("estonia", null);
            CharsetMapping.INDEX_TO_CHARSET[21] = CharsetMapping.getJavaEncodingForMysqlEncoding("hungarian", null);
            CharsetMapping.INDEX_TO_CHARSET[22] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8_ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[23] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1251ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[24] = CharsetMapping.getJavaEncodingForMysqlEncoding("gb2312", null);
            CharsetMapping.INDEX_TO_CHARSET[25] = CharsetMapping.getJavaEncodingForMysqlEncoding("greek", null);
            CharsetMapping.INDEX_TO_CHARSET[26] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1250", null);
            CharsetMapping.INDEX_TO_CHARSET[27] = CharsetMapping.getJavaEncodingForMysqlEncoding("croat", null);
            CharsetMapping.INDEX_TO_CHARSET[28] = CharsetMapping.getJavaEncodingForMysqlEncoding("gbk", null);
            CharsetMapping.INDEX_TO_CHARSET[29] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1257", null);
            CharsetMapping.INDEX_TO_CHARSET[30] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin5", null);
            CharsetMapping.INDEX_TO_CHARSET[31] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1_de", null);
            CharsetMapping.INDEX_TO_CHARSET[32] = CharsetMapping.getJavaEncodingForMysqlEncoding("armscii8", null);
            CharsetMapping.INDEX_TO_CHARSET[33] = CharsetMapping.getJavaEncodingForMysqlEncoding("utf8", null);
            CharsetMapping.INDEX_TO_CHARSET[34] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1250ch", null);
            CharsetMapping.INDEX_TO_CHARSET[35] = CharsetMapping.getJavaEncodingForMysqlEncoding("ucs2", null);
            CharsetMapping.INDEX_TO_CHARSET[36] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp866", null);
            CharsetMapping.INDEX_TO_CHARSET[37] = CharsetMapping.getJavaEncodingForMysqlEncoding("keybcs2", null);
            CharsetMapping.INDEX_TO_CHARSET[38] = CharsetMapping.getJavaEncodingForMysqlEncoding("macce", null);
            CharsetMapping.INDEX_TO_CHARSET[39] = CharsetMapping.getJavaEncodingForMysqlEncoding("macroman", null);
            CharsetMapping.INDEX_TO_CHARSET[40] = CharsetMapping.getJavaEncodingForMysqlEncoding("pclatin2", null);
            CharsetMapping.INDEX_TO_CHARSET[41] = CharsetMapping.getJavaEncodingForMysqlEncoding("latvian", null);
            CharsetMapping.INDEX_TO_CHARSET[42] = CharsetMapping.getJavaEncodingForMysqlEncoding("latvian1", null);
            CharsetMapping.INDEX_TO_CHARSET[43] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccebin", null);
            CharsetMapping.INDEX_TO_CHARSET[44] = CharsetMapping.getJavaEncodingForMysqlEncoding("macceciai", null);
            CharsetMapping.INDEX_TO_CHARSET[45] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccecias", null);
            CharsetMapping.INDEX_TO_CHARSET[46] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccecsas", null);
            CharsetMapping.INDEX_TO_CHARSET[47] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1bin", null);
            CharsetMapping.INDEX_TO_CHARSET[48] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1cias", null);
            CharsetMapping.INDEX_TO_CHARSET[49] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1csas", null);
            CharsetMapping.INDEX_TO_CHARSET[50] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251bin", null);
            CharsetMapping.INDEX_TO_CHARSET[51] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251cias", null);
            CharsetMapping.INDEX_TO_CHARSET[52] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251csas", null);
            CharsetMapping.INDEX_TO_CHARSET[53] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromanbin", null);
            CharsetMapping.INDEX_TO_CHARSET[54] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromancias", null);
            CharsetMapping.INDEX_TO_CHARSET[55] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromanciai", null);
            CharsetMapping.INDEX_TO_CHARSET[56] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromancsas", null);
            CharsetMapping.INDEX_TO_CHARSET[57] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1256", null);
            CharsetMapping.INDEX_TO_CHARSET[63] = CharsetMapping.getJavaEncodingForMysqlEncoding("binary", null);
            CharsetMapping.INDEX_TO_CHARSET[64] = CharsetMapping.getJavaEncodingForMysqlEncoding("armscii", null);
            CharsetMapping.INDEX_TO_CHARSET[65] = CharsetMapping.getJavaEncodingForMysqlEncoding("ascii", null);
            CharsetMapping.INDEX_TO_CHARSET[66] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1250", null);
            CharsetMapping.INDEX_TO_CHARSET[67] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1256", null);
            CharsetMapping.INDEX_TO_CHARSET[68] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp866", null);
            CharsetMapping.INDEX_TO_CHARSET[69] = CharsetMapping.getJavaEncodingForMysqlEncoding("dec8", null);
            CharsetMapping.INDEX_TO_CHARSET[70] = CharsetMapping.getJavaEncodingForMysqlEncoding("greek", null);
            CharsetMapping.INDEX_TO_CHARSET[71] = CharsetMapping.getJavaEncodingForMysqlEncoding("hebrew", null);
            CharsetMapping.INDEX_TO_CHARSET[72] = CharsetMapping.getJavaEncodingForMysqlEncoding("hp8", null);
            CharsetMapping.INDEX_TO_CHARSET[73] = CharsetMapping.getJavaEncodingForMysqlEncoding("keybcs2", null);
            CharsetMapping.INDEX_TO_CHARSET[74] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8r", null);
            CharsetMapping.INDEX_TO_CHARSET[75] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[77] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin2", null);
            CharsetMapping.INDEX_TO_CHARSET[78] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin5", null);
            CharsetMapping.INDEX_TO_CHARSET[79] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin7", null);
            CharsetMapping.INDEX_TO_CHARSET[80] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp850", null);
            CharsetMapping.INDEX_TO_CHARSET[81] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp852", null);
            CharsetMapping.INDEX_TO_CHARSET[82] = CharsetMapping.getJavaEncodingForMysqlEncoding("swe7", null);
            CharsetMapping.INDEX_TO_CHARSET[83] = CharsetMapping.getJavaEncodingForMysqlEncoding("utf8", null);
            CharsetMapping.INDEX_TO_CHARSET[84] = CharsetMapping.getJavaEncodingForMysqlEncoding("big5", null);
            CharsetMapping.INDEX_TO_CHARSET[85] = CharsetMapping.getJavaEncodingForMysqlEncoding("euckr", null);
            CharsetMapping.INDEX_TO_CHARSET[86] = CharsetMapping.getJavaEncodingForMysqlEncoding("gb2312", null);
            CharsetMapping.INDEX_TO_CHARSET[87] = CharsetMapping.getJavaEncodingForMysqlEncoding("gbk", null);
            CharsetMapping.INDEX_TO_CHARSET[88] = CharsetMapping.getJavaEncodingForMysqlEncoding("sjis", null);
            CharsetMapping.INDEX_TO_CHARSET[89] = CharsetMapping.getJavaEncodingForMysqlEncoding("tis620", null);
            CharsetMapping.INDEX_TO_CHARSET[90] = CharsetMapping.getJavaEncodingForMysqlEncoding("ucs2", null);
            CharsetMapping.INDEX_TO_CHARSET[91] = CharsetMapping.getJavaEncodingForMysqlEncoding("ujis", null);
            CharsetMapping.INDEX_TO_CHARSET[92] = CharsetMapping.getJavaEncodingForMysqlEncoding("geostd8", null);
            CharsetMapping.INDEX_TO_CHARSET[93] = CharsetMapping.getJavaEncodingForMysqlEncoding("geostd8", null);
            CharsetMapping.INDEX_TO_CHARSET[94] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1", null);
            CharsetMapping.INDEX_TO_CHARSET[95] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp932", null);
            CharsetMapping.INDEX_TO_CHARSET[96] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp932", null);
            CharsetMapping.INDEX_TO_CHARSET[97] = CharsetMapping.getJavaEncodingForMysqlEncoding("eucjpms", null);
            CharsetMapping.INDEX_TO_CHARSET[98] = CharsetMapping.getJavaEncodingForMysqlEncoding("eucjpms", null);
        }
        catch (SQLException sQLException) {}
    }

    /*
     * WARNING - void declaration
     */
    static final String getJavaEncodingForMysqlEncoding(String string, Connection connection) throws SQLException {
        String mysqlEncoding;
        void conn;
        String string2 = string;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2, (Object)connection2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = conn != null && conn.versionMeetsMinimum(4, 1, 0) && "latin1".equalsIgnoreCase(mysqlEncoding) ? "Cp1252" : (String)MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlEncoding);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    static final String getMysqlEncodingForJavaEncoding(String var0, Connection var1_1) throws SQLException {
        block6: {
            var7_2 = var0;
            var8_3 = var1_1;
            var6_4 = Factory.makeJP((JoinPoint.StaticPart)CharsetMapping.ajc$tjp_1, null, null, (Object)var7_2, (Object)var8_3);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(var6_4);
            mysqlEncodings = (List)CharsetMapping.JAVA_UC_TO_MYSQL_CHARSET_MAP.get(javaEncodingUC);
            if (mysqlEncodings == null) ** GOTO lbl-1000
            iter = mysqlEncodings.iterator();
            versionedProp = null;
            while (iter.hasNext()) {
                propToCheck = (VersionedStringProperty)iter.next();
                if (conn == null) {
                    v0 = propToCheck.toString();
                    break block6;
                }
                if (versionedProp != null && !versionedProp.preferredValue && versionedProp.majorVersion == propToCheck.majorVersion && versionedProp.minorVersion == propToCheck.minorVersion && versionedProp.subminorVersion == propToCheck.subminorVersion) {
                    v0 = versionedProp.toString();
                    break block6;
                }
                if (!propToCheck.isOkayForVersion((Connection)conn)) break;
                if (propToCheck.preferredValue) {
                    v0 = propToCheck.toString();
                    break block6;
                }
                versionedProp = propToCheck;
            }
            if (versionedProp != null) {
                v0 = versionedProp.toString();
            } else lbl-1000:
            // 2 sources

            {
                v0 = null;
            }
        }
        var9_9 = v0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, var6_4);
        return v0;
    }

    static final int getNumberOfCharsetsConfigured() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = MYSQL_TO_JAVA_CHARSET_MAP.size() / 2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    static final boolean isAliasForSjis(String string) {
        String encoding;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = "SJIS".equalsIgnoreCase(encoding) || "WINDOWS-31J".equalsIgnoreCase(encoding) || "MS932".equalsIgnoreCase(encoding) || "SHIFT_JIS".equalsIgnoreCase(encoding) || "CP943".equalsIgnoreCase(encoding);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    static final boolean isMultibyteCharset(String string) {
        String javaEncodingName;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String javaEncodingNameUC = javaEncodingName.toUpperCase(Locale.ENGLISH);
        boolean bl = MULTIBYTE_CHARSETS.containsKey(javaEncodingNameUC);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void populateMapWithKeyValuePairs(String string, Map map, boolean bl, boolean bl2) {
        String configKey;
        String string2 = string;
        Map map2 = map;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        Object[] objectArray = new Object[]{string2, map2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String javaToMysqlConfig = CHARSET_CONFIG.getProperty(configKey);
        if (javaToMysqlConfig == null) throw new RuntimeException("Could not find configuration value \"" + configKey + "\" in Charsets.properties resource");
        List mappings = StringUtils.split(javaToMysqlConfig, ",", true);
        if (mappings == null) throw new RuntimeException("Missing/corrupt entry for \"" + configKey + "\" in Charsets.properties.");
        Iterator mappingsIter = mappings.iterator();
        while (mappingsIter.hasNext()) {
            void addUppercaseKeys;
            void mapToPopulate;
            void addVersionedProperties;
            String aMapping = (String)mappingsIter.next();
            List parsedPair = StringUtils.split(aMapping, "=", true);
            if (parsedPair.size() != 2) throw new RuntimeException("Syntax error in Charsets.properties resource for token \"" + aMapping + "\".");
            String key = parsedPair.get(0).toString();
            String value = parsedPair.get(1).toString();
            if (addVersionedProperties != false) {
                List<VersionedStringProperty> versionedProperties = (ArrayList<VersionedStringProperty>)mapToPopulate.get(key);
                if (versionedProperties == null) {
                    versionedProperties = new ArrayList<VersionedStringProperty>();
                    mapToPopulate.put(key, versionedProperties);
                }
                VersionedStringProperty verProp = new VersionedStringProperty(value);
                versionedProperties.add(verProp);
                if (addUppercaseKeys == false) continue;
                String keyUc = key.toUpperCase(Locale.ENGLISH);
                versionedProperties = (List)mapToPopulate.get(keyUc);
                if (versionedProperties == null) {
                    versionedProperties = new ArrayList();
                    mapToPopulate.put(keyUc, versionedProperties);
                }
                versionedProperties.add(verProp);
                continue;
            }
            mapToPopulate.put(key, value);
            if (addUppercaseKeys == false) continue;
            mapToPopulate.put(key.toUpperCase(Locale.ENGLISH), value);
        }
        Object var20_20 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var20_20, joinPoint);
    }
}

