/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;

public class PackageReferencePattern
extends AndPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new PackageReferencePattern("*".toCharArray(), 4);
        }
    };
    protected char[] pkgName;
    protected char[][] segments;
    protected int currentSegment;

    public static PackageReferencePattern getPackageReferenceRecord() {
        return (PackageReferencePattern)indexRecord.get();
    }

    public PackageReferencePattern(char[] pkgName, int matchRule) {
        super(1, matchRule);
        if (pkgName == null || pkgName.length == 0) {
            this.pkgName = null;
            this.segments = new char[][]{CharOperation.NO_CHAR};
            this.mustResolve = false;
        } else {
            this.pkgName = this.isCaseSensitive() ? pkgName : CharOperation.toLowerCase(pkgName);
            this.segments = CharOperation.splitOn('.', this.pkgName);
            this.mustResolve = true;
        }
    }

    public void decodeIndexKey(char[] key) {
        this.segments[0] = key;
    }

    public char[] encodeIndexKey() {
        if (this.currentSegment < 0) {
            return null;
        }
        return this.encodeIndexKey(this.segments[this.currentSegment]);
    }

    public SearchPattern getIndexRecord() {
        return PackageReferencePattern.getPackageReferenceRecord();
    }

    public char[][] getMatchCategories() {
        return new char[][]{IIndexConstants.REF};
    }

    protected boolean hasNextQuery() {
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean isMatchingIndexRecord() {
        return this.matchesName(this.segments[this.currentSegment], ((PackageReferencePattern)this.getIndexRecord()).segments[0]);
    }

    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            buffer.append(this.pkgName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
                break;
            }
            case 3: {
                buffer.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

