/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaElementRequestor;

class SearchableEnvironmentRequestor
extends JavaElementRequestor
implements IJavaElementRequestor {
    protected ISearchRequestor fRequestor;
    protected ICompilationUnit fUnitToSkip;

    public SearchableEnvironmentRequestor(ISearchRequestor requestor) {
        this.fRequestor = requestor;
        this.fUnitToSkip = null;
    }

    public SearchableEnvironmentRequestor(ISearchRequestor requestor, ICompilationUnit unitToSkip) {
        this.fRequestor = requestor;
        this.fUnitToSkip = unitToSkip;
    }

    public void acceptInitializer(IInitializer initializer) {
    }

    public void acceptPackageFragment(IPackageFragment packageFragment) {
        this.fRequestor.acceptPackage(packageFragment.getElementName().toCharArray());
    }

    public void acceptType(IType type) {
        try {
            if (this.fUnitToSkip != null && this.fUnitToSkip.equals(type.getCompilationUnit())) {
                return;
            }
            if (type.isClass()) {
                this.fRequestor.acceptClass(type.getPackageFragment().getElementName().toCharArray(), type.getElementName().toCharArray(), type.getFlags());
            } else {
                this.fRequestor.acceptInterface(type.getPackageFragment().getElementName().toCharArray(), type.getElementName().toCharArray(), type.getFlags());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

