/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public CaseLabel targetLabel;

    public CaseStatement(Expression constantExpression, int sourceEnd, int sourceStart) {
        this.constantExpression = constantExpression;
        this.sourceEnd = sourceEnd;
        this.sourceStart = sourceStart;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression != null) {
            if (this.constantExpression.constant == ASTNode.NotAConstant) {
                currentScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
            }
            this.constantExpression.analyseCode(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output);
        if (this.constantExpression == null) {
            output.append("default : ");
        } else {
            output.append("case ");
            this.constantExpression.printExpression(0, output).append(" : ");
        }
        return output.append(';');
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.targetLabel.place();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
    }

    public Constant resolveCase(BlockScope scope, TypeBinding switchType, SwitchStatement switchStatement) {
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                scope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return null;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        TypeBinding caseType = this.constantExpression.resolveType(scope);
        if (caseType == null || switchType == null) {
            return null;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(caseType, switchType)) {
            return this.constantExpression.constant;
        }
        if (caseType.isCompatibleWith(switchType)) {
            return this.constantExpression.constant;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.constantExpression, caseType, switchType);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.constantExpression != null) {
            this.constantExpression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

