/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnImportReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnPackageReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnQualifiedTypeReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnSingleTypeReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.SelectionRequestor;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.ASTNodeFinder;

public final class SelectionEngine
extends Engine
implements ISearchRequestor {
    public static boolean DEBUG = false;
    SelectionParser parser;
    ISelectionRequestor requestor;
    boolean acceptedAnswer;
    private int actualSelectionStart;
    private int actualSelectionEnd;
    private char[] qualifiedSelection;
    private char[] selectedIdentifier;
    private char[][][] acceptedClasses;
    private char[][][] acceptedInterfaces;
    int acceptedClassesCount;
    int acceptedInterfacesCount;
    boolean noProposal = true;
    IProblem problem = null;

    public SelectionEngine(ISearchableNameEnvironment nameEnvironment, ISelectionRequestor requestor, Map settings) {
        super(settings);
        this.requestor = requestor;
        this.nameEnvironment = nameEnvironment;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory(Locale.getDefault())){

            public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber, ReferenceContext refContext, CompilationResult unitResult) {
                IProblem pb = super.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, refContext, unitResult);
                if (SelectionEngine.this.problem == null && pb.isError() && (pb.getID() & 0x40000000) == 0) {
                    SelectionEngine.this.problem = pb;
                }
                return pb;
            }
        };
        this.lookupEnvironment = new LookupEnvironment(this, this.compilerOptions, problemReporter, nameEnvironment);
        this.parser = new SelectionParser(problemReporter);
    }

    public void acceptClass(char[] packageName, char[] className, int modifiers) {
        if (CharOperation.equals(className, this.selectedIdentifier)) {
            if (this.qualifiedSelection != null && !CharOperation.equals(this.qualifiedSelection, CharOperation.concat(packageName, className, '.'))) {
                return;
            }
            if (this.mustQualifyType(packageName, className)) {
                int length;
                char[][] acceptedClass = new char[][]{packageName, className};
                if (this.acceptedClasses == null) {
                    this.acceptedClasses = new char[10][][];
                    this.acceptedClassesCount = 0;
                }
                if ((length = this.acceptedClasses.length) == this.acceptedClassesCount) {
                    this.acceptedClasses = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedClasses, 0, this.acceptedClasses, 0, length);
                }
                this.acceptedClasses[this.acceptedClassesCount++] = acceptedClass;
            } else {
                this.noProposal = false;
                this.requestor.acceptClass(packageName, className, false);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, int modifiers) {
        if (CharOperation.equals(interfaceName, this.selectedIdentifier)) {
            if (this.qualifiedSelection != null && !CharOperation.equals(this.qualifiedSelection, CharOperation.concat(packageName, interfaceName, '.'))) {
                return;
            }
            if (this.mustQualifyType(packageName, interfaceName)) {
                int length;
                char[][] acceptedInterface = new char[][]{packageName, interfaceName};
                if (this.acceptedInterfaces == null) {
                    this.acceptedInterfaces = new char[10][][];
                    this.acceptedInterfacesCount = 0;
                }
                if ((length = this.acceptedInterfaces.length) == this.acceptedInterfacesCount) {
                    this.acceptedInterfaces = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedInterfaces, 0, this.acceptedInterfaces, 0, length);
                }
                this.acceptedInterfaces[this.acceptedInterfacesCount++] = acceptedInterface;
            } else {
                this.noProposal = false;
                this.requestor.acceptInterface(packageName, interfaceName, false);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptPackage(char[] packageName) {
    }

    private void acceptQualifiedTypes() {
        int i;
        if (this.acceptedClasses != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedClassesCount) {
                this.noProposal = false;
                this.requestor.acceptClass(this.acceptedClasses[i][0], this.acceptedClasses[i][1], true);
                ++i;
            }
            this.acceptedClasses = null;
            this.acceptedClassesCount = 0;
        }
        if (this.acceptedInterfaces != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedInterfacesCount) {
                this.noProposal = false;
                this.requestor.acceptInterface(this.acceptedInterfaces[i][0], this.acceptedInterfaces[i][1], true);
                ++i;
            }
            this.acceptedInterfaces = null;
            this.acceptedInterfacesCount = 0;
        }
    }

    public void acceptType(char[] packageName, char[] typeName) {
        this.acceptClass(packageName, typeName, 0);
    }

    private boolean checkSelection(char[] source, int selectionStart, int selectionEnd) {
        Scanner scanner = new Scanner();
        scanner.setSource(source);
        int lastIdentifierStart = -1;
        int lastIdentifierEnd = -1;
        char[] lastIdentifier = null;
        int identCount = 0;
        StringBuffer entireSelection = new StringBuffer(selectionEnd - selectionStart + 1);
        if (selectionStart > selectionEnd) {
            int token;
            int currentPosition = selectionStart - 1;
            int nextCharacterPosition = selectionStart;
            int currentCharacter = 32;
            try {
                while (currentPosition > 0) {
                    if (source[currentPosition] == '\\' && source[currentPosition + 1] == 'u') {
                        int pos = currentPosition + 2;
                        int c1 = 0;
                        int c2 = 0;
                        int c3 = 0;
                        int c4 = 0;
                        while (source[pos] == 'u') {
                            ++pos;
                        }
                        if ((c1 = Character.getNumericValue(source[pos++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(source[pos++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(source[pos++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(source[pos++])) > 15 || c4 < 0) {
                            return false;
                        }
                        currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                        nextCharacterPosition = pos;
                    } else {
                        currentCharacter = source[currentPosition];
                        nextCharacterPosition = currentPosition + 1;
                    }
                    if (currentCharacter != 13 && currentCharacter != 10) {
                        --currentPosition;
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            scanner.resetTo(nextCharacterPosition, selectionEnd + 1);
            do {
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    return false;
                }
                if (token != 50 && token != 49 && token != 24 || scanner.startPosition > selectionStart || selectionStart > scanner.currentPosition) continue;
                lastIdentifierStart = scanner.startPosition;
                lastIdentifierEnd = scanner.currentPosition - 1;
                lastIdentifier = scanner.getCurrentTokenSource();
            } while (token != 75);
        } else {
            int token;
            scanner.resetTo(selectionStart, selectionEnd);
            boolean expectingIdentifier = true;
            block14: do {
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    return false;
                }
                switch (token) {
                    case 24: 
                    case 49: 
                    case 50: {
                        if (!expectingIdentifier) {
                            return false;
                        }
                        lastIdentifier = scanner.getCurrentTokenSource();
                        lastIdentifierStart = scanner.startPosition;
                        lastIdentifierEnd = scanner.currentPosition - 1;
                        if (lastIdentifierEnd > selectionEnd) {
                            lastIdentifierEnd = selectionEnd;
                            lastIdentifier = CharOperation.subarray(lastIdentifier, 0, lastIdentifierEnd - lastIdentifierStart + 1);
                        }
                        entireSelection.append(lastIdentifier);
                        ++identCount;
                        expectingIdentifier = false;
                        break;
                    }
                    case 1: {
                        if (expectingIdentifier) {
                            return false;
                        }
                        entireSelection.append('.');
                        expectingIdentifier = true;
                        break;
                    }
                    case 75: {
                        if (!expectingIdentifier) continue block14;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            } while (token != 75);
        }
        if (lastIdentifierStart > 0) {
            this.actualSelectionStart = lastIdentifierStart;
            this.actualSelectionEnd = lastIdentifierEnd;
            this.selectedIdentifier = lastIdentifier;
            if (identCount > 1) {
                this.qualifiedSelection = entireSelection.toString().toCharArray();
            }
            return true;
        }
        return false;
    }

    public AssistParser getParser() {
        return this.parser;
    }

    private boolean isLocal(ReferenceBinding binding) {
        if (!(binding instanceof SourceTypeBinding)) {
            return false;
        }
        if (binding instanceof LocalTypeBinding) {
            return true;
        }
        if (binding instanceof MemberTypeBinding) {
            return this.isLocal(((MemberTypeBinding)binding).enclosingType);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void select(ICompilationUnit sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block30: {
            block28: {
                char[] source = sourceUnit.getContents();
                if (DEBUG) {
                    System.out.print("SELECTION IN ");
                    System.out.print(sourceUnit.getFileName());
                    System.out.print(" FROM ");
                    System.out.print(selectionSourceStart);
                    System.out.print(" TO ");
                    System.out.println(selectionSourceEnd);
                    System.out.println("SELECTION - Source :");
                    System.out.println(source);
                }
                if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
                    return;
                }
                try {
                    try {
                        block29: {
                            this.acceptedAnswer = false;
                            CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
                            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(sourceUnit, result, this.actualSelectionStart, this.actualSelectionEnd);
                            if (parsedUnit != null) {
                                if (DEBUG) {
                                    System.out.println("SELECTION - Diet AST :");
                                    System.out.println(parsedUnit.toString());
                                }
                                if (parsedUnit.currentPackage instanceof SelectionOnPackageReference) {
                                    char[][] tokens = ((SelectionOnPackageReference)parsedUnit.currentPackage).tokens;
                                    this.noProposal = false;
                                    this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
                                    Object var12_11 = null;
                                    break block28;
                                }
                                ImportReference[] imports = parsedUnit.imports;
                                if (imports != null) {
                                    int i = 0;
                                    int length = imports.length;
                                    while (i < length) {
                                        ImportReference importReference = imports[i];
                                        if (importReference instanceof SelectionOnImportReference) {
                                            char[][] tokens = ((SelectionOnImportReference)importReference).tokens;
                                            this.noProposal = false;
                                            this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
                                            this.nameEnvironment.findTypes(CharOperation.concatWith(tokens, '.'), this);
                                            if (!this.acceptedAnswer) {
                                                this.acceptQualifiedTypes();
                                                if (!this.acceptedAnswer) {
                                                    this.nameEnvironment.findTypes(this.selectedIdentifier, this);
                                                    if (!this.acceptedAnswer) {
                                                        this.acceptQualifiedTypes();
                                                    }
                                                }
                                            }
                                            if (this.noProposal && this.problem != null) {
                                                this.requestor.acceptError(this.problem);
                                            }
                                            Object var12_12 = null;
                                            this.reset();
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                                if (parsedUnit.types != null) {
                                    this.lookupEnvironment.buildTypeBindings(parsedUnit);
                                    this.unitScope = parsedUnit.scope;
                                    if (this.unitScope != null) {
                                        try {
                                            this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                            parsedUnit.scope.faultInTypes();
                                            this.selectDeclaration(parsedUnit);
                                            ASTNode node = this.parseBlockStatements(parsedUnit, selectionSourceStart);
                                            if (DEBUG) {
                                                System.out.println("SELECTION - AST :");
                                                System.out.println(parsedUnit.toString());
                                            }
                                            parsedUnit.resolve();
                                            if (node != null) {
                                                this.selectLocalDeclaration(node);
                                            }
                                        }
                                        catch (SelectionNodeFound e) {
                                            if (e.binding == null) break block29;
                                            if (DEBUG) {
                                                System.out.println("SELECTION - Selection binding:");
                                                System.out.println(e.binding.toString());
                                            }
                                            this.selectFrom(e.binding, parsedUnit);
                                        }
                                    }
                                }
                            }
                        }
                        if (!this.acceptedAnswer) {
                            this.nameEnvironment.findTypes(this.selectedIdentifier, this);
                            if (!this.acceptedAnswer) {
                                this.acceptQualifiedTypes();
                            }
                        }
                        if (this.noProposal && this.problem != null) {
                            this.requestor.acceptError(this.problem);
                        }
                        break block30;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                    catch (AbortCompilation abortCompilation) {}
                    break block30;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    this.reset();
                    throw throwable;
                }
            }
            this.reset();
            return;
        }
        Object var12_14 = null;
        this.reset();
    }

    private void selectFrom(Binding binding, CompilationUnitDeclaration parsedUnit) {
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding typeBinding = (ReferenceBinding)binding;
            if (this.qualifiedSelection != null && !CharOperation.equals(this.qualifiedSelection, typeBinding.readableName())) {
                return;
            }
            if (typeBinding.isInterface()) {
                this.noProposal = false;
                if (this.isLocal(typeBinding) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalType((SourceTypeBinding)typeBinding, parsedUnit);
                } else {
                    this.requestor.acceptInterface(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false);
                }
            } else if (typeBinding instanceof ProblemReferenceBinding) {
                ReferenceBinding original = ((ProblemReferenceBinding)typeBinding).original;
                if (original == null) {
                    return;
                }
                this.noProposal = false;
                if (this.isLocal(original) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalType((SourceTypeBinding)original, parsedUnit);
                } else {
                    this.requestor.acceptClass(original.qualifiedPackageName(), original.qualifiedSourceName(), false);
                }
            } else {
                this.noProposal = false;
                if (this.isLocal(typeBinding) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalType((SourceTypeBinding)typeBinding, parsedUnit);
                } else {
                    this.requestor.acceptClass(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false);
                }
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)binding;
            TypeBinding[] parameterTypes = methodBinding.parameters;
            int length = parameterTypes.length;
            char[][] parameterPackageNames = new char[length][];
            char[][] parameterTypeNames = new char[length][];
            int i = 0;
            while (i < length) {
                parameterPackageNames[i] = parameterTypes[i].qualifiedPackageName();
                parameterTypeNames[i] = parameterTypes[i].qualifiedSourceName();
                ++i;
            }
            this.noProposal = false;
            ReferenceBinding declaringClass = methodBinding.declaringClass;
            if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                ((SelectionRequestor)this.requestor).acceptLocalMethod((SourceTypeBinding)declaringClass, methodBinding.isConstructor() ? declaringClass.sourceName() : methodBinding.selector, parameterPackageNames, parameterTypeNames, methodBinding.isConstructor(), parsedUnit);
            } else {
                this.requestor.acceptMethod(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), methodBinding.isConstructor() ? declaringClass.sourceName() : methodBinding.selector, parameterPackageNames, parameterTypeNames, methodBinding.isConstructor());
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof FieldBinding) {
            FieldBinding fieldBinding = (FieldBinding)binding;
            ReferenceBinding declaringClass = fieldBinding.declaringClass;
            if (declaringClass != null) {
                this.noProposal = false;
                if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalField((SourceTypeBinding)declaringClass, fieldBinding.name, parsedUnit);
                } else {
                    this.requestor.acceptField(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), fieldBinding.name);
                }
                this.acceptedAnswer = true;
            }
        } else if (binding instanceof LocalVariableBinding) {
            if (this.requestor instanceof SelectionRequestor) {
                ((SelectionRequestor)this.requestor).acceptLocalVariable((LocalVariableBinding)binding, parsedUnit);
                this.acceptedAnswer = true;
            } else {
                this.selectFrom(((LocalVariableBinding)binding).type, parsedUnit);
            }
        } else if (binding instanceof ArrayBinding) {
            this.selectFrom(((ArrayBinding)binding).leafComponentType, parsedUnit);
        } else if (binding instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding;
            this.noProposal = false;
            this.requestor.acceptPackage(packageBinding.readableName());
            this.acceptedAnswer = true;
        } else if (binding instanceof BaseTypeBinding) {
            this.acceptedAnswer = true;
        }
    }

    private void selectLocalDeclaration(ASTNode node) {
        class Visitor
        extends ASTVisitor {
            final /* synthetic */ SelectionEngine this$0;
            private final /* synthetic */ char[] val$assistIdentifier;

            Visitor(SelectionEngine selectionEngine, char[] cArray) {
                this.this$0 = selectionEngine;
                this.val$assistIdentifier = cArray;
            }

            public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
                if (constructorDeclaration.selector == this.val$assistIdentifier) {
                    if (constructorDeclaration.binding != null) {
                        throw new SelectionNodeFound(constructorDeclaration.binding);
                    }
                    if (constructorDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(constructorDeclaration.modifiers, constructorDeclaration.selector, null, null, null, constructorDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
                if (fieldDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(fieldDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
                if (localTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(localTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
                if (memberTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(memberTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
                if (methodDeclaration.selector == this.val$assistIdentifier) {
                    if (methodDeclaration.binding != null) {
                        throw new SelectionNodeFound(methodDeclaration.binding);
                    }
                    if (methodDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(methodDeclaration.modifiers, methodDeclaration.selector, null, null, null, methodDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
                if (typeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(typeDeclaration.binding);
                }
                return true;
            }
        }
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return;
        }
        if (node instanceof AbstractMethodDeclaration) {
            ((AbstractMethodDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), (ClassScope)null);
        } else {
            ((FieldDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectType(ISourceType sourceType, char[] typeName, ISourceType[] topLevelTypes, boolean searchInEnvironment) {
        block20: {
            block19: {
                try {
                    try {
                        block18: {
                            CompilationUnitDeclaration parsedUnit;
                            this.acceptedAnswer = false;
                            ISourceType outerType = sourceType;
                            ISourceType parent = sourceType.getEnclosingType();
                            while (true) {
                                if (parent == null) {
                                    CompilationResult result = new CompilationResult(outerType.getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
                                    parsedUnit = SourceTypeConverter.buildCompilationUnit(topLevelTypes, 8, this.parser.problemReporter(), result);
                                    if (parsedUnit == null || parsedUnit.types == null) break block18;
                                    if (DEBUG) {
                                        System.out.println("SELECTION - Diet AST :");
                                        System.out.println(parsedUnit.toString());
                                    }
                                    if (sourceType instanceof SourceTypeElementInfo) break;
                                    Object var15_10 = null;
                                    break block19;
                                }
                                outerType = parent;
                                parent = parent.getEnclosingType();
                            }
                            IType typeHandle = ((SourceTypeElementInfo)sourceType).getHandle();
                            TypeDeclaration typeDecl = new ASTNodeFinder(parsedUnit).findType(typeHandle);
                            if (typeDecl != null) {
                                FieldDeclaration field = new FieldDeclaration();
                                int dot = CharOperation.lastIndexOf('.', typeName);
                                if (dot == -1) {
                                    this.selectedIdentifier = typeName;
                                    field.type = new SelectionOnSingleTypeReference(typeName, -1L);
                                } else {
                                    char[][] previousIdentifiers = CharOperation.splitOn('.', typeName, 0, dot);
                                    char[] selectionIdentifier = CharOperation.subarray(typeName, dot + 1, typeName.length);
                                    this.selectedIdentifier = selectionIdentifier;
                                    field.type = new SelectionOnQualifiedTypeReference(previousIdentifiers, selectionIdentifier, new long[previousIdentifiers.length + 1]);
                                }
                                field.name = "<fakeField>".toCharArray();
                                typeDecl.fields = new FieldDeclaration[]{field};
                                this.lookupEnvironment.buildTypeBindings(parsedUnit);
                                this.unitScope = parsedUnit.scope;
                                if (this.unitScope != null) {
                                    try {
                                        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                        parsedUnit.scope.faultInTypes();
                                        parsedUnit.resolve();
                                    }
                                    catch (SelectionNodeFound e) {
                                        if (e.binding == null) break block18;
                                        if (DEBUG) {
                                            System.out.println("SELECTION - Selection binding :");
                                            System.out.println(e.binding.toString());
                                        }
                                        this.selectFrom(e.binding, parsedUnit);
                                    }
                                }
                            }
                        }
                        if (!this.acceptedAnswer && searchInEnvironment && this.selectedIdentifier != null) {
                            this.nameEnvironment.findTypes(typeName, this);
                            if (!this.acceptedAnswer) {
                                this.acceptQualifiedTypes();
                            }
                        }
                        if (this.noProposal && this.problem != null) {
                            this.requestor.acceptError(this.problem);
                        }
                        break block20;
                    }
                    catch (AbortCompilation abortCompilation) {}
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var15_11 = null;
                    this.reset();
                    throw throwable;
                }
            }
            this.reset();
            return;
        }
        Object var15_12 = null;
        this.reset();
    }

    private void selectDeclaration(CompilationUnitDeclaration compilationUnit) {
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return;
        }
        TypeDeclaration[] types = compilationUnit.types;
        int i = 0;
        int length = types == null ? 0 : types.length;
        while (i < length) {
            this.selectDeclaration(types[i], assistIdentifier);
            ++i;
        }
    }

    private void selectDeclaration(TypeDeclaration typeDeclaration, char[] assistIdentifier) {
        if (typeDeclaration.name == assistIdentifier) {
            throw new SelectionNodeFound(typeDeclaration.binding);
        }
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int i = 0;
        int length = memberTypes == null ? 0 : memberTypes.length;
        while (i < length) {
            this.selectDeclaration(memberTypes[i], assistIdentifier);
            ++i;
        }
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i2 = 0;
        int length2 = fields == null ? 0 : fields.length;
        while (i2 < length2) {
            if (fields[i2].name == assistIdentifier) {
                throw new SelectionNodeFound(fields[i2].binding);
            }
            ++i2;
        }
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int i3 = 0;
        int length3 = methods == null ? 0 : methods.length;
        while (i3 < length3) {
            AbstractMethodDeclaration method = methods[i3];
            if (method.selector == assistIdentifier) {
                if (method.binding != null) {
                    throw new SelectionNodeFound(method.binding);
                }
                if (method.scope != null) {
                    throw new SelectionNodeFound(new MethodBinding(method.modifiers, method.selector, null, null, null, method.scope.referenceType().binding));
                }
            }
            ++i3;
        }
    }
}

