/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class SingleVariableDeclaration
extends VariableDeclaration {
    private static final int LEGAL_MODIFIERS = 223;
    private int modifiers = 0;
    private SimpleName variableName = null;
    private Type type = null;
    private int extraArrayDimensions = 0;
    private Expression optionalInitializer = null;

    SingleVariableDeclaration(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 44;
    }

    ASTNode clone(AST target) {
        SingleVariableDeclaration result = new SingleVariableDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setModifiers(this.getModifiers());
        result.setType((Type)this.getType().clone(target));
        result.setExtraDimensions(this.getExtraDimensions());
        result.setName((SimpleName)this.getName().clone(target));
        result.setInitializer((Expression)ASTNode.copySubtree(target, this.getInitializer()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getType());
            this.acceptChild(visitor, this.getName());
            this.acceptChild(visitor, this.getInitializer());
        }
        visitor.endVisit(this);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        if ((modifiers & 0xFFFFFF20) != 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.modifiers = modifiers;
    }

    public SimpleName getName() {
        if (this.variableName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.variableName;
    }

    public void setName(SimpleName variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.variableName, variableName, false);
        this.variableName = variableName;
    }

    public Type getType() {
        if (this.type == null) {
            long count = this.getAST().modificationCount();
            this.setType(this.getAST().newPrimitiveType(PrimitiveType.INT));
            this.getAST().setModificationCount(count);
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.type, type, false);
        this.type = type;
    }

    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.extraArrayDimensions = dimensions;
    }

    public Expression getInitializer() {
        return this.optionalInitializer;
    }

    public void setInitializer(Expression initializer) {
        this.replaceChild(this.optionalInitializer, initializer, true);
        this.optionalInitializer = initializer;
    }

    int memSize() {
        return 60;
    }

    int treeSize() {
        return this.memSize() + (this.type == null ? 0 : this.getType().treeSize()) + (this.variableName == null ? 0 : this.getName().treeSize()) + (this.optionalInitializer == null ? 0 : this.getInitializer().treeSize());
    }
}

