/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;

public class CastExpression
extends Expression {
    private Type type = null;
    private Expression expression = null;

    CastExpression(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 11;
    }

    ASTNode clone(AST target) {
        CastExpression result = new CastExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setType((Type)this.getType().clone(target));
        result.setExpression((Expression)this.getExpression().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getType());
            this.acceptChild(visitor, this.getExpression());
        }
        visitor.endVisit(this);
    }

    public Type getType() {
        if (this.type == null) {
            long count = this.getAST().modificationCount();
            this.setType(this.getAST().newPrimitiveType(PrimitiveType.INT));
            this.getAST().setModificationCount(count);
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.type, type, false);
        this.type = type;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.expression, expression, true);
        this.expression = expression;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.type == null ? 0 : this.getType().treeSize());
    }
}

