/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;

public class ArrayType
extends Type {
    private Type componentType = null;

    ArrayType(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 5;
    }

    ASTNode clone(AST target) {
        ArrayType result = new ArrayType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setComponentType((Type)this.getComponentType().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getComponentType());
        }
        visitor.endVisit(this);
    }

    public Type getComponentType() {
        if (this.componentType == null) {
            long count = this.getAST().modificationCount();
            this.setComponentType(new SimpleType(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.componentType;
    }

    public void setComponentType(Type componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.componentType, componentType, true);
        this.componentType = componentType;
    }

    public Type getElementType() {
        Type t = this.getComponentType();
        while (t.isArrayType()) {
            t = ((ArrayType)t).getComponentType();
        }
        return t;
    }

    public int getDimensions() {
        Type t = this.getComponentType();
        int dimensions = 1;
        while (t.isArrayType()) {
            ++dimensions;
            t = ((ArrayType)t).getComponentType();
        }
        return dimensions;
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize() + (this.componentType == null ? 0 : this.getComponentType().treeSize());
    }
}

