/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.ObjectStorePage;
import org.eclipse.core.internal.indexing.PageStore;

class SpaceMapPage
extends ObjectStorePage {
    private static int[] SpaceClassSize;

    static {
        int[] nArray = new int[16];
        nArray[0] = 7616;
        nArray[1] = 6906;
        nArray[2] = 6196;
        nArray[3] = 5486;
        nArray[4] = 4776;
        nArray[5] = 4066;
        nArray[6] = 3356;
        nArray[7] = 2646;
        nArray[8] = 1936;
        nArray[9] = 1226;
        nArray[10] = 516;
        nArray[11] = 258;
        nArray[12] = 129;
        nArray[13] = 64;
        nArray[14] = 32;
        SpaceClassSize = nArray;
    }

    public static int freeSpaceForClass(int spaceClass) {
        return SpaceClassSize[spaceClass];
    }

    public static int[] generateSpaceClassSize() {
        int[] result = new int[16];
        int n = 710;
        int i = 0;
        while (i < 11) {
            result[i] = 7616 - i * n;
            ++i;
        }
        i = 11;
        while (i < 15) {
            result[i] = result[i - 1] / 2;
            ++i;
        }
        result[15] = 0;
        return result;
    }

    public SpaceMapPage(int pageNumber, byte[] buffer, PageStore pageStore) {
        super(pageNumber, buffer, pageStore);
    }

    public void toBuffer(byte[] buffer) {
        int n = Math.min(buffer.length, this.pageBuffer.length());
        System.arraycopy(this.pageBuffer.getByteArray(), 0, buffer, 0, n);
    }

    public int getFreeSpace(int pageNumber) {
        int slot = pageNumber - this.pageNumber;
        if (slot < 1 || slot >= 8192) {
            return 0;
        }
        byte spaceClass = this.pageBuffer.getByte(slot);
        int freeSpace = SpaceMapPage.freeSpaceForClass(spaceClass);
        return freeSpace;
    }

    public void setFreeSpace(int pageNumber, int freeSpace) {
        int slot = pageNumber - this.pageNumber;
        if (slot < 1 || slot >= 8192) {
            return;
        }
        byte spaceClass = 0;
        while (SpaceClassSize[spaceClass] > freeSpace) {
            spaceClass = (byte)(spaceClass + 1);
        }
        this.pageBuffer.put(slot, spaceClass);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isSpaceMapPage() {
        return true;
    }

    protected void materialize() {
    }
}

