/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.aspectj.asm.IHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.IHasSourceLocation;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class World {
    protected IMessageHandler messageHandler = IMessageHandler.SYSTEM_ERR;
    protected ICrossReferenceHandler xrefHandler = null;
    protected TypeMap typeMap = new TypeMap();
    protected CrosscuttingMembersSet crosscuttingMembersSet = new CrosscuttingMembersSet(this);
    protected IHierarchy model = null;
    protected Lint lint = new Lint(this);
    protected boolean XnoInline;
    protected boolean XlazyTjp;
    public static final World EMPTY = new World(){

        public List getShadowMungers() {
            return Collections.EMPTY_LIST;
        }

        public ResolvedTypeX.ConcreteName resolveObjectType(ResolvedTypeX.Name ty) {
            return null;
        }

        public Advice concreteAdvice(AjAttribute.AdviceAttribute attribute, Pointcut p, Member m) {
            throw new RuntimeException("unimplemented");
        }

        public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedTypeX aspectType) {
            throw new RuntimeException("unimplemented");
        }
    };

    protected World() {
        this.typeMap.put("B", ResolvedTypeX.BYTE);
        this.typeMap.put("S", ResolvedTypeX.SHORT);
        this.typeMap.put("I", ResolvedTypeX.INT);
        this.typeMap.put("J", ResolvedTypeX.LONG);
        this.typeMap.put("F", ResolvedTypeX.FLOAT);
        this.typeMap.put("D", ResolvedTypeX.DOUBLE);
        this.typeMap.put("C", ResolvedTypeX.CHAR);
        this.typeMap.put("Z", ResolvedTypeX.BOOLEAN);
        this.typeMap.put("V", ResolvedTypeX.VOID);
    }

    public ResolvedTypeX[] resolve(TypeX[] types) {
        int len = types.length;
        ResolvedTypeX[] ret = new ResolvedTypeX[len];
        int i = 0;
        while (i < len) {
            ret[i] = this.resolve(types[i]);
            ++i;
        }
        return ret;
    }

    public ResolvedTypeX resolve(TypeX ty) {
        return this.resolve(ty, false);
    }

    public ResolvedTypeX resolve(TypeX ty, boolean allowMissing) {
        String signature = ty.getSignature();
        ResolvedTypeX ret = this.typeMap.get(signature);
        if (ret != null) {
            return ret;
        }
        if (ty.isArray()) {
            ret = new ResolvedTypeX.Array(signature, this, this.resolve(ty.getComponentType(), allowMissing));
        } else {
            ret = this.resolveObjectType(ty);
            if (!allowMissing && ret == ResolvedTypeX.MISSING) {
                MessageUtil.error(this.messageHandler, "can't find type " + ty.getName());
            }
        }
        this.typeMap.put(signature, ret);
        return ret;
    }

    public ResolvedTypeX resolve(String name) {
        return this.resolve(TypeX.forName(name));
    }

    protected final ResolvedTypeX resolveObjectType(TypeX ty) {
        ResolvedTypeX.Name name = new ResolvedTypeX.Name(ty.getSignature(), this);
        ResolvedTypeX.ConcreteName concreteName = this.resolveObjectType(name);
        if (concreteName == null) {
            return ResolvedTypeX.MISSING;
        }
        name.setDelegate(concreteName);
        return name;
    }

    protected abstract ResolvedTypeX.ConcreteName resolveObjectType(ResolvedTypeX.Name var1);

    protected final boolean isCoerceableFrom(TypeX type, TypeX other) {
        return this.resolve(type).isCoerceableFrom(other);
    }

    protected final boolean isAssignableFrom(TypeX type, TypeX other) {
        return this.resolve(type).isAssignableFrom(other);
    }

    public boolean needsNoConversionFrom(TypeX type, TypeX other) {
        return this.resolve(type).needsNoConversionFrom(other);
    }

    protected final boolean isInterface(TypeX type) {
        return this.resolve(type).isInterface();
    }

    protected final ResolvedTypeX getSuperclass(TypeX type) {
        return this.resolve(type).getSuperclass();
    }

    protected final TypeX[] getDeclaredInterfaces(TypeX type) {
        return this.resolve(type).getDeclaredInterfaces();
    }

    protected final int getModifiers(TypeX type) {
        return this.resolve(type).getModifiers();
    }

    protected final ResolvedMember[] getDeclaredFields(TypeX type) {
        return this.resolve(type).getDeclaredFields();
    }

    protected final ResolvedMember[] getDeclaredMethods(TypeX type) {
        return this.resolve(type).getDeclaredMethods();
    }

    protected final ResolvedMember[] getDeclaredPointcuts(TypeX type) {
        return this.resolve(type).getDeclaredPointcuts();
    }

    public ResolvedMember resolve(Member member) {
        ResolvedTypeX declaring = member.getDeclaringType().resolve(this);
        ResolvedMember ret = member.getKind() == Member.FIELD ? declaring.lookupField(member) : declaring.lookupMethod(member);
        if (ret != null) {
            return ret;
        }
        return declaring.lookupSyntheticMember(member);
    }

    protected int getModifiers(Member member) {
        ResolvedMember r = this.resolve(member);
        if (r == null) {
            throw new BCException("bad resolve of " + member);
        }
        return r.getModifiers();
    }

    protected String[] getParameterNames(Member member) {
        return this.resolve(member).getParameterNames();
    }

    protected TypeX[] getExceptions(Member member) {
        return this.resolve(member).getExceptions();
    }

    public ResolvedPointcutDefinition findPointcut(TypeX typeX, String name) {
        throw new RuntimeException("not implemented yet");
    }

    public abstract Advice concreteAdvice(AjAttribute.AdviceAttribute var1, Pointcut var2, Member var3);

    public final Advice concreteAdvice(AdviceKind kind, Pointcut p, Member signature, int extraParameterFlags, IHasSourceLocation loc) {
        AjAttribute.AdviceAttribute attribute = new AjAttribute.AdviceAttribute(kind, p, extraParameterFlags, loc.getStart(), loc.getEnd(), loc.getSourceContext());
        return this.concreteAdvice(attribute, p, signature);
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        throw new RuntimeException("unimplemented");
    }

    public abstract ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger var1, ResolvedTypeX var2);

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(IMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setXRefHandler(ICrossReferenceHandler xrefHandler) {
        this.xrefHandler = xrefHandler;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        if (loc1 != null) {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc1));
            if (loc2 != null) {
                this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
            }
        } else {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
        }
    }

    public int compareByDominates(ResolvedTypeX aspect1, ResolvedTypeX aspect2) {
        int order = 0;
        Iterator i = this.crosscuttingMembersSet.getDeclareDominates().iterator();
        while (i.hasNext()) {
            DeclarePrecedence d = (DeclarePrecedence)i.next();
            int thisOrder = d.compare(aspect1, aspect2);
            if (thisOrder == 0) continue;
            if (order != 0 && order != thisOrder) {
                throw new BCException("conflicting dominates orders");
            }
            order = thisOrder;
        }
        return order;
    }

    public int comparePrecedence(ResolvedTypeX aspect1, ResolvedTypeX aspect2) {
        if (aspect1.equals(aspect2)) {
            return 0;
        }
        int ret = this.compareByDominates(aspect1, aspect2);
        if (ret != 0) {
            return ret;
        }
        if (aspect1.isAssignableFrom(aspect2)) {
            return -1;
        }
        if (aspect2.isAssignableFrom(aspect1)) {
            return 1;
        }
        return 0;
    }

    public List getDeclareParents() {
        return this.crosscuttingMembersSet.getDeclareParents();
    }

    public List getDeclareSoft() {
        return this.crosscuttingMembersSet.getDeclareSofts();
    }

    public CrosscuttingMembersSet getCrosscuttingMembersSet() {
        return this.crosscuttingMembersSet;
    }

    public IHierarchy getModel() {
        return this.model;
    }

    public void setModel(IHierarchy model) {
        this.model = model;
    }

    public Lint getLint() {
        return this.lint;
    }

    public void setLint(Lint lint) {
        this.lint = lint;
    }

    public boolean isXnoInline() {
        return this.XnoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.XnoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.XlazyTjp;
    }

    public void setXlazyTjp(boolean b) {
        this.XlazyTjp = b;
    }

    public ResolvedTypeX.Name lookupOrCreateName(TypeX ty) {
        String signature = ty.getSignature();
        ResolvedTypeX.Name ret = (ResolvedTypeX.Name)this.typeMap.get(signature);
        if (ret == null) {
            ret = new ResolvedTypeX.Name(signature, this);
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    protected static class TypeMap {
        private Map tMap = new HashMap();
        private Map expendableMap = new WeakHashMap();

        protected TypeMap() {
        }

        public ResolvedTypeX put(String key, ResolvedTypeX type) {
            if (this.isExpendable(type)) {
                return this.expendableMap.put(key, type);
            }
            return this.tMap.put(key, type);
        }

        public ResolvedTypeX get(String key) {
            ResolvedTypeX ret = (ResolvedTypeX)this.tMap.get(key);
            if (ret == null) {
                ret = (ResolvedTypeX)this.expendableMap.get(key);
            }
            return ret;
        }

        public ResolvedTypeX remove(String key) {
            ResolvedTypeX ret = (ResolvedTypeX)this.tMap.remove(key);
            if (ret == null) {
                ret = (ResolvedTypeX)this.expendableMap.remove(key);
            }
            return ret;
        }

        private boolean isExpendable(ResolvedTypeX type) {
            return type != null && !type.isExposedToWeaver() && !type.isPrimitive();
        }
    }
}

