// Code generated by 'ccgo -lmodernc.org/z/lib -o internal/minigzip_freebsd_arm.go -trace-translation-units /home/jnml/tmpdir/go-generate-478397193/cdb.json minigzip64', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int32 /* <builtin>:3:26 */

type size_t = uint32 /* <builtin>:9:23 */

type wchar_t = uint32 /* <builtin>:15:24 */

type rune_t = int32 /* stddef.h:50:18 */

type max_align_t = struct {
	__max_align1 int64
	__max_align2 float64
} /* stddef.h:69:23 */

// ISO/IEC 9899:2011 K.3.3.2
type rsize_t = size_t /* stddef.h:81:16 */

type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint32 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = uint8  /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)limits.h	8.2 (Berkeley) 1/4/94
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)limits.h	8.3 (Berkeley) 1/4/94
// $FreeBSD$

// According to ANSI (section 2.2.4.2), the values below must be usable by
// #if preprocessing directives.  Additionally, the expression must have the
// same type as would an expression that is an object of the corresponding
// type converted according to the integral promotions.  The subtraction for
// INT_MIN, etc., is so the value is not unsigned; e.g., 0x80000000 is an
// unsigned int for 32-bit two's complement ANSI compilers (section 3.1.3.2).

// max value for an unsigned long long

// Quads and long longs are the same size.  Ensure they stay in sync.

// Minimum signal stack size.

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)syslimits.h	8.1 (Berkeley) 6/2/93
// $FreeBSD$

// Do not add any new variables here.  (See the comment at the end of
// the file for why.)

// We leave the following values undefined to force applications to either
// assume conservative values or call sysconf() to get the current value.
//
// HOST_NAME_MAX
//
// (We should do this for most of the values currently defined here,
// but many programs are not prepared to deal with this yet.)

type z_crc_t = uint32 /* zconf.h:429:17 */
type pthread_once = struct {
	state int32
	mutex pthread_mutex_t
} /* _pthreadtypes.h:52:1 */

// Primitive system data type definitions required by P1003.1c.
//
// Note that P1003.1c specifies that there are no defined comparison
// or assignment operators for the types pthread_attr_t, pthread_cond_t,
// pthread_condattr_t, pthread_mutex_t, pthread_mutexattr_t.
type pthread_t = uintptr             /* _pthreadtypes.h:67:26 */
type pthread_attr_t = uintptr        /* _pthreadtypes.h:70:30 */
type pthread_mutex_t = uintptr       /* _pthreadtypes.h:71:31 */
type pthread_mutexattr_t = uintptr   /* _pthreadtypes.h:72:35 */
type pthread_cond_t = uintptr        /* _pthreadtypes.h:73:30 */
type pthread_condattr_t = uintptr    /* _pthreadtypes.h:74:34 */
type pthread_key_t = int32           /* _pthreadtypes.h:75:20 */
type pthread_once_t = pthread_once   /* _pthreadtypes.h:76:30 */
type pthread_rwlock_t = uintptr      /* _pthreadtypes.h:77:32 */
type pthread_rwlockattr_t = uintptr  /* _pthreadtypes.h:78:35 */
type pthread_barrier_t = uintptr     /* _pthreadtypes.h:79:33 */
type pthread_barrierattr_t = uintptr /* _pthreadtypes.h:80:36 */
type pthread_spinlock_t = uintptr    /* _pthreadtypes.h:81:33 */

// Additional type definitions:
//
// Note that P1003.1c reserves the prefixes pthread_ and PTHREAD_ for
// use in header symbols.
type pthread_addr_t = uintptr         /* _pthreadtypes.h:89:14 */
type pthread_startroutine_t = uintptr /* _pthreadtypes.h:90:14 */

type u_char = uint8   /* types.h:52:23 */
type u_short = uint16 /* types.h:53:24 */
type u_int = uint32   /* types.h:54:22 */
type u_long = uint32  /* types.h:55:23 */
type ushort = uint16  /* types.h:57:24 */ // Sys V compatibility
type uint = uint32    /* types.h:58:22 */ // Sys V compatibility

// XXX POSIX sized integrals that should appear only in <sys/stdint.h>.
// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2011 David E. O'Brien <obrien@FreeBSD.org>
// Copyright (c) 2001 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type int8_t = int8 /* _stdint.h:36:19 */

type int16_t = int16 /* _stdint.h:41:20 */

type int32_t = int32 /* _stdint.h:46:20 */

type int64_t = int64 /* _stdint.h:51:20 */

type uint8_t = uint8 /* _stdint.h:56:20 */

type uint16_t = uint16 /* _stdint.h:61:21 */

type uint32_t = uint32 /* _stdint.h:66:21 */

type uint64_t = uint64 /* _stdint.h:71:21 */

type intptr_t = int32   /* _stdint.h:76:21 */
type uintptr_t = uint32 /* _stdint.h:80:22 */
type intmax_t = int64   /* _stdint.h:84:21 */
type uintmax_t = uint64 /* _stdint.h:88:22 */

type u_int8_t = uint8   /* types.h:67:19 */ // unsigned integrals (deprecated)
type u_int16_t = uint16 /* types.h:68:20 */
type u_int32_t = uint32 /* types.h:69:20 */
type u_int64_t = uint64 /* types.h:70:20 */

type u_quad_t = uint64 /* types.h:72:20 */ // quads (deprecated)
type quad_t = int64    /* types.h:73:19 */
type qaddr_t = uintptr /* types.h:74:16 */

type caddr_t = uintptr   /* types.h:76:14 */ // core address
type c_caddr_t = uintptr /* types.h:77:20 */ // core address, pointer to const

type blksize_t = int32 /* types.h:80:21 */

type cpuwhich_t = int32 /* types.h:84:22 */
type cpulevel_t = int32 /* types.h:85:22 */
type cpusetid_t = int32 /* types.h:86:22 */

type blkcnt_t = int64 /* types.h:89:20 */

type clock_t = uint32 /* types.h:94:19 */

type clockid_t = int32 /* types.h:99:21 */

type critical_t = int32 /* types.h:103:22 */ // Critical section value
type daddr_t = int64    /* types.h:104:19 */ // disk address

type dev_t = uint64 /* types.h:107:18 */ // device number or struct cdev

type fflags_t = uint32 /* types.h:112:20 */ // file flags

type fixpt_t = uint32 /* types.h:116:19 */ // fixed point number

type fsblkcnt_t = uint64 /* types.h:119:22 */
type fsfilcnt_t = uint64 /* types.h:120:22 */

type gid_t = uint32 /* types.h:125:18 */ // group id

type in_addr_t = uint32 /* types.h:130:20 */ // base type for internet address

type in_port_t = uint16 /* types.h:135:20 */

type id_t = int64 /* types.h:140:17 */ // can hold a uid_t or pid_t

type ino_t = uint64 /* types.h:145:18 */ // inode number

type key_t = int32 /* types.h:150:18 */ // IPC key (for Sys V IPC)

type lwpid_t = int32 /* types.h:155:19 */ // Thread ID (a.k.a. LWP)

type mode_t = uint16 /* types.h:160:18 */ // permissions

type accmode_t = int32 /* types.h:165:21 */ // access permissions

type nlink_t = uint64 /* types.h:170:19 */ // link count

type off_t = int64 /* types.h:175:18 */ // file offset

type off64_t = int64 /* types.h:180:19 */ // file offset (alias)

type pid_t = int32 /* types.h:185:18 */ // process id

type register_t = int32 /* types.h:189:22 */

type rlim_t = int64 /* types.h:192:18 */ // resource limit

type sbintime_t = int64 /* types.h:196:19 */

type segsz_t = int32 /* types.h:198:19 */ // segment size (in pages)

type ssize_t = int32 /* types.h:206:19 */

type suseconds_t = int32 /* types.h:211:23 */ // microseconds (signed)

type time_t = int64 /* types.h:216:18 */

type timer_t = uintptr /* types.h:221:19 */

type mqd_t = uintptr /* types.h:226:17 */

type u_register_t = uint32 /* types.h:230:24 */

type uid_t = uint32 /* types.h:233:18 */ // user id

type useconds_t = uint32 /* types.h:238:22 */ // microseconds (unsigned)

type cap_ioctl_t = uint32 /* types.h:244:23 */

// Types suitable for exporting physical addresses, virtual addresses
// (pointers), and memory object sizes from the kernel independent of native
// word size.  These should be used in place of vm_paddr_t, (u)intptr_t, and
// size_t in structs which contain such types that are shared with userspace.
type kpaddr_t = uint64 /* types.h:260:20 */
type kvaddr_t = uint64 /* types.h:261:20 */
type ksize_t = uint64  /* types.h:262:20 */
type kssize_t = int64  /* types.h:263:19 */

type vm_offset_t = uint32  /* types.h:265:23 */
type vm_ooffset_t = uint64 /* types.h:266:20 */
type vm_paddr_t = uint32   /* types.h:267:22 */
type vm_pindex_t = uint64  /* types.h:268:20 */
type vm_size_t = uint32    /* types.h:269:21 */

type rman_res_t = uint64 /* types.h:271:25 */

func __bitcount32(tls *libc.TLS, _x uint32) uint32 { /* types.h:335:1: */

	_x = _x&uint32(0x55555555) + _x&0xaaaaaaaa>>1
	_x = _x&uint32(0x33333333) + _x&0xcccccccc>>2
	_x = (_x + _x>>4) & uint32(0x0f0f0f0f)
	_x = _x + _x>>8
	_x = (_x + _x>>16) & uint32(0x000000ff)
	return _x
}

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1992, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95
// $FreeBSD$

// sigset_t macros.

type __sigset = struct{ __bits [4]uint32 } /* _sigset.h:53:9 */

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// Structure returned by gettimeofday(2) system call, and used in other calls.
type timeval = struct {
	tv_sec  time_t
	tv_usec suseconds_t
	_       [4]byte
} /* _timeval.h:49:1 */

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95
// from: FreeBSD: src/sys/sys/time.h,v 1.43 2000/03/20 14:09:05 phk Exp
//	$FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95
// from: FreeBSD: src/sys/sys/time.h,v 1.43 2000/03/20 14:09:05 phk Exp
//	$FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	_       [4]byte
} /* _timespec.h:46:1 */

// Structure defined by POSIX.1b to be like a itimerval, but with
// timespecs. Used in the timer_*() system calls.
type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
} /* timespec.h:60:1 */

type fd_mask = uint32 /* select.h:46:19 */

type sigset_t = __sigset /* select.h:51:20 */

// Select uses bit masks of file descriptors in longs.  These macros
// manipulate such bit fields (the filesystem macros use chars).
// FD_SETSIZE may be defined by the user, but the default here should
// be enough for most uses.

type fd_set1 = struct{ __fds_bits [32]uint32 } /* select.h:73:9 */

// Select uses bit masks of file descriptors in longs.  These macros
// manipulate such bit fields (the filesystem macros use chars).
// FD_SETSIZE may be defined by the user, but the default here should
// be enough for most uses.

type fd_set = fd_set1 /* select.h:75:3 */

// -
// SPDX-License-Identifier: BSD-2-Clause
//
// Copyright (c) 2017 Poul-Henning Kamp.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 2002 David E. O'Brien.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type va_list = uintptr /* _stdarg.h:41:27 */ // select(2)

type crypt_data = struct {
	initialized int32
	__buf       [256]uint8
} /* unistd.h:489:1 */

// getopt(3) external variable

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	adler     uLong
	reserved  uLong
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	next uintptr
	pos  off_t
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Chris Torek.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdio.h	8.5 (Berkeley) 4/29/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2003 Marcel Moolenaar
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type fpos_t = int64 /* stdio.h:47:18 */

// NB: to fit things in six character monocase externals, the stdio
// code uses the prefix `__s' for stdio objects, typically followed
// by a three-character attempt at a mnemonic.

// stdio buffers
type __sbuf = struct {
	_base uintptr
	_size int32
} /* stdio.h:91:1 */

// stdio state variables.
//
// The following always hold:
//
//	if (_flags&(__SLBF|__SWR)) == (__SLBF|__SWR),
//		_lbfsize is -_bf._size, else _lbfsize is 0
//	if _flags&__SRD, _w is 0
//	if _flags&__SWR, _r is 0
//
// This ensures that the getc and putc macros (or inline functions) never
// try to write or read from a file that is in `read' or `write' mode.
// (Moreover, they can, and do, automatically switch from read mode to
// write mode, and back, on "r+" and "w+" files.)
//
// _lbfsize is used only to make the inline line-buffered output stream
// code as compact as possible.
//
// _ub, _up, and _ur are used when ungetc() pushes back more characters
// than fit in the current _bf, or when ungetc() pushes back a character
// that does not match the previous one in _bf.  When this happens,
// _ub._base becomes non-nil (i.e., a stream has ungetc() data iff
// _ub._base!=NULL) and _up and _ur save the current values of _p and _r.
//
// Certain members of __sFILE are accessed directly via macros or
// inline functions.  To preserve ABI compat, these members must not
// be disturbed.  These members are marked below with (*).
type __sFILE = struct {
	_p     uintptr
	_r     int32
	_w     int32
	_flags int16
	_file  int16
	_bf    struct {
		_base uintptr
		_size int32
	}
	_lbfsize int32
	_cookie  uintptr
	_close   uintptr
	_read    uintptr
	_seek    uintptr
	_write   uintptr
	_ub      struct {
		_base uintptr
		_size int32
	}
	_up   uintptr
	_ur   int32
	_ubuf [3]uint8
	_nbuf [1]uint8
	_lb   struct {
		_base uintptr
		_size int32
	}
	_blksize     int32
	_offset      fpos_t
	_fl_mutex    uintptr
	_fl_owner    uintptr
	_fl_count    int32
	_orientation int32
	_mbstate     struct {
		_          [0]uint64
		__mbstate8 [128]uint8
	}
	_flags2 int32
	_       [4]byte
} /* stdio.h:124:1 */

type FILE = __sFILE /* stdio.h:165:24 */
type cookie_io_functions_t = struct {
	read  uintptr
	write uintptr
	seek  uintptr
	close uintptr
} /* stdio.h:428:3 */

// -
// Copyright (c) 2011, 2012 The FreeBSD Foundation
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type locale_t = uintptr /* _strings.h:30:25 */

// xlocale extensions

type errno_t = int32 /* string.h:159:13 */

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1990, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stdlib.h	8.5 (Berkeley) 5/19/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2003 Marcel Moolenaar
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// $FreeBSD$

// -
// SPDX-License-Identifier: BSD-2-Clause-FreeBSD
//
// Copyright (c) 2002 Mike Barcroft <mike@FreeBSD.org>
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// $FreeBSD$

type div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:66:3 */

type ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:71:3 */

// Functions added in C99 which we make conditionally available in the
// BSD^C89 namespace if the compiler supports `long long'.
// The #if test is more complicated than it ought to be because
// __BSD_VISIBLE implies __ISO_C_VISIBLE == 1999 *even if* `long long'
// is not supported in the compilation environment (which therefore means
// that it can't really be ISO C99).
//
// (The only other extension made by C99 in thie header is _Exit().)
// LONGLONG
type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:142:3 */ // getsubopt(3) external variable

// K.3.6
type constraint_handler_t = uintptr /* stdlib.h:349:14 */

var prog uintptr /* minigzip.c:336:13: */

// ===========================================================================
// Display error message and exit
func error(tls *libc.TLS, msg uintptr) { /* minigzip.c:351:6: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.Xfprintf(tls, libc.X__stderrp, ts, libc.VaList(bp, prog, msg))
	libc.Xexit(tls, 1)
}

// ===========================================================================
// Compress input to output then close both files.

func gz_compress(tls *libc.TLS, in uintptr, out gzFile) { /* minigzip.c:362:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]uint8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = int32(libc.Xfread(tls, bp, uint32(1), uint32(unsafe.Sizeof([16384]uint8{})), in))
		if func() int32 {
			if !(libc.X__isthreaded != 0) {
				return libc.Bool32(int32((*FILE)(unsafe.Pointer(in))._flags)&0x0040 != 0)
			}
			return libc.Xferror(tls, in)
		}() != 0 {
			libc.Xperror(tls, ts+8)
			libc.Xexit(tls, 1)
		}
		if len == 0 {
			break
		}

		if z.Xgzwrite(tls, out, bp, uint32(len)) != len {
			error(tls, z.Xgzerror(tls, out, bp+16384))
		}
	}
	libc.Xfclose(tls, in)
	if z.Xgzclose(tls, out) != 0 {
		error(tls, ts+14)
	}
}

// ===========================================================================
// Uncompress input to output then close both files.
func gz_uncompress(tls *libc.TLS, in gzFile, out uintptr) { /* minigzip.c:430:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]uint8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = z.Xgzread(tls, in, bp, uint32(unsafe.Sizeof([16384]uint8{})))
		if len < 0 {
			error(tls, z.Xgzerror(tls, in, bp+16384))
		}
		if len == 0 {
			break
		}

		if int32(libc.Xfwrite(tls, bp, uint32(1), uint32(len), out)) != len {
			error(tls, ts+29)
		}
	}
	if libc.Xfclose(tls, out) != 0 {
		error(tls, ts+43)
	}

	if z.Xgzclose(tls, in) != 0 {
		error(tls, ts+14)
	}
}

// ===========================================================================
// Compress the given file: create a corresponding .gz file and remove the
// original.
func file_compress(tls *libc.TLS, file uintptr, mode uintptr) { /* minigzip.c:457:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var outfile [1024]uint8 at bp+40, 1024

	var in uintptr
	var out gzFile

	if libc.Xstrlen(tls, file)+libc.Xstrlen(tls, ts+57) >= size_t(unsafe.Sizeof([1024]uint8{})) {
		libc.Xfprintf(tls, libc.X__stderrp, ts+61, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	libc.Xsnprintf(tls, bp+40, uint32(unsafe.Sizeof([1024]uint8{})), ts+84, libc.VaList(bp+8, file, ts+57))

	in = libc.Xfopen(tls, file, ts+89)
	if in == uintptr(0) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}
	out = z.Xgzopen(tls, bp+40, mode)
	if out == uintptr(0) {
		libc.Xfprintf(tls, libc.X__stderrp, ts+92, libc.VaList(bp+24, prog, bp+40))
		libc.Xexit(tls, 1)
	}
	gz_compress(tls, in, out)

	libc.Xunlink(tls, file)
}

// ===========================================================================
// Uncompress the given file and remove the original.
func file_uncompress(tls *libc.TLS, file uintptr) { /* minigzip.c:496:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var buf [1024]uint8 at bp+40, 1024

	var infile uintptr
	var outfile uintptr
	var out uintptr
	var in gzFile
	var len uint32 = libc.Xstrlen(tls, file)

	if len+libc.Xstrlen(tls, ts+57) >= uint32(unsafe.Sizeof([1024]uint8{})) {
		libc.Xfprintf(tls, libc.X__stderrp, ts+61, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	libc.Xsnprintf(tls, bp+40, uint32(unsafe.Sizeof([1024]uint8{})), ts+113, libc.VaList(bp+8, file))

	if len > uint32(unsafe.Sizeof([4]uint8{}))-uint32(1) && libc.Xstrcmp(tls, file+uintptr(len)-uintptr(uint32(unsafe.Sizeof([4]uint8{}))-uint32(1)), ts+57) == 0 {
		infile = file
		outfile = bp + 40 /* &buf[0] */
		*(*uint8)(unsafe.Pointer(outfile + uintptr(len-uint32(3)))) = uint8(0)
	} else {
		outfile = file
		infile = bp + 40 /* &buf[0] */
		libc.Xsnprintf(tls, bp+40+uintptr(len), uint32(unsafe.Sizeof([1024]uint8{}))-len, ts+113, libc.VaList(bp+16, ts+57 /* ".gz" */))
	}
	in = z.Xgzopen(tls, infile, ts+89)
	if in == uintptr(0) {
		libc.Xfprintf(tls, libc.X__stderrp, ts+92, libc.VaList(bp+24, prog, infile))
		libc.Xexit(tls, 1)
	}
	out = libc.Xfopen(tls, outfile, ts+116)
	if out == uintptr(0) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}

	gz_uncompress(tls, in, out)

	libc.Xunlink(tls, infile)
}

// ===========================================================================
// Usage:  minigzip [-c] [-d] [-f] [-h] [-r] [-1 to -9] [files...]
//   -c : write to standard output
//   -d : decompress
//   -f : compress with Z_FILTERED
//   -h : compress with Z_HUFFMAN_ONLY
//   -r : compress with Z_RLE
//   -1 to -9 : compression level

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* minigzip.c:556:5: */
	bp := tls.Alloc(44)
	defer tls.Free(44)

	var copyout int32 = 0
	var uncompr int32 = 0
	var file gzFile
	var bname uintptr
	// var outmode [20]uint8 at bp+24, 20

	libc.Xsnprintf(tls, bp+24, uint32(unsafe.Sizeof([20]uint8{})), ts+113, libc.VaList(bp, ts+119))

	prog = *(*uintptr)(unsafe.Pointer(argv))
	bname = libc.Xstrrchr(tls, *(*uintptr)(unsafe.Pointer(argv)), '/')
	if bname != 0 {
		bname++
	} else {
		bname = *(*uintptr)(unsafe.Pointer(argv))
	}
	argc--
	argv += 4

	if !(libc.Xstrcmp(tls, bname, ts+124) != 0) {
		uncompr = 1
	} else if !(libc.Xstrcmp(tls, bname, ts+131) != 0) {
		copyout = libc.AssignInt32(&uncompr, 1)
	}

	for argc > 0 {
		if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+136) == 0 {
			copyout = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+139) == 0 {
			uncompr = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+142) == 0 {
			*(*uint8)(unsafe.Pointer(bp + 24 + 3)) = uint8('f')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+145) == 0 {
			*(*uint8)(unsafe.Pointer(bp + 24 + 3)) = uint8('h')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+148) == 0 {
			*(*uint8)(unsafe.Pointer(bp + 24 + 3)) = uint8('R')
		} else if int32(*(*uint8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv))))) == '-' && int32(*(*uint8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))) >= '1' && int32(*(*uint8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))) <= '9' && int32(*(*uint8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 2))) == 0 {
			*(*uint8)(unsafe.Pointer(bp + 24 + 2)) = *(*uint8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))
		} else {
			break
		}
		argc--
		argv += 4
	}
	if int32(*(*uint8)(unsafe.Pointer(bp + 24 + 3))) == ' ' {
		*(*uint8)(unsafe.Pointer(bp + 24 + 3)) = uint8(0)
	}
	if argc == 0 {

		if uncompr != 0 {
			file = z.Xgzdopen(tls, func() int32 {
				if !(libc.X__isthreaded != 0) {
					return int32((*FILE)(unsafe.Pointer(libc.X__stdinp))._file)
				}
				return libc.Xfileno(tls, libc.X__stdinp)
			}(), ts+89)
			if file == uintptr(0) {
				error(tls, ts+151)
			}
			gz_uncompress(tls, file, libc.X__stdoutp)
		} else {
			file = z.Xgzdopen(tls, func() int32 {
				if !(libc.X__isthreaded != 0) {
					return int32((*FILE)(unsafe.Pointer(libc.X__stdoutp))._file)
				}
				return libc.Xfileno(tls, libc.X__stdoutp)
			}(), bp+24)
			if file == uintptr(0) {
				error(tls, ts+171)
			}
			gz_compress(tls, libc.X__stdinp, file)
		}
	} else {
		if copyout != 0 {

		}
		for __ccgo := true; __ccgo; __ccgo = func() bool { argv += 4; return libc.PreDecInt32(&argc, 1) != 0 }() {
			if uncompr != 0 {
				if copyout != 0 {
					file = z.Xgzopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89)
					if file == uintptr(0) {
						libc.Xfprintf(tls, libc.X__stderrp, ts+92, libc.VaList(bp+8, prog, *(*uintptr)(unsafe.Pointer(argv))))
					} else {
						gz_uncompress(tls, file, libc.X__stdoutp)
					}
				} else {
					file_uncompress(tls, *(*uintptr)(unsafe.Pointer(argv)))
				}
			} else {
				if copyout != 0 {
					var in uintptr = libc.Xfopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89)

					if in == uintptr(0) {
						libc.Xperror(tls, *(*uintptr)(unsafe.Pointer(argv)))
					} else {
						file = z.Xgzdopen(tls, func() int32 {
							if !(libc.X__isthreaded != 0) {
								return int32((*FILE)(unsafe.Pointer(libc.X__stdoutp))._file)
							}
							return libc.Xfileno(tls, libc.X__stdoutp)
						}(), bp+24)
						if file == uintptr(0) {
							error(tls, ts+171)
						}

						gz_compress(tls, in, file)
					}

				} else {
					file_compress(tls, *(*uintptr)(unsafe.Pointer(argv)), bp+24)
				}
			}
		}
	}
	return 0
}

var ts1 = "%s: %s\n\x00fread\x00failed gzclose\x00failed fwrite\x00failed fclose\x00.gz\x00%s: filename too long\n\x00%s%s\x00rb\x00%s: can't gzopen %s\n\x00%s\x00wb\x00wb6 \x00gunzip\x00zcat\x00-c\x00-d\x00-f\x00-h\x00-r\x00can't gzdopen stdin\x00can't gzdopen stdout\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
