/**
 * @file extra.h Zip extra-field  utility functions and structures
 * 
 * $Id: extra.h,v 1.2 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _MOD_EXTRA_H_
#define _MOD_EXTRA_H_

/*Extra Header defines */
#define ZIP_AV_EXTRA		     0x0007
#define ZIP_OS2_EXTRA		     0x0009
#define ZIP_NTFS_EXTRA		     0x000a
#define ZIP_OPENVMS_EXTRA	     0x000c
#define ZIP_PKWARE_UNIX_EXTRA	     0x000d
#define ZIP_PATCH_EXTRA	             0x000f
#define ZIP_X509_EXTRA	             0x0014
#define ZIP_X509_FILE		     0x0015
#define ZIP_X509_CD		     0x0016

#define ZIP_TSTAMP_EXTRA             0x5455
#define ZIP_UNIX1_IZ_EXTRA           0x5855
#define ZIP_UNIX2_IZ_EXTRA           0x7855

/* Extra Field structures */
typedef struct 
{
	void *data;
	unsigned short length;
	char *field;
} ZipExtra;

/* Specific Extra Field structure */
typedef struct
{
	unsigned int   atime;   /* last access time of the file */
	unsigned int   mtime;   /* list modified time of the file */
	unsigned int   ctime;   /* creation time of the file */
	unsigned short uid;     /* user ID of file */
	unsigned short gid;     /* group ID of the file */
	char           *link;   /* if this field is available, then it represent the 
				 * linked to file */
} ZipUnixExtra;

ZipStatus cxZipFindExtra(ZipExtra *extra, int type);
 
#endif /* _MOD_EXTRA_H_ */
