/**
 * @file tar.h Tar module
 * 
 * $Id: tar.h,v 1.4 2003/01/01 06:22:33 chipx86 Exp $
 *
 * @Copyright (C) 1999-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _TAR_H_
#define _TAR_H_

#include <libcomprex/internal.h>

#include "header.h"

#if 0
typedef struct _Tar Tar;

typedef enum
{
	DEFAULT_FORMAT,   /**< Format to be decided later.        */
	V7_FORMAT,        /**< Old V7 tar format.                 */
	OLDGNU_FORMAT,    /**< GNU format as per before tar 1.12. */
	USTAR_FORMAT,     /**< USTAR format.                      */
	GNU_FORMAT        /**< POSIX format with GNU extensions.  */

} TarType;

struct _Tar
{
	FILE     *fp;
	TarType   type;
	TarBlock  block;
};
#endif

CxStatus cxTarReadBlock(CxFP *fp, TarBlock *block);

int cxTarOctalToInt(const char *s);

/*
int tarIoError(TarInfo *info);

int tarSetModes(TarInfo *info);
int tarMkDir(TarInfo *info);
int tarMakeHardlink(TarInfo *info);
int tarMakeSymlink(TarInfo *info);
int tarMakeSpecial(TarInfo *info);

int tarDecodeHeader(char *block, TarInfo *info);
int tarExtractNextFile(TarInfo *info);
*/

#endif /* _TAR_H_ */

