/**
 * @file libcomprex/internal.h Internal functions
 * 
 * $Id: internal.h,v 1.25 2003/01/01 06:22:36 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBCOMPREX_INTERNAL_H_
#define _LIBCOMPREX_INTERNAL_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif

#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else
char *getenv();
extern int errno;
# ifdef HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
# define LB_REGISTER(ptr, dataSize) \
	lbRegister((ptr), (dataSize), __FILE__, __LINE__, LEAKBUG_DEBUG_LEVEL)
# define LB_REGISTER_ARRAY(ptr, dataSize, numElements) \
	lbRegisterArray((void **)(ptr), (dataSize), (numElements), \
					__FILE__, __LINE__, LEAKBUG_DEBUG_LEVEL)
#else
# define LB_REGISTER(ptr, dataSize)
# define LB_REGISTER_ARRAY(ptr, dataSize, numElements)
#endif

#include <libcomprex/comprex.h>
#include <stdio.h>
#include <errno.h>

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#else
# include <sys/file.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#include <utime.h>

#ifdef ENABLE_NLS
# include <libintl.h>
# undef _ 
# define _(String) dgettext(PACKAGE, String) 
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif
#else
# define textdomain(String) (String)
# define gettext(String) (String)
# define dgettext(Domain,Message) (Message)
# define dcgettext(Domain,Message,Type) (Message)
# define bindtextdomain(Domain,Directory) (Domain)
# define _(String) (String)
# define N_(String) (String)
#endif


#ifdef __cplusplus
extern "C" {
#endif

#define MEM_CHECK(tmp) \
	if ((tmp) == NULL) { \
		fprintf(stderr, _("Error: Out of memory in %s, line %d\n"), \
				__FILE__, __LINE__); \
		exit(EXIT_FAILURE); \
	}

const char *cxGetUserName();
const char *cxGetRealName();
const char *cxGetHomeDir();
const char *cxGetTempDir();

void cxCleanupEnvInfo();

char **cxListDir(const char *dir, int *fileCount, const char *prefix);
void cxFreeDirList(char **files, int fileCount);

void cxProcessUri(const char *uri, char **scheme, char **path);

char *cxMakeTempFilename(void);

CxModule *cxFindOwnerModule(CxArchive *archive, CxFP *fp);

char cxOpenArchiveOrFile(const char *path, CxAccessMode mode,
						 CxFP **destFp, CxArchive **destArchive);
char cxOpenArchiveOrFile2(CxFP *fp, CxAccessMode mode, CxFP **destFp,
						  CxArchive **destArchive);

char cxInternalOpenStream(FILE *stream, CxAccessMode mode, CxFP **destFp,
						  CxArchive **destArchive);
char cxInternalOpenBuffer(char *buffer, size_t size, CxAccessMode mode,
						  CxFP **destFp, CxArchive **destArchive);

CxStatus cxInternalExtractFile(CxFile *file, const char *destPath);

#ifdef __cplusplus
}
#endif

#endif /* _LIBCOMPREX_INTERNAL_H_ */

