# $Id: libcomprex.spec.in,v 1.13 2003/03/06 06:09:26 chipx86 Exp $

%define name    libcomprex
%define ver     0.3.3
%define RELEASE 1
%define rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix  /usr
%{expand:%%define share %(if [ -d %{prefix}/share/man ]; then echo /share ; else echo %%{nil} ; fi)}
%ifos linux
%define CONFIG_FLAGS --prefix=%prefix --infodir='%{prefix}%{share}/info' --mandir='%{prefix}%{share}/man'
%else
%define CONFIG_FLAGS --prefix=%prefix
%endif

Summary:    GNUpdate (de)compression library.
Name:       %name
Version:    %ver
Release:    %rel
License:    LGPL
Group:      Development/Libraries
Source:     http://prdownloads.sourceforge.net/gnupdate/%{name}-%{ver}.tar.gz
URL:        http://www.gnupdate.org/
Prefix:     %prefix
BuildRoot:  %{_tmppath}/%{name}-%{ver}-root
Packager:   Christian Hammond <chipx86@gnupdate.org>

%description
The libcomprex library transparently handles automatic compression and
decompression of files. The API is similar to C's built-in file access
functions, which provides a smooth transition to libcomprex. libcomprex
can also open uncompressed files, making it a good replacement for the
native file access functions.


%package      devel
Summary:      Headers for developing programs that use libcomprex.
Group:        Development/Libraries
Requires:     %name = %{PACKAGE_VERSION}

%description  devel
This package contains the header files that programmers would use to
develop prorgams that use the libcomprex library.

%prep
%setup

%build
if [ ! -z "`echo -n ${RPM_OPT_FLAGS} | grep pentium`"]; then
	if [ ! -z `which egcs` ]; then
		CCC="egcs"
	else
		if [ ! -z `which pgcc` ]; then
			CC="pgcs"
		fi
	fi
	CFLAGS="${RPM_OPT_FLAGS}"
else
	CFLAGS="${RPM_OPT_FLAGS}"
fi

#if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh %{CONFIG_FLAGS}
#else
#	CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
#fi

make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%{_libdir}/*.so.*
%{_libdir}/comprex/archive/*.so
%{_libdir}/comprex/archive/*.a
%{_libdir}/comprex/archive/*.la
%{_libdir}/comprex/scheme/*.so
%{_libdir}/comprex/scheme/*.a
%{_libdir}/comprex/scheme/*.la
%{_datadir}/locale/*/*/*


%doc AUTHORS COPYING ChangeLog NEWS README TODO

%files devel
%defattr(-, root, root)

%doc docs/api/html

%{_bindir}/*
%{_libdir}/*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/pkgconfig/libcomprex.pc
%{_includedir}/*
%{_datadir}/aclocal/*
%{_mandir}/man1/*
%{_mandir}/man3/*

##########################################################################

%changelog
* Wed Jul 10 2002 Christian Hammond <chipx86@gnupdate.org>
- Bumped the version up to v0.3.3.

* Mon Jun 3 2002 Christian Hammond <chipx86@gnupdate.org>
- Bumped the version up to v0.3.2.

* Thu May 30 2002 Christian Hammond <chipx86@gnupdate.org>
- Added the archive and scheme modules.
- Fixed up the paths to be more compliant with RPM's variables.

* Fri May 11 2002 Christian Hammond <chipx86@gnupdate.org>
- Bumped the version up to v0.3.1.
- Fixed the source tarball link.
- Fixed the BuildRoot.

* Fri May 10 2002 Christian Hammond <chipx86@gnupdate.org>
- Bumped the release up to v0.3.0.

* Wed Dec 19 2001 Christian Hammond <chipx86@gnupdate.org>
- Updated my e-mail address.

* Thu Aug 23 2001 Christian Hammond <chipx86@portaldesign.net>
- Created the first version of libcomprex.spec.

