# This is the ABC CGI setup on kendy.jc.tzo.net

	@blacklist = (	# Patterns to reject IP addresses.
		'^192\.169\.41\..*$',	# Search engine that invokes CGI scripts.
		'^209\.86\.219\.23$',	# Search engine that invokes CGI scripts.
		'^209\.202\.148\.52',	# Search engine from fast-search.net.
	);
	$webdir = 		# Where our web files are installed.
		"/home/jc/p";
	$usrurl =		# User id part of URLs.
		"/~jc";
	$cgidir =		# Where CGI scripts are kept.
		"$webdir/cgi/abc";
	$cgiurl = 		# Where to find CGI scripts.
		"/~jc/cgi/abc";
	$abcdir =		# Full path to ABC directory.
		"$webdir/music/abc";
	$abcurl =		# URL for ABC directory.
		"/~jc/music/abc";
	$indexdir =		# Where to find the ABC index files.
		"$webdir/music/index";
	$snmpdir = 		# Where SNMP stuff is installed here.
		"$webdir/snmp";
	%ABCdir = (		# Paths to various ABC directories.
		'500' => 'music/book/500',
		'abc' => 'music/abc',
		'bot' => 'music/bot',
		'contrib' => 'music/abc/contrib',
		'index' => 'music/index',
		'oneills' => 'music/book/oneills',
		'playford' => 'music/book/playford',
		'ryan-cole' => 'music/book/ryan-cole',
		'RJ' => 'music/book/RJ',
	);
	%ABCttl = (		# Titles for various ABC directories.
		'500' => '500 Tunes of the British Isles',
		'abc' => "JC's ABC Tune Archive",
		'bot' => "JC's ABC Web Bot",
		'contrib' => 'ABC Contributions',
		'index' => "JC's ABC index",
		'oneills' => "Online O'Neill's Collection",
		'playford' => 'Online Playford Collection',
		'ryan-cole' => 'Online Ryan/Cole Collection',
		'RJ' => 'Roaring Jelly Collection',
	);
	push @INC, "$cgidir", "$cgidir/abc";
	$ENV{PATH} = "$cgidir:$cgidir/abc:/usr/eecs/bin:$ENV{PATH}";
	$tmpdir =		# Where to put files.
		"$webdir/tmp";
	$tmpurl =		# Where to find tmp files.
		"/~jc/tmp";
	push @INC, "$cgidir", "$cgidir/abc";
	$ENV{PATH} = "$cgidir:$cgidir/abc:$ENV{PATH}";
	use CGI_Lite;	# Required perl module.
	use CGI::Carp 'fatalsToBrowser';
