# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# SYNOPSIS
#   URLdata(*FD,$URL) || die "...";
#
# DESCRIPTION
#   This routine accepts a URL and attempts to open it  for  reading.
#   If  successful,  the  return  value is 1, and FD will be the open
#   file (a socket, actually).  The caller can read the data from it.
#   If  you're  not  going  to exit after the EOF, t's a good idea to
#   close it when you're done, to prevent the connection from hanging
#   around.
#
# REQUIRES
#   We require the HTTPcon.pm and HTMLdir.pm modules.
#
# AUTHOR
#   <a href="mailto:jc@trillian.mit.edu">John Chambers</a>
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
sub URLdata {
	local(*F,$url) = @_;
	local($p,$P,$h,$f);
	print V "URLdata: \"$url\"\n" if $V>4;
	if (($p,$h,$f) = ($url =~ m'^(\w+)://([-_.:\w]+)(/.*)')) {
		print V "URLdata: \"$url\" p=\"$p\" h=\"$h\" f=\"$f\"\n" if $V>2;
		require "HTTPcon.pm";
		($P = $p) =~ tr/a-z/A-Z/;
		if ($P eq 'HTTP') {
			print V "URLdata: \"$url\" HTTP protocol\n" if $V>2;
			if (&HTTPcon(*F,$h)) {
				print V "URLdata: Connected to \"$h\"\n" if $V>2;
				print V "URLdata: Send \"GET $f\" command.\n" if $V>4;
				print F "GET $f\n";
				return 1;
			}
			print V "URLdata: Can't connect to \"$h\"\n" if $V>0;
			return 0;
		}
		print V "URLdata: \"$url\" can't do protocol \"$p\"\n" if $V>0;
		$exitstat = 254;
		return 0;
	}
	if (-d $url) {
		print V "URLdata: Directory \"$url\" ...\n" if $V>4;
		require "HTMLdir.pm";
		return &HTMLdir(*F,$url);
	}
	if (open(F,$url)) {
		print V "URLdata: Local file \"$url\" opened.\n" if $V>4;
		return 1;
	}
	print V "URLdata: Can't read \"$url\"\n" if $V>0;
	return 0;
}
1;
