#ifndef _musicH
#define _musicH

/*
 *  This file is part of jcabc2ps,
 *  Copyright (C) 1996,1997,1998  Michael Methfessel
 *  See file jcabc2ps.c for details.
 */

#include <stdio.h>
#include "jcabc2ps.h"

#define XP_START   0
#define XP_END     (maxSyms-1)
#define XP_NIL    -10

#define ABS(a)  ((a)>0) ? (a) : (-a)
#define AT_LEAST(a,b)  if((a)<(b)) a=b;

float nwid (float dur);

float xwid (float dur);

int next_note (int k, int n, struct SYMBOL symb[]);
int prec_note (int k, int n, struct SYMBOL symb[]);

int followed_by_note (int k, int n, struct SYMBOL symb[]);

Ksig *copyKsig( Ksig *k1, Ksig *k2);

int preceded_by_note (int k, int n, struct SYMBOL symb[]);

void xch (int *i, int *j);

void print_linetype (int t);

void print_syms(int num1, int num2, struct SYMBOL symb[]);

void print_vsyms (void);

void set_head_directions (struct SYMBOL *s);

void set_minsyms(int ivc);

void set_sym_chars (int n1, int n2, struct SYMBOL symb[]);

void set_beams (int n1, int n2, struct SYMBOL symb[]);

void setStems (int n1, int n2, struct SYMBOL symb[]);

int set_sym_times (int n1, int n2, struct SYMBOL symb[], struct METERSTR meter0);

void setSymWidths (int ns1, int ns2, struct SYMBOL symb[], int ivc);

int contract_keysigs (int ip1);

int set_initsyms (int v, float *wid0);

void print_poslist (void);

int insert_poslist (int nins);

void set_poslist (void);

void set_xpwid(void);

void set_spaces (void);

int check_overflow (int ip1, int ip2, float width);

float set_glue (int ip1, int ip2, float width);

void adjGroup(int i1, int i2);

void adjSpace (int n);

void adjRests (int n, int v);

int copy_vsyms (int v, int ip1, int ip2, float wid0);

void draw_timesig (float x, struct SYMBOL s);

int draw_keysig (int sn, float x, struct SYMBOL s);

void drawBar (float x, float w, float d, Sym *s);

void drawBarnums (FILE *fp);

void update_endings (float x, struct SYMBOL s);

void set_ending (int i);

void drawEnds (void);

void drawRest (float x, float w, float d, float yy, struct SYMBOL s, float *achy, float *anny);

void drawGraceNotes (float x, float w, float d, struct SYMBOL *s);

void drawBasicNote (float x, float w, float d, struct SYMBOL *s, int m);

float drawDecos (float x, struct SYMBOL *s, float *tp);

float drawNote (float x, float w, float d, struct SYMBOL *s, int fl, float *achy, float *anny);

float vsh (float x, int dir);

float rnd3(float x);

float rnd6(float x);

float b_pos (int stem, int flags, float b);

int calculate_beam (int i0, struct BEAM *bm);

float rest_under_beam (float x, int head, struct BEAM *bm);

void drawBeamN (struct BEAM *bm, int num, float xn);

void drawBeam (float x1, float x2, float dy, struct BEAM *bm);

void drawBeams (struct BEAM *bm);

float extreme (float s, float a, float b);

void draw_bracket (int p, int j1, int j2);

void drawNPletBkts (void);

float slur_direction (int k1, int k2);

void outSlur (float x1, float y1, float x2, float y2, float s, float height, float shift);

void drawSlur (int k1, int k2, int nn, int level);

int next_scut (int i);
int prev_scut(int i);

void drawChSlurs(int k1, int k2, int nh1, int nh2, int nslur, int mhead1[MAXHD], int mhead2[MAXHD], int job);

void drawSlurs (int k1, int k2, int job);

void drawPhrasing (int k1, int k2, int level);

void drawAllSlurs (void);

void drawAllPhrasings (void);

void check_bars1 (int ip1, int ip2);

void check_bars2 (int ip1, int ip2);

void drawVocals (FILE *fp, int nwl, float botnote, float bspace, float *botpos);

void drawSyms (FILE *fp, float bspace, float *bpos, int is_top);

void drawSysBars (FILE *fp, int ip1, int ip2, float wid0, float h1, float dh);

int count_symbols (void);

int select_piece (int ip1);

int is_topvc (int jv);

int vc_select (void);

float voice_label (FILE *fp, char *label, float h, float xc, float dx0, int job);

void mstave_deco (FILE *fp, int ip1, int ip2, float wid0, float hsys, float htab[]);

void outMusic (FILE *fp);

void doTextBlock(FILE *fpin, FILE *fp, int job);

void doPSComment (FILE *fpin, FILE *fp, char line[]);

void check_selected(FILE *fp, char xref_str[], int npat, char pat[][STRL1], int sel_all,int search_field);

void doLine (FILE *fp, int type, char xref_str[], int npat, char pat[][STRL1], int sel_all, int search_field);

void doFile (FILE *fpin, FILE *fpout, char xref_str[], int npat, char pat[][STRL1], int sel_all, int search_field);

#endif
