/*-
 * Copyright (c) 1999-2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipa_main.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_MAIN_H
#define IPA_MAIN_H

#include <signal.h>

#define IPA_NAME	"ipa"

#ifdef WITH_PTHREAD
extern int	Sigprocmask(int, const sigset_t *, sigset_t *);
# define SIGPROCMASK_NAME "pthread_sigmask"
# define MEMTYPE_FLAGS	IPA_MEMFUNC_FLAG_PTHREAD
#else
# define Sigprocmask sigprocmask
# define SIGPROCMASK_NAME "sigprocmask"
# define MEMTYPE_FLAGS	0
#endif /* WITH_PTHREAD */

#define MARRAY_NAME(x)	IPA_NAME ":" #x
#define MZONE_NAME(x)	IPA_NAME ":" #x
#define MTYPE_NAME(x)	IPA_NAME ":m_" #x

#define MEMFLAG_OPTIMIZE IPA_MEMFUNC_FLAG_OPTIMIZE

extern ipa_mem_type *m_anon;
extern ipa_mem_type *m_tmp;

extern unsigned int main_check_sec;

extern const uint64_t uint64_zero;
extern const uint64_t uint64_max;

extern sigset_t	sigmask;
extern sigset_t	zeromask;

extern int	ipa_main(void);

extern int	init_all(void);
extern int	deinit_all(void);
extern int	free_all(void);

extern void	sig_chld(int);
extern void	sig_hup(int);
extern void	sig_term(int);

extern int	stdout_read;
extern int	stderr_read;

extern int	fd_set_nonblock(int);

extern char	debug;

extern uid_t	myuid;
extern gid_t	mygid;

extern volatile sig_atomic_t need_check_flag;

extern char	dump_flag;
extern char	freeze_flag;

#if defined(WITH_THRESHOLDS) || defined(WITH_SUBLIMITS)
extern uint64_t	uint64_per_cent(const uint64_t *, unsigned int);
#endif

#endif /* !IPA_MAIN_H */
