/*-
 * Copyright (c) 2000-2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipa_db.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_DB_H
#define IPA_DB_H

/*
 * Database module, "db_mod" parameter.
 */
struct db_mod {
	SLIST_ENTRY(db_mod) link;	/* For list building. */
	char		*mod_file;	/* Module's file name. */
	dl_handle	mod_handle;	/* dl-handle. */
	struct ipa_db_mod *ipa_db_mod;	/* Module's struct ipa_db_mod. */
	struct conf_sect_hash *conf_sect_hash; /* Section hash tabel. */
	struct conf_param_hash *conf_param_hash; /* Parameter hash table. */
};

/*
 * List of all database modules.
 */
SLIST_HEAD(db_mod_list, db_mod);

/*
 * One element in "db_list" parameter.
 */
struct db_elem {
	STAILQ_ENTRY(db_elem) link;	/* For list building. */
	const char	*mod_file;	/* db_mod { mod_file } */
	const struct ipa_db_mod *ipa_db_mod; /* db_mod { ipa_db_mod } */
};

/*
 * "db_list" parameter's elements.
 */
STAILQ_HEAD(db_list, db_elem);

/*
 * One "db_list" parameter.
 */
struct db_set {
	SLIST_ENTRY(db_set) link;	/* For list building. */
	struct db_list	list;		/* All elements in "db_list". */
};

/*
 * List of all db_set.
 */
SLIST_HEAD(db_sets, db_set);

extern unsigned int ndb_mods;

extern signed char debug_db_null;

extern const struct db_list *global_db_list;

extern struct db_mod_list db_mod_list;

extern struct db_sets db_sets;

extern struct db_mod *db_mod_by_prefix(const char *);
extern struct db_mod *db_mod_by_name(const char *);

extern void	free_db_set(struct db_set *);
extern void	free_db_lists(void);

extern void	db_set_mod_used(const struct db_list *);

extern int	pre_init_db_mods(void);
extern int	init_db_mods(void);
extern int	deinit_db_mods(void);

struct rule;
extern int	db_update_rule(const struct rule *, const uint64_t *);
extern int	db_append_rule(struct rule *, const uint64_t *, int);
extern int	db_set_rule_active(const struct rule *, int);
extern int	db_deinit_rule(const struct rule *);

#ifdef WITH_RULES
extern int	db_init_statrule(struct rule *);
#endif

#ifdef WITH_AUTORULES
struct autorule;
extern int	db_init_dynrule(const struct autorule *, struct rule *);
#endif

#ifdef WITH_LIMITS
struct limit;
extern int	db_deinit_limit(const struct rule *, const struct limit *);
extern int	db_update_limit(const struct rule *, const struct limit *);
extern int	db_limit_event(const struct rule *, struct limit *,
		    unsigned int, const ipa_tm *);
extern int	db_get_limit_state(const struct rule *, const struct limit *,
		    struct ipa_limit_state *, const char **);
extern int	db_set_limit_state(const struct rule *, struct limit *,
		    struct ipa_limit_state *, int);
extern int	db_set_limit_active(const struct rule *, const struct limit *,
		    int);
#endif

#ifdef WITH_THRESHOLDS
struct threshold;
extern int	db_deinit_threshold(const struct rule *,
		    const struct threshold *);
extern int	db_update_threshold(const struct rule *,
		    const struct threshold *);
extern int	db_get_threshold_state(const struct rule *,
		    const struct threshold *, struct ipa_threshold_state *,
		    const char **);
extern int	db_set_threshold_state(const struct rule *,
		    const struct threshold *,
		    const struct ipa_threshold_state *);
extern int	db_set_threshold_active(const struct rule *,
		    const struct threshold *, int);
#endif

#endif /* !IPA_DB_H */
