// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Media Services API
//
// Media Services (includes Media Flow and Media Streams) is a fully managed service for processing media (video) source content. Use Media Flow and Media Streams to transcode and package digital video using configurable workflows and stream video outputs.
// Use the Media Services API to configure media workflows and run Media Flow jobs, create distribution channels, ingest assets, create Preview URLs and play assets. For more information, see Media Flow (https://docs.cloud.oracle.com/iaas/Content/dms-mediaflow/home.htm) and Media Streams (https://docs.cloud.oracle.com/iaas/Content/dms-mediastream/home.htm).
//

package mediaservices

import (
	"strings"
)

// MediaAssetDistributionChannelAttachmentSortByEnum Enum with underlying type: string
type MediaAssetDistributionChannelAttachmentSortByEnum string

// Set of constants representing the allowable values for MediaAssetDistributionChannelAttachmentSortByEnum
const (
	MediaAssetDistributionChannelAttachmentSortByMediaAssetId          MediaAssetDistributionChannelAttachmentSortByEnum = "mediaAssetId"
	MediaAssetDistributionChannelAttachmentSortByDistributionChannelId MediaAssetDistributionChannelAttachmentSortByEnum = "distributionChannelId"
	MediaAssetDistributionChannelAttachmentSortByDisplayName           MediaAssetDistributionChannelAttachmentSortByEnum = "displayName"
	MediaAssetDistributionChannelAttachmentSortByVersion               MediaAssetDistributionChannelAttachmentSortByEnum = "version"
)

var mappingMediaAssetDistributionChannelAttachmentSortByEnum = map[string]MediaAssetDistributionChannelAttachmentSortByEnum{
	"mediaAssetId":          MediaAssetDistributionChannelAttachmentSortByMediaAssetId,
	"distributionChannelId": MediaAssetDistributionChannelAttachmentSortByDistributionChannelId,
	"displayName":           MediaAssetDistributionChannelAttachmentSortByDisplayName,
	"version":               MediaAssetDistributionChannelAttachmentSortByVersion,
}

var mappingMediaAssetDistributionChannelAttachmentSortByEnumLowerCase = map[string]MediaAssetDistributionChannelAttachmentSortByEnum{
	"mediaassetid":          MediaAssetDistributionChannelAttachmentSortByMediaAssetId,
	"distributionchannelid": MediaAssetDistributionChannelAttachmentSortByDistributionChannelId,
	"displayname":           MediaAssetDistributionChannelAttachmentSortByDisplayName,
	"version":               MediaAssetDistributionChannelAttachmentSortByVersion,
}

// GetMediaAssetDistributionChannelAttachmentSortByEnumValues Enumerates the set of values for MediaAssetDistributionChannelAttachmentSortByEnum
func GetMediaAssetDistributionChannelAttachmentSortByEnumValues() []MediaAssetDistributionChannelAttachmentSortByEnum {
	values := make([]MediaAssetDistributionChannelAttachmentSortByEnum, 0)
	for _, v := range mappingMediaAssetDistributionChannelAttachmentSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetMediaAssetDistributionChannelAttachmentSortByEnumStringValues Enumerates the set of values in String for MediaAssetDistributionChannelAttachmentSortByEnum
func GetMediaAssetDistributionChannelAttachmentSortByEnumStringValues() []string {
	return []string{
		"mediaAssetId",
		"distributionChannelId",
		"displayName",
		"version",
	}
}

// GetMappingMediaAssetDistributionChannelAttachmentSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingMediaAssetDistributionChannelAttachmentSortByEnum(val string) (MediaAssetDistributionChannelAttachmentSortByEnum, bool) {
	enum, ok := mappingMediaAssetDistributionChannelAttachmentSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
